/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.di.law.warc.filters;

import it.unimi.di.law.bubing.util.BURL;
import it.unimi.di.law.warc.filters.AbstractFilter;
import it.unimi.di.law.warc.filters.Filter;
import it.unimi.dsi.fastutil.ints.IntArrays;
import java.net.URI;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DuplicateSegmentsLessThan
extends AbstractFilter<URI> {
    private static final boolean DEBUG = false;
    private static final boolean ASSERTS = false;
    private static final char EXTRA_SYMBOL = '\uffff';
    private final int threshold;

    public DuplicateSegmentsLessThan(int threshold) {
        if (threshold < 2) {
            throw new IllegalArgumentException("This filter requires a threshold larger than one");
        }
        this.threshold = threshold;
    }

    private void matches(boolean b, String s) {
        Matcher m0 = Pattern.compile(".*(/.*)\\1{" + (this.threshold - 1) + ",}/.*").matcher(s);
        Matcher m1 = Pattern.compile(".*(/.*)\\1{" + (this.threshold - 1) + ",}").matcher(s);
        assert (b != (m0.matches() || m1.matches())) : s + " (" + !b + (!b ? "" : ", " + (m0.matches() ? m0.group(1) : m1.group(1))) + ")";
    }

    public boolean apply(URI url) {
        int length;
        String s = url.getRawPath();
        boolean pathEndsWithSlash = s.charAt((length = s.length()) - 1) == '/';
        char[] path = new char[length + 1 + (!pathEndsWithSlash ? 1 : 0)];
        path[path.length - 1] = 65535;
        if (!pathEndsWithSlash) {
            path[path.length - 2] = 47;
        }
        s.getChars(0, length, path, 0);
        int c = 0;
        int i = length;
        while (i-- != 0) {
            if (path[i] != '/') continue;
            ++c;
        }
        if (c < this.threshold) {
            return true;
        }
        int[] start = new int[c];
        c = 0;
        for (int i2 = 0; i2 < length; ++i2) {
            if (path[i2] != '/') continue;
            start[c++] = i2;
        }
        int[] a = new int[c];
        int i3 = c;
        while (i3-- != 0) {
            a[i3] = i3;
        }
        IntArrays.quickSort((int[])a, (int)0, (int)c, (x, y) -> {
            if (x == y) {
                return 0;
            }
            int j = start[x];
            int k = start[y];
            while (path[++j] == path[++k]) {
            }
            return path[j] - path[k];
        });
        int[] r = new int[c];
        int i4 = c;
        while (i4-- != 0) {
            r[a[i4]] = i4;
        }
        int[] lcp = new int[c + 1];
        int h = 0;
        int p = 1;
        boolean maxNonZero = false;
        for (int i5 = 0; i5 < c; ++i5) {
            if (r[i5] <= 0) continue;
            int j = a[r[i5] - 1];
            int starti = start[i5];
            int startj = start[j];
            while (path[starti + p] == path[startj + p]) {
                if (path[starti + p] == '/') {
                    ++h;
                }
                ++p;
            }
            lcp[r[i5]] = h;
            if (h > 0) {
                maxNonZero = true;
                int k = 1;
                while (path[starti + k] != '/') {
                    ++k;
                }
                p -= k;
                --h;
                continue;
            }
            p = 1;
        }
        if (!maxNonZero) {
            return true;
        }
        int[] ls = new int[c + 1];
        int[] ds = new int[c + 1];
        int[] prog = new int[c];
        ds[0] = -1;
        ls[0] = -1;
        p = 1;
        for (int i6 = 0; i6 < c; ++i6) {
            int llca = i6;
            int dlca = lcp[i6 + 1];
            while (ds[p - 1] > dlca) {
                int l = ls[--p];
                int d = ds[p];
                if (i6 - l + 1 >= this.threshold) {
                    Arrays.fill(prog, l, i6 + 1, 0);
                    for (int j = l; j <= i6; ++j) {
                        int pos;
                        int u;
                        if (prog[j] != 0) continue;
                        int t = 1;
                        int k = u = a[j];
                        while ((k += d) < c && (pos = r[k]) >= l && i6 >= pos) {
                            if (prog[pos] != 0) {
                                t += prog[pos];
                                break;
                            }
                            ++t;
                        }
                        if (t >= this.threshold) {
                            return false;
                        }
                        prog[j] = t;
                        while ((k -= d) != u) {
                            prog[r[k]] = -1;
                        }
                    }
                }
                llca = l;
            }
            if (ds[p - 1] >= dlca) continue;
            ls[p] = llca;
            ds[p++] = dlca;
        }
        return true;
    }

    public static DuplicateSegmentsLessThan valueOf(String spec) {
        return new DuplicateSegmentsLessThan(Integer.parseInt(spec));
    }

    public String toString() {
        return this.toString(Integer.toString(this.threshold));
    }

    public boolean equals(Object x) {
        return x instanceof DuplicateSegmentsLessThan && ((DuplicateSegmentsLessThan)x).threshold == this.threshold;
    }

    public int hashCode() {
        return this.threshold ^ DuplicateSegmentsLessThan.class.hashCode();
    }

    public static void main(String[] arg) {
        int rep = Integer.parseInt(arg[0]);
        long times = Long.parseLong(arg[1]);
        Pattern p = Pattern.compile(".*/(.*/)\\1{" + (rep - 1) + ",}.*");
        String uri = "http://example.com/test/foo/bar1/foo/bar2/foo/mu/foo/bar3/foo/bar4/foo/bar5/test/foo/bar1/foo/bar2/foo/mu/foo/bar3/foo/bar4/foo/bar5/test/";
        DuplicateSegmentsLessThan filter = new DuplicateSegmentsLessThan(rep);
        URI buri = BURL.parse(uri);
        System.err.println("Regex: " + !p.matcher(uri).matches());
        System.err.println("Filter: " + filter.apply(buri));
        int k = 10;
        while (k-- != 0) {
            long start = -System.currentTimeMillis();
            long i = times;
            while (i-- != 0L) {
                Matcher m = p.matcher(uri);
                m.matches();
            }
            System.err.printf("Regex: %f Kcalls/s\n", (double)times / (double)(start += System.currentTimeMillis()));
            start = -System.currentTimeMillis();
            i = times;
            while (i-- != 0L) {
                filter.apply(buri);
            }
            System.err.printf("Filter: %f Kcalls/s\n", (double)times / (double)(start += System.currentTimeMillis()));
        }
    }

    public Filter<URI> copy() {
        return this;
    }
}

