/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.di.law.warc.filters;

import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import it.unimi.di.law.warc.filters.AbstractFilter;
import it.unimi.di.law.warc.filters.Filter;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.net.URI;
import java.util.Arrays;

public class HostEndsWithOneOf
extends AbstractFilter<URI> {
    private static final Splitter SPLITTER = Splitter.on((char)',').trimResults().omitEmptyStrings();
    private final String[] suffixes;

    public HostEndsWithOneOf(String[] suffixes) {
        this.suffixes = new String[suffixes.length];
        for (int i = 0; i < suffixes.length; ++i) {
            this.suffixes[i] = suffixes[i].toLowerCase();
        }
    }

    public boolean apply(URI uri) {
        String host = uri.getHost();
        for (String suffix : this.suffixes) {
            if (!host.endsWith(suffix)) continue;
            return true;
        }
        return false;
    }

    public static HostEndsWithOneOf valueOf(String spec) {
        return new HostEndsWithOneOf((String[])Iterables.toArray((Iterable)SPLITTER.split((CharSequence)spec), String.class));
    }

    public String toString() {
        return this.toString(this.suffixes);
    }

    public boolean equals(Object x) {
        if (x instanceof HostEndsWithOneOf) {
            ObjectOpenHashSet suffixSet = new ObjectOpenHashSet((Object[])this.suffixes);
            ObjectOpenHashSet xSuffixSet = new ObjectOpenHashSet((Object[])((HostEndsWithOneOf)x).suffixes);
            return suffixSet.equals(xSuffixSet);
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.suffixes) ^ HostEndsWithOneOf.class.hashCode();
    }

    public Filter<URI> copy() {
        return this;
    }
}

