/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.di.law.warc.filters;

import it.unimi.di.law.warc.filters.AbstractFilter;
import it.unimi.di.law.warc.filters.Filter;
import java.net.URI;

public class HostEquals
extends AbstractFilter<URI> {
    private final String host;

    public HostEquals(String host) {
        this.host = host;
    }

    public boolean apply(URI uri) {
        if (uri.getHost() == null) {
            throw new IllegalArgumentException("URI \"" + uri + "\" has no host");
        }
        return uri.getHost().equals(this.host);
    }

    public static HostEquals valueOf(String spec) {
        return new HostEquals(spec);
    }

    public String toString() {
        return this.toString(this.host);
    }

    public boolean equals(Object x) {
        if (x instanceof HostEquals) {
            return ((HostEquals)x).host.equals(this.host);
        }
        return false;
    }

    public int hashCode() {
        return this.host.hashCode() ^ HostEquals.class.hashCode();
    }

    public Filter<URI> copy() {
        return this;
    }
}

