/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.di.law.warc.filters;

import it.unimi.di.law.warc.filters.AbstractFilter;
import it.unimi.di.law.warc.filters.Filter;
import java.net.URI;

public class SchemeEquals
extends AbstractFilter<URI> {
    private final String scheme;

    public SchemeEquals(String scheme) {
        this.scheme = scheme;
    }

    public boolean apply(URI uri) {
        if (uri.getScheme() == null) {
            throw new IllegalArgumentException("URI \"" + uri + "\" has no scheme");
        }
        return this.scheme.equals(uri.getScheme());
    }

    public static SchemeEquals valueOf(String spec) {
        return new SchemeEquals(spec);
    }

    public String toString() {
        return this.toString(this.scheme);
    }

    public boolean equals(Object x) {
        if (x instanceof SchemeEquals) {
            return ((SchemeEquals)x).scheme.equals(this.scheme);
        }
        return false;
    }

    public int hashCode() {
        return this.scheme.hashCode() ^ SchemeEquals.class.hashCode();
    }

    public Filter<URI> copy() {
        return this;
    }
}

