/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.di.law.warc.filters;

import it.unimi.di.law.warc.filters.AbstractFilter;
import it.unimi.di.law.warc.filters.Filter;
import org.apache.http.HttpResponse;

public class StatusCategory
extends AbstractFilter<HttpResponse> {
    private final int category;

    public StatusCategory(int category) {
        this.category = category;
    }

    public boolean apply(HttpResponse x) {
        return x.getStatusLine().getStatusCode() / 100 == this.category;
    }

    public static StatusCategory valueOf(String spec) {
        return new StatusCategory(Integer.parseInt(spec));
    }

    public String toString() {
        return this.toString(String.valueOf(this.category));
    }

    public boolean equals(Object x) {
        if (x instanceof StatusCategory) {
            return ((StatusCategory)x).category == this.category;
        }
        return false;
    }

    public int hashCode() {
        return this.category ^ StatusCategory.class.hashCode();
    }

    public Filter<HttpResponse> copy() {
        return this;
    }
}

