/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.di.law.warc.filters;

import it.unimi.di.law.warc.filters.AbstractFilter;
import it.unimi.di.law.warc.filters.Filter;
import java.net.URI;
import java.util.regex.Pattern;

public class URLMatchesRegex
extends AbstractFilter<URI> {
    private Pattern pattern;

    public URLMatchesRegex(String expr) {
        this.pattern = Pattern.compile(expr);
    }

    private URLMatchesRegex(Pattern pattern) {
        this.pattern = pattern;
    }

    public boolean apply(URI uri) {
        return this.pattern.matcher(uri.toString()).matches();
    }

    public static URLMatchesRegex valueOf(String spec) {
        return new URLMatchesRegex(spec);
    }

    public String toString() {
        return this.toString(this.pattern.pattern());
    }

    public boolean equals(Object x) {
        if (x instanceof URLMatchesRegex) {
            return ((URLMatchesRegex)x).pattern.equals(this.pattern);
        }
        return false;
    }

    public int hashCode() {
        return this.pattern.hashCode() ^ URLMatchesRegex.class.hashCode();
    }

    public Filter<URI> copy() {
        return new URLMatchesRegex(this.pattern);
    }
}

