/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.di.law.warc.io;

import it.unimi.di.law.warc.io.AbstractWarcReader;
import it.unimi.di.law.warc.io.WarcCachingReader;
import it.unimi.di.law.warc.io.WarcFormatException;
import it.unimi.di.law.warc.io.WarcReader;
import it.unimi.di.law.warc.io.gzarc.GZIPArchive;
import it.unimi.di.law.warc.io.gzarc.GZIPArchiveReader;
import it.unimi.di.law.warc.records.WarcRecord;
import java.io.IOException;
import java.io.InputStream;

public class CompressedWarcCachingReader
implements WarcCachingReader {
    private final GZIPArchiveReader gzar;

    public CompressedWarcCachingReader(InputStream input) {
        this.gzar = new GZIPArchiveReader(input);
    }

    @Override
    public void position(long position) throws IOException {
        this.gzar.position(position);
    }

    @Override
    public WarcReader cache() throws IOException {
        final GZIPArchive.ReadEntry e = this.gzar.getEntry(true);
        if (e == null) {
            return null;
        }
        e.lazyInflater.consume();
        return new AbstractWarcReader(){

            @Override
            public WarcRecord read() throws IOException, WarcFormatException {
                super.setInput(e.lazyInflater.get());
                return super.read(false);
            }

            @Override
            public void position(long position) throws IOException {
                throw new UnsupportedOperationException();
            }
        };
    }
}

