/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.di.law.warc.io;

import it.unimi.di.law.warc.io.WarcWriter;
import it.unimi.di.law.warc.io.gzarc.GZIPArchive;
import it.unimi.di.law.warc.io.gzarc.GZIPArchiveWriter;
import it.unimi.di.law.warc.records.WarcRecord;
import it.unimi.di.law.warc.util.ByteArraySessionOutputBuffer;
import java.io.IOException;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompressedWarcWriter
implements WarcWriter {
    private static final Logger LOGGER = LoggerFactory.getLogger(CompressedWarcWriter.class);
    private final GZIPArchiveWriter gzaw;
    private final ByteArraySessionOutputBuffer buffer;

    public CompressedWarcWriter(OutputStream output) {
        this.gzaw = new GZIPArchiveWriter(output);
        this.buffer = new ByteArraySessionOutputBuffer();
    }

    @Override
    public void write(WarcRecord record) throws IOException {
        GZIPArchive.WriteEntry e = this.gzaw.getEntry(record.getWarcRecordId().toString(), record.getWarcType().toString(), record.getWarcDate());
        record.write(e.deflater, this.buffer);
        e.deflater.close();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Written {}", (Object)e);
        }
    }

    @Override
    public void close() throws IOException {
        this.gzaw.close();
    }
}

