/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.di.law.warc.io;

import it.unimi.di.law.warc.io.CompressedWarcWriter;
import it.unimi.di.law.warc.io.UncompressedWarcWriter;
import it.unimi.di.law.warc.io.WarcWriter;
import it.unimi.di.law.warc.records.WarcRecord;
import it.unimi.dsi.Util;
import it.unimi.dsi.fastutil.io.FastByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.ArrayBlockingQueue;

public class ParallelBufferedWarcWriter
implements WarcWriter {
    protected final ArrayBlockingQueue<WriterPair> emptyPairs;
    protected final ArrayBlockingQueue<WriterPair> filledPairs;
    protected final FlushingThread flushingThread;
    protected final OutputStream outputStream;
    protected volatile IOException flushingThreadException;

    public ParallelBufferedWarcWriter(OutputStream outputStream, boolean compress) {
        this(outputStream, compress, 2 * Util.RUNTIME.availableProcessors());
    }

    public ParallelBufferedWarcWriter(OutputStream outputStream, boolean compress, int numberOfBuffers) {
        this.outputStream = outputStream;
        this.emptyPairs = new ArrayBlockingQueue(numberOfBuffers);
        this.filledPairs = new ArrayBlockingQueue(numberOfBuffers);
        int i = numberOfBuffers;
        while (i-- != 0) {
            FastByteArrayOutputStream stream = new FastByteArrayOutputStream();
            this.emptyPairs.add(new WriterPair(compress ? new CompressedWarcWriter((OutputStream)stream) : new UncompressedWarcWriter((OutputStream)stream), stream));
        }
        this.flushingThread = new FlushingThread();
        this.flushingThread.start();
        this.flushingThread.setName(ParallelBufferedWarcWriter.class.getSimpleName());
    }

    @Override
    public void write(WarcRecord record) throws IOException, InterruptedException {
        WriterPair pair = this.emptyPairs.take();
        pair.stream.reset();
        pair.writer.write(record);
        this.filledPairs.add(pair);
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.flushingThreadException != null) {
            throw this.flushingThreadException;
        }
        this.flushingThread.interrupt();
        try {
            this.flushingThread.join();
        }
        catch (InterruptedException shouldntHappen) {
            throw new IOException("Interrupted while joining flushing thread");
        }
        this.outputStream.close();
        this.emptyPairs.clear();
        this.filledPairs.clear();
    }

    private final class FlushingThread
    extends Thread {
        private FlushingThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        @Override
        public void run() {
            block19: {
                WriterPair pair;
                while (true) {
                    if (Thread.currentThread().isInterrupted()) break;
                    pair = ParallelBufferedWarcWriter.this.filledPairs.take();
                    try {
                        ParallelBufferedWarcWriter.this.outputStream.write(((WriterPair)pair).stream.array, 0, ((WriterPair)pair).stream.length);
                    }
                    catch (Exception e) {
                        IOException iOException = ParallelBufferedWarcWriter.this.flushingThreadException = e instanceof IOException ? (IOException)e : new IOException(e);
                        while ((pair = ParallelBufferedWarcWriter.this.filledPairs.poll()) != null) {
                            try {
                                ParallelBufferedWarcWriter.this.outputStream.write(((WriterPair)pair).stream.array, 0, ((WriterPair)pair).stream.length);
                            }
                            catch (Exception e2) {
                                ParallelBufferedWarcWriter.this.flushingThreadException = e2 instanceof IOException ? (IOException)e2 : new IOException(e2);
                                return;
                            }
                        }
                        return;
                    }
                    ParallelBufferedWarcWriter.this.emptyPairs.add(pair);
                    continue;
                    break;
                }
                while ((pair = ParallelBufferedWarcWriter.this.filledPairs.poll()) != null) {
                    try {
                        ParallelBufferedWarcWriter.this.outputStream.write(((WriterPair)pair).stream.array, 0, ((WriterPair)pair).stream.length);
                    }
                    catch (Exception e) {
                        ParallelBufferedWarcWriter.this.flushingThreadException = e instanceof IOException ? (IOException)e : new IOException(e);
                        return;
                    }
                }
                break block19;
                catch (InterruptedException e) {
                    while ((pair = ParallelBufferedWarcWriter.this.filledPairs.poll()) != null) {
                        try {
                            ParallelBufferedWarcWriter.this.outputStream.write(((WriterPair)pair).stream.array, 0, ((WriterPair)pair).stream.length);
                        }
                        catch (Exception e3) {
                            ParallelBufferedWarcWriter.this.flushingThreadException = e3 instanceof IOException ? (IOException)e3 : new IOException(e3);
                            return;
                        }
                    }
                    break block19;
                }
                catch (Throwable throwable) {
                    while ((pair = ParallelBufferedWarcWriter.this.filledPairs.poll()) != null) {
                        try {
                            ParallelBufferedWarcWriter.this.outputStream.write(((WriterPair)pair).stream.array, 0, ((WriterPair)pair).stream.length);
                        }
                        catch (Exception e) {
                            ParallelBufferedWarcWriter.this.flushingThreadException = e instanceof IOException ? (IOException)e : new IOException(e);
                            return;
                        }
                    }
                    throw throwable;
                }
            }
        }
    }

    protected static final class WriterPair
    implements WarcWriter {
        private final WarcWriter writer;
        private final FastByteArrayOutputStream stream;

        private WriterPair(WarcWriter writer, FastByteArrayOutputStream stream) {
            this.writer = writer;
            this.stream = stream;
        }

        @Override
        public void close() throws IOException {
            this.writer.close();
        }

        @Override
        public void write(WarcRecord record) throws IOException, InterruptedException {
            this.writer.write(record);
        }
    }
}

