/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.di.law.warc.io.gzarc;

import it.unimi.di.law.warc.io.gzarc.GZIPArchive;
import it.unimi.dsi.fastutil.io.FastByteArrayOutputStream;
import java.io.Closeable;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;

public class GZIPArchiveWriter
implements Closeable {
    private final CRC32 crc = new CRC32();
    private final Deflater deflater = new Deflater(9, true);
    private final FastByteArrayOutputStream deflaterStream = new FastByteArrayOutputStream();
    private final OutputStream output;

    public GZIPArchiveWriter(OutputStream output) {
        this.output = output;
    }

    @Override
    public void close() throws IOException {
        this.output.close();
    }

    protected void writeEntry(GZIPArchive.Entry entry) throws IOException {
        this.output.write(GZIPArchive.GZIP_START);
        GZIPArchiveWriter.writeLEInt(this.output, entry.mtime);
        this.output.write(GZIPArchive.XFL_OS);
        GZIPArchiveWriter.writeLEShort(this.output, GZIPArchive.XLEN);
        this.output.write(GZIPArchive.SKIP_LEN);
        GZIPArchiveWriter.writeLEShort(this.output, (short)8);
        GZIPArchiveWriter.writeLEInt(this.output, entry.compressedSkipLength);
        GZIPArchiveWriter.writeLEInt(this.output, entry.uncompressedSkipLength);
        this.output.write(entry.name);
        this.output.write(0);
        this.output.write(entry.comment);
        this.output.write(0);
        this.output.write(this.deflaterStream.array, 0, this.deflaterStream.length);
        GZIPArchiveWriter.writeLEInt(this.output, entry.crc32);
        GZIPArchiveWriter.writeLEInt(this.output, entry.uncompressedSkipLength);
    }

    public GZIPArchive.WriteEntry getEntry(String name, String comment, final Date creationDate) {
        this.crc.reset();
        this.deflater.reset();
        this.deflaterStream.reset();
        final GZIPArchive.WriteEntry entry = new GZIPArchive.WriteEntry();
        entry.setName(name);
        entry.setComment(comment);
        entry.deflater = new FilterOutputStream(new DeflaterOutputStream((OutputStream)this.deflaterStream, this.deflater)){
            private final byte[] oneCharBuffer;
            private long length;
            {
                super(arg0);
                this.oneCharBuffer = new byte[1];
                this.length = 0L;
            }

            @Override
            public void write(int b) throws IOException {
                this.oneCharBuffer[0] = (byte)b;
                this.out.write(this.oneCharBuffer);
                GZIPArchiveWriter.this.crc.update(this.oneCharBuffer);
                ++this.length;
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                this.out.write(b, off, len);
                GZIPArchiveWriter.this.crc.update(b, off, len);
                this.length += (long)len;
            }

            @Override
            public void close() throws IOException {
                this.out.flush();
                ((DeflaterOutputStream)this.out).finish();
                entry.compressedSkipLength = GZIPArchive.FIX_LEN + (entry.name.length + 1) + (entry.comment.length + 1) + ((GZIPArchiveWriter)GZIPArchiveWriter.this).deflaterStream.length;
                entry.uncompressedSkipLength = (int)(this.length & 0xFFFFFFFFFFFFFFFFL);
                entry.mtime = (int)(creationDate.getTime() / 1000L);
                entry.crc32 = (int)(GZIPArchiveWriter.this.crc.getValue() & 0xFFFFFFFFFFFFFFFFL);
                GZIPArchiveWriter.this.writeEntry(entry);
            }
        };
        return entry;
    }

    private static void writeLEInt(OutputStream out, int i) throws IOException {
        out.write((byte)i);
        out.write((byte)(i >> 8 & 0xFF));
        out.write((byte)(i >> 16 & 0xFF));
        out.write((byte)(i >> 24 & 0xFF));
    }

    private static void writeLEShort(OutputStream out, short s) throws IOException {
        out.write((byte)s);
        out.write((byte)(s >> 8 & 0xFF));
    }
}

