/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.di.law.warc.processors;

import it.unimi.di.law.warc.processors.ParallelFilteredProcessorRunner;
import it.unimi.di.law.warc.records.WarcRecord;
import it.unimi.dsi.fastutil.io.BinIO;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.io.IOException;
import java.io.PrintStream;

public class URLPositionWriter
implements ParallelFilteredProcessorRunner.Writer<WarcRecord> {
    private final long storeIndexMask;
    private final LongOpenHashSet repeatedSet;

    public URLPositionWriter(String storeIndex, String repeatedSetFile) throws ClassNotFoundException, IOException, IllegalArgumentException {
        this.storeIndexMask = (long)Integer.parseInt(storeIndex) << 48;
        this.repeatedSet = (LongOpenHashSet)BinIO.loadObject((CharSequence)repeatedSetFile);
    }

    @Override
    public void write(WarcRecord warcRecord, long storePosition, PrintStream out) throws IOException {
        if (this.repeatedSet.contains(this.storeIndexMask | storePosition)) {
            return;
        }
        out.print(warcRecord.getWarcTargetURI());
        out.print('\t');
        out.print(storePosition);
        out.write(10);
    }

    @Override
    public void close() throws IOException {
    }
}

