/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.di.law.warc.records;

import com.google.common.io.ByteStreams;
import it.unimi.di.law.bubing.util.BURL;
import it.unimi.di.law.bubing.util.Util;
import it.unimi.di.law.warc.io.WarcFormatException;
import it.unimi.di.law.warc.records.WarcHeader;
import it.unimi.di.law.warc.records.WarcRecord;
import it.unimi.di.law.warc.util.BoundSessionInputBuffer;
import it.unimi.di.law.warc.util.ByteArraySessionOutputBuffer;
import it.unimi.dsi.util.XoRoShiRo128PlusRandomGenerator;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import java.util.UUID;
import org.apache.http.Header;
import org.apache.http.HeaderIterator;
import org.apache.http.ProtocolVersion;
import org.apache.http.message.AbstractHttpMessage;
import org.apache.http.message.BasicLineFormatter;
import org.apache.http.message.HeaderGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractWarcRecord
extends AbstractHttpMessage
implements WarcRecord {
    public static final String USE_BURL_PROPERTY = "it.unimi.di.law.warc.records.useburl";
    private static final boolean USE_BURL = Boolean.parseBoolean(System.getProperty("it.unimi.di.law.warc.records.useburl", "false"));
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractWarcRecord.class);
    private static final XoRoShiRo128PlusRandomGenerator RNG = new XoRoShiRo128PlusRandomGenerator();
    private static final TimeZone UTC_TIMEZONE = TimeZone.getTimeZone("UTC");
    protected final HeaderGroup warcHeaders;

    public AbstractWarcRecord(HeaderGroup warcHeaders) {
        this(null, warcHeaders);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractWarcRecord(URI targetURI, HeaderGroup warcHeaders) {
        UUID id;
        this.warcHeaders = warcHeaders == null ? new HeaderGroup() : warcHeaders;
        XoRoShiRo128PlusRandomGenerator xoRoShiRo128PlusRandomGenerator = RNG;
        synchronized (xoRoShiRo128PlusRandomGenerator) {
            id = new UUID(RNG.nextLong(), RNG.nextLong());
        }
        WarcHeader.addIfNotPresent(this.warcHeaders, WarcHeader.Name.WARC_RECORD_ID, WarcHeader.formatId(id));
        WarcHeader.addIfNotPresent(this.warcHeaders, WarcHeader.Name.WARC_DATE, WarcHeader.formatDate(Calendar.getInstance(UTC_TIMEZONE)));
        if (targetURI != null) {
            WarcHeader.addIfNotPresent(this.warcHeaders, WarcHeader.Name.WARC_TARGET_URI, targetURI.toString());
        }
    }

    public ProtocolVersion getProtocolVersion() {
        return PROTOCOL_VERSION;
    }

    @Override
    public HeaderGroup getWarcHeaders() {
        return this.warcHeaders;
    }

    @Override
    public Header getWarcHeader(WarcHeader.Name header) {
        return WarcHeader.getFirstHeader(this.warcHeaders, header);
    }

    @Override
    public UUID getWarcRecordId() {
        UUID uuid;
        Header header = WarcHeader.getFirstHeader(this.warcHeaders, WarcHeader.Name.WARC_RECORD_ID);
        if (header == null) {
            throw new IllegalStateException((Object)((Object)WarcHeader.Name.WARC_RECORD_ID) + " mandatory header not present");
        }
        try {
            uuid = WarcHeader.parseId(header.getValue());
        }
        catch (WarcFormatException e) {
            throw new IllegalStateException((Object)((Object)WarcHeader.Name.WARC_RECORD_ID) + " '" + header.getValue() + "' falied parsing", e);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Got UUID {}, parsed as {}", (Object)header.getValue(), (Object)uuid);
        }
        return uuid;
    }

    @Override
    public WarcRecord.Type getWarcType() {
        Header header = WarcHeader.getFirstHeader(this.warcHeaders, WarcHeader.Name.WARC_TYPE);
        if (header == null) {
            throw new IllegalStateException((Object)((Object)WarcHeader.Name.WARC_TYPE) + " mandatory header not present");
        }
        return WarcRecord.Type.valueOf(header);
    }

    @Override
    public Date getWarcDate() {
        Header header = WarcHeader.getFirstHeader(this.warcHeaders, WarcHeader.Name.WARC_DATE);
        if (header == null) {
            throw new IllegalStateException((Object)((Object)WarcHeader.Name.WARC_DATE) + " mandatory header not present");
        }
        Date date = null;
        try {
            date = WarcHeader.parseDate(header.getValue());
        }
        catch (WarcFormatException e) {
            throw new IllegalStateException((Object)((Object)WarcHeader.Name.WARC_DATE) + " '" + header.getValue() + "' falied parsing", e);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Got date {}, parsed as {}", (Object)header.getValue(), (Object)date);
        }
        return date;
    }

    @Override
    public long getWarcContentLength() {
        Header header = WarcHeader.getFirstHeader(this.warcHeaders, WarcHeader.Name.CONTENT_LENGTH);
        if (header == null) {
            throw new IllegalStateException((Object)((Object)WarcHeader.Name.CONTENT_LENGTH) + " mandatory header not present");
        }
        return Long.parseLong(header.getValue());
    }

    @Override
    public URI getWarcTargetURI() {
        Header header = WarcHeader.getFirstHeader(this.warcHeaders, WarcHeader.Name.WARC_TARGET_URI);
        if (header == null) {
            throw new IllegalStateException((Object)((Object)WarcHeader.Name.WARC_TARGET_URI) + " header not present");
        }
        if (!USE_BURL) {
            return URI.create(header.getValue());
        }
        URI result = BURL.parse(header.getValue());
        if (result == null) {
            throw new IllegalArgumentException("BURL.parse() found an unfixable syntax error in URL " + header.getValue());
        }
        return result;
    }

    protected abstract InputStream writePayload(ByteArraySessionOutputBuffer var1) throws IOException;

    protected static void writeHeaders(HeaderGroup headers, OutputStream output) throws IOException {
        HeaderIterator it = headers.iterator();
        while (it.hasNext()) {
            Header header = it.nextHeader();
            Util.toOutputStream(BasicLineFormatter.formatHeader((Header)header, null), output);
            output.write(ByteArraySessionOutputBuffer.CRLF);
        }
    }

    @Override
    public void write(OutputStream output, ByteArraySessionOutputBuffer buffer) throws IOException {
        buffer.reset();
        InputStream payload = this.writePayload(buffer);
        long contentLength = buffer.contentLength();
        this.warcHeaders.updateHeader((Header)new WarcHeader(WarcHeader.Name.CONTENT_LENGTH, Long.toString(contentLength)));
        Util.toOutputStream(BasicLineFormatter.formatProtocolVersion((ProtocolVersion)WarcRecord.PROTOCOL_VERSION, null), output);
        output.write(ByteArraySessionOutputBuffer.CRLF);
        AbstractWarcRecord.writeHeaders(this.warcHeaders, output);
        output.write(ByteArraySessionOutputBuffer.CRLF);
        ByteStreams.copy((InputStream)payload, (OutputStream)output);
        output.write(ByteArraySessionOutputBuffer.CRLFCRLF);
    }

    public static WarcRecord fromPayload(HeaderGroup warcHeaders, BoundSessionInputBuffer payloadBuffer) throws IOException, WarcFormatException {
        Header warcTypeHeader = WarcHeader.getFirstHeader(warcHeaders, WarcHeader.Name.WARC_TYPE);
        if (warcTypeHeader == null) {
            throw new WarcFormatException("Missing 'WARC-Type' header");
        }
        Method fromPayloadMethod = null;
        try {
            fromPayloadMethod = WarcRecord.Type.fromPayloadMethod(warcTypeHeader);
        }
        catch (IllegalArgumentException e) {
            throw new WarcFormatException("Unrecognized record type", e);
        }
        try {
            return (WarcRecord)fromPayloadMethod.invoke(null, new Object[]{warcHeaders, payloadBuffer});
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new IOException(e);
        }
    }
}

