/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.di.law.warc.records;

import it.unimi.di.law.warc.io.WarcFormatException;
import it.unimi.di.law.warc.records.AbstractWarcRecord;
import it.unimi.di.law.warc.records.WarcHeader;
import it.unimi.di.law.warc.records.WarcRecord;
import it.unimi.di.law.warc.util.BoundSessionInputBuffer;
import it.unimi.di.law.warc.util.ByteArraySessionOutputBuffer;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Arrays;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.HttpMessage;
import org.apache.http.HttpRequest;
import org.apache.http.ProtocolVersion;
import org.apache.http.RequestLine;
import org.apache.http.impl.io.DefaultHttpRequestParser;
import org.apache.http.impl.io.DefaultHttpRequestWriter;
import org.apache.http.io.SessionInputBuffer;
import org.apache.http.io.SessionOutputBuffer;
import org.apache.http.message.HeaderGroup;

public class HttpRequestWarcRecord
extends AbstractWarcRecord
implements HttpRequest {
    public static final String HTTP_REQUEST_MSGTYPE = "application/http;msgtype=request";
    private final ProtocolVersion protocolVersion;
    private final RequestLine requestLine;

    public HttpRequestWarcRecord(URI targetURI, HttpRequest request) {
        this(null, targetURI, request);
    }

    public static HttpRequestWarcRecord fromPayload(HeaderGroup warcHeaders, BoundSessionInputBuffer payloadBuffer) throws IOException {
        return new HttpRequestWarcRecord(warcHeaders, null, HttpRequestWarcRecord.readPayload(payloadBuffer));
    }

    private HttpRequestWarcRecord(HeaderGroup warcHeaders, URI targetURI, HttpRequest request) {
        super(targetURI, warcHeaders);
        this.getWarcTargetURI();
        this.warcHeaders.updateHeader(WarcRecord.Type.warcHeader(WarcRecord.Type.REQUEST));
        this.warcHeaders.updateHeader((Header)new WarcHeader(WarcHeader.Name.CONTENT_TYPE, HTTP_REQUEST_MSGTYPE));
        this.protocolVersion = request.getProtocolVersion();
        this.requestLine = request.getRequestLine();
        this.setHeaders(request.getAllHeaders());
    }

    private static HttpRequest readPayload(BoundSessionInputBuffer buffer) throws IOException {
        DefaultHttpRequestParser requestParser = new DefaultHttpRequestParser((SessionInputBuffer)buffer);
        try {
            return (HttpRequest)requestParser.parse();
        }
        catch (HttpException e) {
            throw new WarcFormatException("Can't parse the request", e);
        }
    }

    @Override
    public ProtocolVersion getProtocolVersion() {
        return this.protocolVersion;
    }

    public RequestLine getRequestLine() {
        return this.requestLine;
    }

    @Override
    protected InputStream writePayload(ByteArraySessionOutputBuffer buffer) throws IOException {
        DefaultHttpRequestWriter pw = new DefaultHttpRequestWriter((SessionOutputBuffer)buffer);
        try {
            pw.write((HttpMessage)this);
        }
        catch (HttpException e) {
            throw new RuntimeException("Unexpected HtthException", e);
        }
        buffer.contentLength(buffer.size());
        return buffer.toInputStream();
    }

    public String toString() {
        return "Warc headers: " + Arrays.toString(this.warcHeaders.getAllHeaders()) + "\nRequest line: " + this.requestLine + "\nRequest headers: " + Arrays.toString(this.getAllHeaders());
    }
}

