/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.di.law.warc.records;

import it.unimi.di.law.warc.io.WarcFormatException;
import it.unimi.di.law.warc.records.AbstractWarcRecord;
import it.unimi.di.law.warc.records.WarcRecord;
import it.unimi.di.law.warc.util.BoundSessionInputBuffer;
import it.unimi.di.law.warc.util.ByteArraySessionOutputBuffer;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.impl.io.AbstractMessageParser;
import org.apache.http.io.SessionInputBuffer;
import org.apache.http.message.HeaderGroup;

public class InfoWarcRecord
extends AbstractWarcRecord {
    private HeaderGroup info = new HeaderGroup();

    public InfoWarcRecord(Header[] info) {
        this(null, info);
    }

    public static InfoWarcRecord fromPayload(HeaderGroup warcHeaders, BoundSessionInputBuffer payloadBuffer) throws IOException {
        return new InfoWarcRecord(warcHeaders, InfoWarcRecord.readPayload(payloadBuffer));
    }

    private InfoWarcRecord(HeaderGroup warcHeaders, Header[] info) {
        super(warcHeaders);
        this.warcHeaders.updateHeader(WarcRecord.Type.warcHeader(WarcRecord.Type.WARCINFO));
        this.info.setHeaders(info);
    }

    private static Header[] readPayload(BoundSessionInputBuffer buffer) throws IOException {
        try {
            return AbstractMessageParser.parseHeaders((SessionInputBuffer)buffer, (int)-1, (int)-1, null);
        }
        catch (HttpException e) {
            throw new WarcFormatException("Can't parse information", e);
        }
    }

    public HeaderGroup getInfo() {
        return this.info;
    }

    @Override
    protected InputStream writePayload(ByteArraySessionOutputBuffer buffer) throws IOException {
        InfoWarcRecord.writeHeaders(this.info, buffer);
        buffer.contentLength(buffer.size());
        return buffer.toInputStream();
    }

    public String toString() {
        return "Warc headers: " + Arrays.toString(this.warcHeaders.getAllHeaders()) + "\nInfo headers: " + Arrays.toString(this.info.getAllHeaders());
    }
}

