/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.di.law.warc.records;

import it.unimi.di.law.warc.io.WarcFormatException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.UUID;
import org.apache.commons.lang.time.FastDateFormat;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.HeaderGroup;

public class WarcHeader
extends BasicHeader {
    private static final DateFormat W3C_ISO8601_DATE_PARSE = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.ROOT);
    private static final FastDateFormat W3C_ISO8601_DATE_FORMAT = FastDateFormat.getInstance((String)"yyyy-MM-dd'T'HH:mm:ss'Z'");
    private static final String UUID_HEAD = "<urn:uid:";
    private static final int UUID_HEAD_LENGTH = "<urn:uid:".length();
    private static final String UUID_TAIL = ">";
    private static final int UUID_TAIL_LENGTH = ">".length();
    private static final String UUID_FORMAT = "<urn:uid:%s>";

    public WarcHeader(Name name, String value) {
        super(name.value, value);
    }

    public static void addIfNotPresent(HeaderGroup headers, Name name, String value) {
        if (!headers.containsHeader(name.value)) {
            headers.addHeader((Header)new WarcHeader(name, value));
        }
    }

    public static Header getFirstHeader(HeaderGroup headers, Name name) {
        return headers.getFirstHeader(name.value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date parseDate(String date) throws WarcFormatException {
        try {
            DateFormat dateFormat = W3C_ISO8601_DATE_PARSE;
            synchronized (dateFormat) {
                return W3C_ISO8601_DATE_PARSE.parse(date);
            }
        }
        catch (ParseException e) {
            throw new WarcFormatException("Error parsing date " + date, e);
        }
    }

    public static String formatDate(Calendar calendar) {
        return W3C_ISO8601_DATE_FORMAT.format(calendar);
    }

    public static UUID parseId(String id) throws WarcFormatException {
        UUID uuid;
        if (!id.startsWith(UUID_HEAD) || !id.endsWith(UUID_TAIL)) {
            throw new WarcFormatException("'" + id + "' wrong format for " + Name.WARC_RECORD_ID.value);
        }
        int len = id.length();
        try {
            uuid = UUID.fromString(id.substring(UUID_HEAD_LENGTH, len - UUID_TAIL_LENGTH));
        }
        catch (IllegalArgumentException e) {
            throw new WarcFormatException("Error parsing uuid " + id, e);
        }
        return uuid;
    }

    public static String formatId(UUID id) {
        return String.format(UUID_FORMAT, id.toString());
    }

    public static enum Name {
        WARC_RECORD_ID("WARC-Record-ID"),
        WARC_DATE("WARC-Date"),
        CONTENT_LENGTH("Content-Length"),
        WARC_TYPE("WARC-Type"),
        CONTENT_TYPE("Content-Type"),
        WARC_CONCURRENT_TO("WARC-Concurrent-To"),
        WARC_BLOCK_DIGEST("WARC-Block-Digest"),
        WARC_PAYLOAD_DIGEST("WARC-Payload-Digest"),
        WARC_IP_ADDRESS("WARC-IP-Address"),
        WARC_REFERS_TO("WARC-Refers-To"),
        WARC_TARGET_URI("WARC-Target-URI"),
        WARC_TRUNCATED("WARC-Truncated"),
        WARC_WARCINFO_ID("WARC-Warcinfo-ID"),
        WARC_IDENTIFIED_PAYLOAD_TYPE("WARC-Identified-Payload-Type"),
        WARC_SEGMENT_NUMBER("WARC-Segment-Number"),
        WARC_FILENAME("WARC-Filename"),
        WARC_PROFILE("WARC-Profile"),
        WARC_SEGMENT_ORIGIN_ID("WARC-Segment-Origin-ID"),
        WARC_SEGMENT_TOTAL_LENGTH("WARC-Segment-Total-Length"),
        BUBING_GUESSED_CHARSET("BUbiNG-Guessed-Charset"),
        BUBING_IS_DUPLICATE("BUbiNG-Is-Duplicate");

        protected final String value;

        private Name(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

