package it.unimi.dsi.logging;

/*		 
 * DSI utilities
 *
 * Copyright (C) 2012-2013 Sebastiano Vigna 
 *
 *  This library is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU Lesser General Public License as published by the Free
 *  Software Foundation; either version 3 of the License, or (at your option)
 *  any later version.
 *
 *  This library is distributed in the hope that it will be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
 *  for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
 */

import org.apache.log4j.Appender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.LoggingEvent;
import org.slf4j.helpers.NOPLogger;


/** Logs to <samp>/dev/null</samp> (metaphorically speaking).
 * 
 * <p>This logger is mainly useful to speed up unit tests and avoid out-of-memory errors
 * in <samp>junit</samp> tasks caused by too large error logs.
 *  
 * @author Sebastiano Vigna
 * @deprecated Use <a href="http://www.slf4j.org/"><acronym title="Simple Logging Facade for Java">SLF4J</acronym></a>,
 * which provides {@link NOPLogger}. 
 */

@Deprecated
public final class NullLogger extends Logger {
	
	private static final Logger NULL_LOGGER = new NullLogger();

	private NullLogger() {
		super( NullLogger.class.getSimpleName() );
	}

	/** Returns the only {@linkplain NullLogger null logger}.
	 * 
	 * @return the only {@linkplain NullLogger null logger}.
	 */
	public static Logger getInstance() {
		return NULL_LOGGER;
	}
	
	@Override
	public void trace( Object message ) {}

	@Override
	public void trace( Object message, Throwable t ) {}

	@Override
	public boolean isTraceEnabled() { return false; }

	@Override
	public synchronized void addAppender( Appender newAppender ) {}

	@Override
	public void assertLog( boolean assertion, String msg ) {}

	@Override
	public void callAppenders( LoggingEvent event ) {}

	@Override
	public void debug( Object message ) {}

	@Override
	public void debug( Object message, Throwable t ) {}

	@Override
	public void error( Object message ) {}

	@Override
	public void error( Object message, Throwable t ) {}

	@Override
	public void fatal( Object message ) {}

	@Override
	public void fatal( Object message, Throwable t ) {}

	@Override
	public void info( Object message ) {}

	@Override
	public void info( Object message, Throwable t ) {}

	@Override
	public boolean isAttached( Appender appender ) { return false; }

	@Override
	public boolean isDebugEnabled() { return false; }

	@Override
	public boolean isEnabledFor( Priority level ) { return false; }

	@Override
	public boolean isInfoEnabled() { return false; }

	@Override
	public void l7dlog( Priority priority, String key, Throwable t ) {}

	@Override
	public void l7dlog( Priority priority, String key, Object[] params, Throwable t ) {}

	@Override
	public void log( Priority priority, Object message, Throwable t ) {}

	@Override
	public void log( Priority priority, Object message ) {}

	@Override
	public void log( String callerFQCN, Priority level, Object message, Throwable t ) {}

	@Override
	public synchronized void removeAllAppenders() {}

	@Override
	public synchronized void removeAppender( Appender appender ) {}

	@Override
	public synchronized void removeAppender( String name ) {}

	@Override
	public void setAdditivity( boolean additive ) {}

	@Override
	public void setLevel( Level level ) {}

	@Override
	public void setPriority( Priority priority ) {}

	@Override
	public void warn( Object message ) {}

	@Override
	public void warn( Object message, Throwable t ) {}
}
