/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.util;

import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.Switch;
import com.martiansoftware.jsap.UnflaggedOption;
import it.unimi.dsi.Util;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntIterators;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import it.unimi.dsi.fastutil.io.BinIO;
import it.unimi.dsi.fastutil.io.TextIO;
import it.unimi.dsi.fastutil.objects.AbstractObjectList;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import it.unimi.dsi.lang.MutableString;
import it.unimi.dsi.util.FrontCodedStringList;
import java.io.IOException;
import java.io.Serializable;

public class PermutedFrontCodedStringList
extends AbstractObjectList<CharSequence>
implements Serializable {
    public static final long serialVersionUID = -7046029254386353130L;
    protected final FrontCodedStringList frontCodedStringList;
    protected final int[] permutation;

    public PermutedFrontCodedStringList(FrontCodedStringList frontCodedStringList, int[] permutation) {
        if (frontCodedStringList.size() != permutation.length) {
            throw new IllegalArgumentException("The front-coded string list contains " + frontCodedStringList.size() + " strings, but the permutation is on " + permutation.length + " elements.");
        }
        this.frontCodedStringList = frontCodedStringList;
        this.permutation = permutation;
    }

    public CharSequence get(int index) {
        return this.frontCodedStringList.get(this.permutation[index]);
    }

    public void get(int index, MutableString s) {
        this.frontCodedStringList.get(this.permutation[index], s);
    }

    public int size() {
        return this.frontCodedStringList.size();
    }

    public ObjectListIterator<CharSequence> listIterator(int k) {
        return new ObjectListIterator<CharSequence>(){
            final IntListIterator i;
            {
                this.i = IntIterators.fromTo((int)0, (int)PermutedFrontCodedStringList.this.frontCodedStringList.size());
            }

            public boolean hasNext() {
                return this.i.hasNext();
            }

            public boolean hasPrevious() {
                return this.i.hasPrevious();
            }

            public CharSequence next() {
                return PermutedFrontCodedStringList.this.frontCodedStringList.get(PermutedFrontCodedStringList.this.permutation[this.i.nextInt()]);
            }

            public CharSequence previous() {
                return PermutedFrontCodedStringList.this.frontCodedStringList.get(PermutedFrontCodedStringList.this.permutation[this.i.previousInt()]);
            }

            public int nextIndex() {
                return this.i.nextIndex();
            }

            public int previousIndex() {
                return this.i.previousIndex();
            }
        };
    }

    public static void main(String[] arg) throws IOException, ClassNotFoundException, JSAPException {
        int[] permutation;
        SimpleJSAP jsap = new SimpleJSAP(PermutedFrontCodedStringList.class.getName(), "Builds a permuted front-coded list of strings using a given front-coded string list and a permutation (either in text or binary format).", new Parameter[]{new Switch("invert", 'i', "invert", "Invert permutation before creating the permuted list."), new Switch("text", 't', "text", "The permutation is a text file."), new UnflaggedOption("list", (StringParser)JSAP.STRING_PARSER, true, "A front-coded string list."), new UnflaggedOption("permutation", (StringParser)JSAP.STRING_PARSER, true, "A permutation for the indices of the list (in DataInput format, unless you specify --text)."), new UnflaggedOption("permutedList", (StringParser)JSAP.STRING_PARSER, true, "A the filename for the resulting permuted list.")});
        JSAPResult jsapResult = jsap.parse(arg);
        if (jsap.messagePrinted()) {
            return;
        }
        String permutationFile = jsapResult.getString("permutation");
        int[] nArray = permutation = jsapResult.userSpecified("text") ? IntIterators.unwrap((IntIterator)TextIO.asIntIterator((CharSequence)permutationFile)) : BinIO.loadInts((CharSequence)permutationFile);
        if (jsapResult.getBoolean("invert")) {
            Util.invertPermutationInPlace(permutation);
        }
        BinIO.storeObject((Object)new PermutedFrontCodedStringList((FrontCodedStringList)BinIO.loadObject((CharSequence)jsapResult.getString("list")), permutation), (CharSequence)jsapResult.getString("permutedList"));
    }
}

