/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.bits;

import it.unimi.dsi.bits.AbstractBitVector;
import it.unimi.dsi.bits.BitVector;
import it.unimi.dsi.bits.BitVectors;
import it.unimi.dsi.fastutil.booleans.BooleanBigArrayBigList;
import it.unimi.dsi.fastutil.booleans.BooleanBigList;
import it.unimi.dsi.fastutil.booleans.BooleanBigLists;
import it.unimi.dsi.fastutil.booleans.BooleanList;
import java.io.Serializable;

public class BooleanListBitVector
extends AbstractBitVector
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final BooleanBigList list;

    protected static final void ensureIntegerIndex(long index) {
        if (index > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("This BitVector implementation accepts integer indices only");
        }
    }

    public static BooleanListBitVector getInstance(long capacity) {
        if (capacity > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("This BitVector implementation accepts integer indices only");
        }
        return new BooleanListBitVector((int)capacity);
    }

    public static BooleanListBitVector getInstance() {
        return new BooleanListBitVector(0);
    }

    public static BooleanListBitVector of(int ... bit) {
        BooleanListBitVector bitVector = BooleanListBitVector.getInstance(bit.length);
        for (int b : bit) {
            bitVector.add(b);
        }
        return bitVector;
    }

    protected BooleanListBitVector(BooleanBigList list) {
        this.list = list;
    }

    protected BooleanListBitVector(int capacity) {
        this((BooleanBigList)new BooleanBigArrayBigList((long)capacity));
    }

    public static BooleanListBitVector wrap(BooleanList list) {
        return new BooleanListBitVector(BooleanBigLists.asBigList((BooleanList)list));
    }

    public static BooleanListBitVector wrap(BooleanBigList list) {
        return new BooleanListBitVector(list);
    }

    @Override
    public long length() {
        return this.list.size64();
    }

    @Override
    public boolean set(long index, boolean value) {
        BooleanListBitVector.ensureIntegerIndex(index);
        return this.list.set((long)((int)index), value);
    }

    public boolean getBoolean(long index) {
        BooleanListBitVector.ensureIntegerIndex(index);
        return this.list.getBoolean((long)((int)index));
    }

    @Override
    public void add(long index, boolean value) {
        BooleanListBitVector.ensureIntegerIndex(index);
        this.list.add((long)((int)index), value);
    }

    @Override
    public boolean removeBoolean(long index) {
        BooleanListBitVector.ensureIntegerIndex(index);
        return this.list.removeBoolean((long)((int)index));
    }

    @Override
    public BooleanListBitVector copy(long from, long to) {
        BitVectors.ensureFromTo(this.length(), from, to);
        return new BooleanListBitVector(this.list.subList((long)((int)from), (long)((int)to)));
    }

    @Override
    public BooleanListBitVector copy() {
        return new BooleanListBitVector((BooleanBigList)new BooleanBigArrayBigList(this.list));
    }

    public BitVector ensureCapacity(long numBits) {
        if (numBits > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("This BitVector implementation accepts integer indices only");
        }
        this.list.size((long)((int)numBits));
        return this;
    }

    @Override
    public BitVector length(long numBits) {
        if (numBits > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("This BitVector implementation accepts integer indices only");
        }
        this.list.size((long)((int)numBits));
        return this;
    }
}

