/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.big.util;

import it.unimi.dsi.big.util.PrefixMap;
import it.unimi.dsi.big.util.StringMap;
import it.unimi.dsi.fastutil.objects.AbstractObject2LongFunction;
import it.unimi.dsi.fastutil.objects.AbstractObject2ObjectFunction;
import it.unimi.dsi.fastutil.objects.Object2ObjectFunction;
import it.unimi.dsi.fastutil.objects.Object2ObjectFunctions;
import it.unimi.dsi.fastutil.objects.ObjectBigList;
import it.unimi.dsi.fastutil.objects.ObjectBigLists;
import it.unimi.dsi.util.Interval;
import it.unimi.dsi.util.LongInterval;
import java.io.Serializable;

public class StringMaps {
    private StringMaps() {
    }

    public static <T extends CharSequence> StringMap<T> synchronize(StringMap<T> stringMap) {
        return stringMap instanceof PrefixMap ? new SynchronizedPrefixMap((PrefixMap)stringMap) : new SynchronizedStringMap<T>(stringMap);
    }

    public static <T extends CharSequence> PrefixMap<T> synchronize(PrefixMap<T> prefixMap) {
        return new SynchronizedPrefixMap<T>(prefixMap);
    }

    public static <T extends CharSequence> StringMap<T> wrap(it.unimi.dsi.util.StringMap<T> stringMap) {
        return new StringMapWrapper<T>(stringMap);
    }

    public static <T extends CharSequence> PrefixMap<T> wrap(it.unimi.dsi.util.PrefixMap<T> prefixMap) {
        return new PrefixMapWrapper<T>(prefixMap);
    }

    protected static class SynchronizedPrefixMap<S extends CharSequence>
    extends SynchronizedStringMap<S>
    implements PrefixMap<S>,
    Serializable {
        private static final long serialVersionUID = 1L;
        protected final PrefixMap<S> map;
        protected Object2ObjectFunction<LongInterval, S> prefixMap;
        protected Object2ObjectFunction<CharSequence, LongInterval> rangeMap;

        public SynchronizedPrefixMap(PrefixMap<S> map) {
            super(map);
            this.map = map;
        }

        @Override
        public synchronized Object2ObjectFunction<LongInterval, S> prefixMap() {
            if (this.prefixMap == null) {
                this.prefixMap = this.map.prefixMap();
                if (this.prefixMap != null) {
                    this.prefixMap = Object2ObjectFunctions.synchronize(this.prefixMap, (Object)this);
                }
            }
            return this.prefixMap;
        }

        @Override
        public synchronized Object2ObjectFunction<CharSequence, LongInterval> rangeMap() {
            if (this.rangeMap == null) {
                this.rangeMap = this.map.rangeMap();
                if (this.rangeMap != null) {
                    this.rangeMap = Object2ObjectFunctions.synchronize(this.rangeMap, (Object)this);
                }
            }
            return this.rangeMap;
        }
    }

    protected static class SynchronizedStringMap<S extends CharSequence>
    implements StringMap<S>,
    Serializable {
        private static final long serialVersionUID = 1L;
        protected final StringMap<S> stringMap;
        protected ObjectBigList<? extends S> list;

        public SynchronizedStringMap(StringMap<S> stringMap) {
            this.stringMap = stringMap;
        }

        @Override
        public synchronized long size64() {
            return this.stringMap.size64();
        }

        @Override
        public synchronized ObjectBigList<? extends S> list() {
            if (this.list == null) {
                this.list = this.stringMap.list();
                if (this.list != null) {
                    this.list = ObjectBigLists.synchronize(this.list, (Object)this);
                }
            }
            return this.list;
        }

        public synchronized long getLong(Object s) {
            return this.stringMap.getLong(s);
        }

        public synchronized Long get(Object key) {
            return this.stringMap.get(key);
        }

        public synchronized long put(CharSequence key, long value) {
            return this.stringMap.put(key, value);
        }

        public synchronized Long put(CharSequence key, Long value) {
            return this.stringMap.put(key, value);
        }

        public synchronized Long remove(Object key) {
            return this.stringMap.remove(key);
        }

        public synchronized long removeLong(Object key) {
            return this.stringMap.removeLong(key);
        }

        public synchronized void clear() {
            this.stringMap.clear();
        }

        public synchronized boolean containsKey(Object key) {
            return this.stringMap.containsKey(key);
        }

        public synchronized long defaultReturnValue() {
            return this.stringMap.defaultReturnValue();
        }

        public synchronized void defaultReturnValue(long rv) {
            this.stringMap.defaultReturnValue(rv);
        }
    }

    protected static class StringMapWrapper<T extends CharSequence>
    extends AbstractObject2LongFunction<CharSequence>
    implements StringMap<T> {
        private static final long serialVersionUID = 1L;
        private final it.unimi.dsi.util.StringMap<T> stringMap;

        public StringMapWrapper(it.unimi.dsi.util.StringMap<T> stringMap) {
            this.stringMap = stringMap;
        }

        public long getLong(Object key) {
            return this.stringMap.getLong(key);
        }

        public boolean containsKey(Object key) {
            return this.stringMap.containsKey(key);
        }

        @Override
        public long size64() {
            return this.stringMap.size();
        }

        @Override
        public ObjectBigList<? extends T> list() {
            return ObjectBigLists.asBigList(this.stringMap.list());
        }
    }

    protected static class PrefixMapWrapper<T extends CharSequence>
    extends StringMapWrapper<T>
    implements PrefixMap<T> {
        private static final long serialVersionUID = 1L;
        private final Object2ObjectFunction<CharSequence, LongInterval> rangeMap;

        public PrefixMapWrapper(final it.unimi.dsi.util.PrefixMap<T> prefixMap) {
            super(prefixMap);
            this.rangeMap = new AbstractObject2ObjectFunction<CharSequence, LongInterval>(){
                private static final long serialVersionUID = 1L;
                private final Object2ObjectFunction<CharSequence, Interval> prefixMapRangeMap;
                {
                    this.prefixMapRangeMap = prefixMap.rangeMap();
                }

                public LongInterval get(Object key) {
                    Interval interval = (Interval)this.prefixMapRangeMap.get(key);
                    return LongInterval.valueOf(interval.left, interval.right);
                }

                public boolean containsKey(Object key) {
                    return this.prefixMapRangeMap.containsKey(key);
                }

                public int size() {
                    return this.prefixMapRangeMap.size();
                }
            };
        }

        @Override
        public Object2ObjectFunction<CharSequence, LongInterval> rangeMap() {
            return this.rangeMap;
        }

        @Override
        public Object2ObjectFunction<LongInterval, T> prefixMap() {
            return null;
        }
    }
}

