/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.doubles;

import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.booleans.BooleanArrays;
import it.unimi.dsi.fastutil.bytes.AbstractByteCollection;
import it.unimi.dsi.fastutil.bytes.ByteCollection;
import it.unimi.dsi.fastutil.bytes.ByteIterator;
import it.unimi.dsi.fastutil.bytes.ByteListIterator;
import it.unimi.dsi.fastutil.doubles.AbstractDouble2ByteMap;
import it.unimi.dsi.fastutil.doubles.AbstractDouble2ByteSortedMap;
import it.unimi.dsi.fastutil.doubles.AbstractDoubleSortedSet;
import it.unimi.dsi.fastutil.doubles.Double2ByteMap;
import it.unimi.dsi.fastutil.doubles.Double2ByteSortedMap;
import it.unimi.dsi.fastutil.doubles.DoubleBidirectionalIterator;
import it.unimi.dsi.fastutil.doubles.DoubleComparator;
import it.unimi.dsi.fastutil.doubles.DoubleListIterator;
import it.unimi.dsi.fastutil.doubles.DoubleSortedSet;
import it.unimi.dsi.fastutil.objects.AbstractObjectSortedSet;
import it.unimi.dsi.fastutil.objects.ObjectBidirectionalIterator;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import it.unimi.dsi.fastutil.objects.ObjectSortedSet;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Map;
import java.util.NoSuchElementException;

public class Double2ByteLinkedOpenHashMap
extends AbstractDouble2ByteSortedMap
implements Serializable,
Cloneable,
Hash {
    public static final long serialVersionUID = 0L;
    private static final boolean ASSERTS = false;
    protected transient double[] key;
    protected transient byte[] value;
    protected transient boolean[] used;
    protected final float f;
    protected transient int n;
    protected transient int maxFill;
    protected transient int mask;
    protected int size;
    protected volatile transient Double2ByteSortedMap.FastSortedEntrySet entries;
    protected volatile transient DoubleSortedSet keys;
    protected volatile transient ByteCollection values;
    protected transient int first = -1;
    protected transient int last = -1;
    protected transient int[] link;

    public Double2ByteLinkedOpenHashMap(int expected, float f) {
        if (f <= 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and smaller than or equal to 1");
        }
        if (expected < 0) {
            throw new IllegalArgumentException("The expected number of elements must be nonnegative");
        }
        this.f = f;
        this.n = HashCommon.arraySize(expected, f);
        this.mask = this.n - 1;
        this.maxFill = HashCommon.maxFill(this.n, f);
        this.key = new double[this.n];
        this.value = new byte[this.n];
        this.used = new boolean[this.n];
        this.link = new int[this.n];
    }

    public Double2ByteLinkedOpenHashMap(int expected) {
        this(expected, 0.75f);
    }

    public Double2ByteLinkedOpenHashMap() {
        this(16, 0.75f);
    }

    public Double2ByteLinkedOpenHashMap(Map<? extends Double, ? extends Byte> m, float f) {
        this(m.size(), f);
        this.putAll(m);
    }

    public Double2ByteLinkedOpenHashMap(Map<? extends Double, ? extends Byte> m) {
        this(m, 0.75f);
    }

    public Double2ByteLinkedOpenHashMap(Double2ByteMap m, float f) {
        this(m.size(), f);
        this.putAll(m);
    }

    public Double2ByteLinkedOpenHashMap(Double2ByteMap m) {
        this(m, 0.75f);
    }

    public Double2ByteLinkedOpenHashMap(double[] k, byte[] v, float f) {
        this(k.length, f);
        if (k.length != v.length) {
            throw new IllegalArgumentException("The key array and the value array have different lengths (" + k.length + " and " + v.length + ")");
        }
        for (int i = 0; i < k.length; ++i) {
            this.put(k[i], v[i]);
        }
    }

    public Double2ByteLinkedOpenHashMap(double[] k, byte[] v) {
        this(k, v, 0.75f);
    }

    @Override
    public byte put(double k, byte v) {
        int pos = (int)HashCommon.murmurHash3(Double.doubleToRawLongBits(k)) & this.mask;
        while (this.used[pos]) {
            if (k == this.key[pos]) {
                byte oldValue = this.value[pos];
                this.value[pos] = v;
                return oldValue;
            }
            pos = pos + 1 & this.mask;
        }
        this.used[pos] = true;
        this.key[pos] = k;
        this.value[pos] = v;
        if (this.size == 0) {
            this.first = this.last = pos;
            this.link[pos] = 0;
        } else {
            int n = this.last;
            this.link[n] = this.link[n] ^ ~pos;
            this.link[pos] = ~this.last;
            this.last = pos;
        }
        if (++this.size >= this.maxFill) {
            this.rehash(HashCommon.arraySize(this.size + 1, this.f));
        }
        return this.defRetValue;
    }

    @Override
    public Byte put(Double ok, Byte ov) {
        byte v = ov;
        double k = ok;
        int pos = (int)HashCommon.murmurHash3(Double.doubleToRawLongBits(k)) & this.mask;
        while (this.used[pos]) {
            if (k == this.key[pos]) {
                Byte oldValue = this.value[pos];
                this.value[pos] = v;
                return oldValue;
            }
            pos = pos + 1 & this.mask;
        }
        this.used[pos] = true;
        this.key[pos] = k;
        this.value[pos] = v;
        if (this.size == 0) {
            this.first = this.last = pos;
            this.link[pos] = 0;
        } else {
            int n = this.last;
            this.link[n] = this.link[n] ^ ~pos;
            this.link[pos] = ~this.last;
            this.last = pos;
        }
        if (++this.size >= this.maxFill) {
            this.rehash(HashCommon.arraySize(this.size + 1, this.f));
        }
        return null;
    }

    public byte add(double k, byte incr) {
        int pos = (int)HashCommon.murmurHash3(Double.doubleToRawLongBits(k)) & this.mask;
        while (this.used[pos]) {
            if (k == this.key[pos]) {
                byte oldValue = this.value[pos];
                int n = pos;
                this.value[n] = (byte)(this.value[n] + incr);
                return oldValue;
            }
            pos = pos + 1 & this.mask;
        }
        this.used[pos] = true;
        this.key[pos] = k;
        this.value[pos] = (byte)(this.defRetValue + incr);
        if (this.size == 0) {
            this.first = this.last = pos;
            this.link[pos] = 0;
        } else {
            int n = this.last;
            this.link[n] = this.link[n] ^ ~pos;
            this.link[pos] = ~this.last;
            this.last = pos;
        }
        if (++this.size >= this.maxFill) {
            this.rehash(HashCommon.arraySize(this.size + 1, this.f));
        }
        return this.defRetValue;
    }

    protected final void shiftKeys(int pos) {
        while (true) {
            int last = pos;
            pos = last + 1 & this.mask;
            while (this.used[pos]) {
                int slot = (int)HashCommon.murmurHash3(Double.doubleToRawLongBits(this.key[pos])) & this.mask;
                if (last <= pos ? last >= slot || slot > pos : last >= slot && slot > pos) break;
                pos = pos + 1 & this.mask;
            }
            if (!this.used[pos]) break;
            this.key[last] = this.key[pos];
            this.value[last] = this.value[pos];
            this.fixPointers(pos, last);
        }
        this.used[last] = false;
    }

    @Override
    public byte remove(double k) {
        int pos = (int)HashCommon.murmurHash3(Double.doubleToRawLongBits(k)) & this.mask;
        while (this.used[pos]) {
            if (k == this.key[pos]) {
                --this.size;
                this.fixPointers(pos);
                byte v = this.value[pos];
                this.shiftKeys(pos);
                return v;
            }
            pos = pos + 1 & this.mask;
        }
        return this.defRetValue;
    }

    @Override
    public Byte remove(Object ok) {
        double k = (Double)ok;
        int pos = (int)HashCommon.murmurHash3(Double.doubleToRawLongBits(k)) & this.mask;
        while (this.used[pos]) {
            if (k == this.key[pos]) {
                --this.size;
                this.fixPointers(pos);
                byte v = this.value[pos];
                this.shiftKeys(pos);
                return v;
            }
            pos = pos + 1 & this.mask;
        }
        return null;
    }

    public Byte get(Double ok) {
        double k = ok;
        int pos = (int)HashCommon.murmurHash3(Double.doubleToRawLongBits(k)) & this.mask;
        while (this.used[pos]) {
            if (k == this.key[pos]) {
                return this.value[pos];
            }
            pos = pos + 1 & this.mask;
        }
        return null;
    }

    @Override
    public byte get(double k) {
        int pos = (int)HashCommon.murmurHash3(Double.doubleToRawLongBits(k)) & this.mask;
        while (this.used[pos]) {
            if (k == this.key[pos]) {
                return this.value[pos];
            }
            pos = pos + 1 & this.mask;
        }
        return this.defRetValue;
    }

    @Override
    public boolean containsKey(double k) {
        int pos = (int)HashCommon.murmurHash3(Double.doubleToRawLongBits(k)) & this.mask;
        while (this.used[pos]) {
            if (k == this.key[pos]) {
                return true;
            }
            pos = pos + 1 & this.mask;
        }
        return false;
    }

    @Override
    public boolean containsValue(byte v) {
        byte[] value = this.value;
        boolean[] used = this.used;
        int i = this.n;
        while (i-- != 0) {
            if (!used[i] || value[i] != v) continue;
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        if (this.size == 0) {
            return;
        }
        this.size = 0;
        BooleanArrays.fill(this.used, false);
        this.last = -1;
        this.first = -1;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Deprecated
    public void growthFactor(int growthFactor) {
    }

    @Deprecated
    public int growthFactor() {
        return 16;
    }

    protected void fixPointers(int i) {
        int next;
        if (this.size == 0) {
            this.last = -1;
            this.first = -1;
            return;
        }
        if (this.first == i) {
            int n = this.first = ~this.link[i];
            this.link[n] = this.link[n] ^ ~i;
            return;
        }
        if (this.last == i) {
            int n = this.last = ~this.link[i];
            this.link[n] = this.link[n] ^ ~i;
            return;
        }
        int j = this.first;
        int prev = -1;
        while ((next = this.link[j] ^ prev) != i) {
            prev = j;
            j = next;
        }
        int n = j;
        this.link[n] = this.link[n] ^ (this.link[i] ^ i ^ j);
        int n2 = this.link[i] ^ j;
        this.link[n2] = this.link[n2] ^ (i ^ j);
    }

    protected void fixPointers(int s, int d) {
        int next;
        if (this.size == 1) {
            this.first = this.last = d;
            this.link[d] = 0;
            return;
        }
        if (this.first == s) {
            this.first = d;
            int n = ~this.link[s];
            this.link[n] = this.link[n] ^ (s ^ d);
            this.link[d] = this.link[s];
            return;
        }
        if (this.last == s) {
            this.last = d;
            int n = ~this.link[s];
            this.link[n] = this.link[n] ^ (s ^ d);
            this.link[d] = this.link[s];
            return;
        }
        int j = this.first;
        int prev = -1;
        while ((next = this.link[j] ^ prev) != s) {
            prev = j;
            j = next;
        }
        int n = j;
        this.link[n] = this.link[n] ^ (s ^ d);
        int n2 = this.link[s] ^ j;
        this.link[n2] = this.link[n2] ^ (s ^ d);
        this.link[d] = this.link[s];
    }

    @Override
    public double firstDoubleKey() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.key[this.first];
    }

    @Override
    public double lastDoubleKey() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.key[this.last];
    }

    @Override
    public DoubleComparator comparator() {
        return null;
    }

    @Override
    public Double2ByteSortedMap tailMap(double from) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Double2ByteSortedMap headMap(double to) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Double2ByteSortedMap subMap(double from, double to) {
        throw new UnsupportedOperationException();
    }

    public Double2ByteSortedMap.FastSortedEntrySet double2ByteEntrySet() {
        if (this.entries == null) {
            this.entries = new MapEntrySet();
        }
        return this.entries;
    }

    @Override
    public DoubleSortedSet keySet() {
        if (this.keys == null) {
            this.keys = new KeySet();
        }
        return this.keys;
    }

    @Override
    public ByteCollection values() {
        if (this.values == null) {
            this.values = new AbstractByteCollection(){

                @Override
                public ByteIterator iterator() {
                    return new ValueIterator();
                }

                @Override
                public int size() {
                    return Double2ByteLinkedOpenHashMap.this.size;
                }

                @Override
                public boolean contains(byte v) {
                    return Double2ByteLinkedOpenHashMap.this.containsValue(v);
                }

                @Override
                public void clear() {
                    Double2ByteLinkedOpenHashMap.this.clear();
                }
            };
        }
        return this.values;
    }

    @Deprecated
    public boolean rehash() {
        return true;
    }

    public boolean trim() {
        int l = HashCommon.arraySize(this.size, this.f);
        if (l >= this.n) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    public boolean trim(int n) {
        int l = HashCommon.nextPowerOfTwo((int)Math.ceil((float)n / this.f));
        if (this.n <= l) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    protected void rehash(int newN) {
        int i = this.first;
        int prev = -1;
        int newPrev = -1;
        double[] key = this.key;
        byte[] value = this.value;
        int newMask = newN - 1;
        double[] newKey = new double[newN];
        byte[] newValue = new byte[newN];
        boolean[] newUsed = new boolean[newN];
        int[] link = this.link;
        int[] newLink = new int[newN];
        this.first = -1;
        int j = this.size;
        while (j-- != 0) {
            double k = key[i];
            int pos = (int)HashCommon.murmurHash3(Double.doubleToRawLongBits(k)) & newMask;
            while (newUsed[pos]) {
                pos = pos + 1 & newMask;
            }
            newUsed[pos] = true;
            newKey[pos] = k;
            newValue[pos] = value[i];
            if (prev != -1) {
                int n = newPrev;
                newLink[n] = newLink[n] ^ pos;
                newLink[pos] = newPrev;
                newPrev = pos;
            } else {
                newPrev = this.first = pos;
                newLink[pos] = -1;
            }
            int t = i;
            i = link[i] ^ prev;
            prev = t;
        }
        this.n = newN;
        this.mask = newMask;
        this.maxFill = HashCommon.maxFill(this.n, this.f);
        this.key = newKey;
        this.value = newValue;
        this.used = newUsed;
        this.link = newLink;
        this.last = newPrev;
        if (newPrev != -1) {
            int n = newPrev;
            newLink[n] = ~newLink[n];
        }
    }

    public Double2ByteLinkedOpenHashMap clone() {
        Double2ByteLinkedOpenHashMap c;
        try {
            c = (Double2ByteLinkedOpenHashMap)super.clone();
        }
        catch (CloneNotSupportedException cantHappen) {
            throw new InternalError();
        }
        c.keys = null;
        c.values = null;
        c.entries = null;
        c.key = (double[])this.key.clone();
        c.value = (byte[])this.value.clone();
        c.used = (boolean[])this.used.clone();
        c.link = (int[])this.link.clone();
        return c;
    }

    @Override
    public int hashCode() {
        int h = 0;
        int j = this.size;
        int i = 0;
        int t = 0;
        while (j-- != 0) {
            while (!this.used[i]) {
                ++i;
            }
            t = HashCommon.double2int(this.key[i]);
            h += (t ^= this.value[i]);
            ++i;
        }
        return h;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        double[] key = this.key;
        byte[] value = this.value;
        MapIterator i = new MapIterator();
        s.defaultWriteObject();
        int j = this.size;
        while (j-- != 0) {
            int e = i.nextEntry();
            s.writeDouble(key[e]);
            s.writeByte(value[e]);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.n = HashCommon.arraySize(this.size, this.f);
        this.maxFill = HashCommon.maxFill(this.n, this.f);
        this.mask = this.n - 1;
        this.key = new double[this.n];
        double[] key = this.key;
        this.value = new byte[this.n];
        byte[] value = this.value;
        this.used = new boolean[this.n];
        boolean[] used = this.used;
        this.link = new int[this.n];
        int[] link = this.link;
        int prev = -1;
        this.last = -1;
        this.first = -1;
        int i = this.size;
        int pos = 0;
        while (i-- != 0) {
            double k = s.readDouble();
            byte v = s.readByte();
            pos = (int)HashCommon.murmurHash3(Double.doubleToRawLongBits(k)) & this.mask;
            while (used[pos]) {
                pos = pos + 1 & this.mask;
            }
            used[pos] = true;
            key[pos] = k;
            value[pos] = v;
            if (this.first != -1) {
                int n = prev;
                link[n] = link[n] ^ pos;
                link[pos] = prev;
                prev = pos;
                continue;
            }
            prev = this.first = pos;
            link[pos] = -1;
        }
        this.last = prev;
        if (prev != -1) {
            int n = prev;
            link[n] = ~link[n];
        }
    }

    private void checkTable() {
    }

    private final class ValueIterator
    extends MapIterator
    implements ByteListIterator {
        @Override
        public byte previousByte() {
            return Double2ByteLinkedOpenHashMap.this.value[this.previousEntry()];
        }

        @Override
        public Byte previous() {
            return Double2ByteLinkedOpenHashMap.this.value[this.previousEntry()];
        }

        @Override
        public void set(Byte ok) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(Byte ok) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(byte v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(byte v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public byte nextByte() {
            return Double2ByteLinkedOpenHashMap.this.value[this.nextEntry()];
        }

        @Override
        public Byte next() {
            return Double2ByteLinkedOpenHashMap.this.value[this.nextEntry()];
        }
    }

    private final class KeySet
    extends AbstractDoubleSortedSet {
        private KeySet() {
        }

        @Override
        public DoubleBidirectionalIterator iterator(double from) {
            return new KeyIterator(from);
        }

        @Override
        public DoubleBidirectionalIterator iterator() {
            return new KeyIterator();
        }

        @Override
        public int size() {
            return Double2ByteLinkedOpenHashMap.this.size;
        }

        @Override
        public boolean contains(double k) {
            return Double2ByteLinkedOpenHashMap.this.containsKey(k);
        }

        @Override
        public boolean remove(double k) {
            int oldSize = Double2ByteLinkedOpenHashMap.this.size;
            Double2ByteLinkedOpenHashMap.this.remove(k);
            return Double2ByteLinkedOpenHashMap.this.size != oldSize;
        }

        @Override
        public void clear() {
            Double2ByteLinkedOpenHashMap.this.clear();
        }

        @Override
        public double firstDouble() {
            if (Double2ByteLinkedOpenHashMap.this.size == 0) {
                throw new NoSuchElementException();
            }
            return Double2ByteLinkedOpenHashMap.this.key[Double2ByteLinkedOpenHashMap.this.first];
        }

        @Override
        public double lastDouble() {
            if (Double2ByteLinkedOpenHashMap.this.size == 0) {
                throw new NoSuchElementException();
            }
            return Double2ByteLinkedOpenHashMap.this.key[Double2ByteLinkedOpenHashMap.this.last];
        }

        @Override
        public DoubleComparator comparator() {
            return null;
        }

        @Override
        public final DoubleSortedSet tailSet(double from) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final DoubleSortedSet headSet(double to) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final DoubleSortedSet subSet(double from, double to) {
            throw new UnsupportedOperationException();
        }
    }

    private final class KeyIterator
    extends MapIterator
    implements DoubleListIterator {
        public KeyIterator(double k) {
            super(k);
        }

        @Override
        public double previousDouble() {
            return Double2ByteLinkedOpenHashMap.this.key[this.previousEntry()];
        }

        @Override
        public void set(double k) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(double k) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Double previous() {
            return Double2ByteLinkedOpenHashMap.this.key[this.previousEntry()];
        }

        @Override
        public void set(Double ok) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(Double ok) {
            throw new UnsupportedOperationException();
        }

        public KeyIterator() {
        }

        @Override
        public double nextDouble() {
            return Double2ByteLinkedOpenHashMap.this.key[this.nextEntry()];
        }

        @Override
        public Double next() {
            return Double2ByteLinkedOpenHashMap.this.key[this.nextEntry()];
        }
    }

    private final class MapEntrySet
    extends AbstractObjectSortedSet<Double2ByteMap.Entry>
    implements Double2ByteSortedMap.FastSortedEntrySet {
        private MapEntrySet() {
        }

        @Override
        public ObjectBidirectionalIterator<Double2ByteMap.Entry> iterator() {
            return new EntryIterator();
        }

        @Override
        public Comparator<? super Double2ByteMap.Entry> comparator() {
            return null;
        }

        @Override
        public ObjectSortedSet<Double2ByteMap.Entry> subSet(Double2ByteMap.Entry fromElement, Double2ByteMap.Entry toElement) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ObjectSortedSet<Double2ByteMap.Entry> headSet(Double2ByteMap.Entry toElement) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ObjectSortedSet<Double2ByteMap.Entry> tailSet(Double2ByteMap.Entry fromElement) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Double2ByteMap.Entry first() {
            if (Double2ByteLinkedOpenHashMap.this.size == 0) {
                throw new NoSuchElementException();
            }
            return new MapEntry(Double2ByteLinkedOpenHashMap.this.first);
        }

        @Override
        public Double2ByteMap.Entry last() {
            if (Double2ByteLinkedOpenHashMap.this.size == 0) {
                throw new NoSuchElementException();
            }
            return new MapEntry(Double2ByteLinkedOpenHashMap.this.last);
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            double k = (Double)e.getKey();
            int pos = (int)HashCommon.murmurHash3(Double.doubleToRawLongBits(k)) & Double2ByteLinkedOpenHashMap.this.mask;
            while (Double2ByteLinkedOpenHashMap.this.used[pos]) {
                if (k == Double2ByteLinkedOpenHashMap.this.key[pos]) {
                    return Double2ByteLinkedOpenHashMap.this.value[pos] == (Byte)e.getValue();
                }
                pos = pos + 1 & Double2ByteLinkedOpenHashMap.this.mask;
            }
            return false;
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            double k = (Double)e.getKey();
            int pos = (int)HashCommon.murmurHash3(Double.doubleToRawLongBits(k)) & Double2ByteLinkedOpenHashMap.this.mask;
            while (Double2ByteLinkedOpenHashMap.this.used[pos]) {
                if (k == Double2ByteLinkedOpenHashMap.this.key[pos]) {
                    Double2ByteLinkedOpenHashMap.this.remove(e.getKey());
                    return true;
                }
                pos = pos + 1 & Double2ByteLinkedOpenHashMap.this.mask;
            }
            return false;
        }

        @Override
        public int size() {
            return Double2ByteLinkedOpenHashMap.this.size;
        }

        @Override
        public void clear() {
            Double2ByteLinkedOpenHashMap.this.clear();
        }

        @Override
        public ObjectBidirectionalIterator<Double2ByteMap.Entry> iterator(Double2ByteMap.Entry from) {
            return new EntryIterator((Double)from.getKey());
        }

        public ObjectBidirectionalIterator<Double2ByteMap.Entry> fastIterator() {
            return new FastEntryIterator();
        }

        @Override
        public ObjectBidirectionalIterator<Double2ByteMap.Entry> fastIterator(Double2ByteMap.Entry from) {
            return new FastEntryIterator((Double)from.getKey());
        }
    }

    private class FastEntryIterator
    extends MapIterator
    implements ObjectListIterator<Double2ByteMap.Entry> {
        final AbstractDouble2ByteMap.BasicEntry entry;

        public FastEntryIterator() {
            this.entry = new AbstractDouble2ByteMap.BasicEntry(0.0, 0);
        }

        public FastEntryIterator(double from) {
            super(from);
            this.entry = new AbstractDouble2ByteMap.BasicEntry(0.0, 0);
        }

        @Override
        public AbstractDouble2ByteMap.BasicEntry next() {
            int e = this.nextEntry();
            this.entry.key = Double2ByteLinkedOpenHashMap.this.key[e];
            this.entry.value = Double2ByteLinkedOpenHashMap.this.value[e];
            return this.entry;
        }

        @Override
        public AbstractDouble2ByteMap.BasicEntry previous() {
            int e = this.previousEntry();
            this.entry.key = Double2ByteLinkedOpenHashMap.this.key[e];
            this.entry.value = Double2ByteLinkedOpenHashMap.this.value[e];
            return this.entry;
        }

        @Override
        public void set(Double2ByteMap.Entry ok) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(Double2ByteMap.Entry ok) {
            throw new UnsupportedOperationException();
        }
    }

    private class EntryIterator
    extends MapIterator
    implements ObjectListIterator<Double2ByteMap.Entry> {
        public EntryIterator() {
        }

        public EntryIterator(double from) {
            super(from);
        }

        @Override
        public MapEntry next() {
            return new MapEntry(this.nextEntry());
        }

        @Override
        public MapEntry previous() {
            return new MapEntry(this.previousEntry());
        }

        @Override
        public void set(Double2ByteMap.Entry ok) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(Double2ByteMap.Entry ok) {
            throw new UnsupportedOperationException();
        }
    }

    private class MapIterator {
        int prev = -1;
        int next = -1;
        int curr = -1;
        int index = 0;

        private MapIterator() {
            this.next = Double2ByteLinkedOpenHashMap.this.first;
        }

        private MapIterator(double from) {
            if (Double2ByteLinkedOpenHashMap.this.key[Double2ByteLinkedOpenHashMap.this.last] == from) {
                this.prev = Double2ByteLinkedOpenHashMap.this.last;
                this.index = Double2ByteLinkedOpenHashMap.this.size;
            } else {
                int e;
                if (!Double2ByteLinkedOpenHashMap.this.containsKey(from)) {
                    throw new IllegalArgumentException("The key " + from + " does not belong to this set.");
                }
                this.next = Double2ByteLinkedOpenHashMap.this.first;
                while (Double2ByteLinkedOpenHashMap.this.key[e = this.nextEntry()] != from) {
                }
                this.curr = -1;
            }
        }

        public boolean hasNext() {
            return this.next != -1;
        }

        public boolean hasPrevious() {
            return this.prev != -1;
        }

        public int nextIndex() {
            return this.index;
        }

        public int previousIndex() {
            return this.index - 1;
        }

        public int nextEntry() {
            if (!this.hasNext()) {
                return Double2ByteLinkedOpenHashMap.this.size();
            }
            this.curr = this.next;
            this.next = Double2ByteLinkedOpenHashMap.this.link[this.curr] ^ this.prev;
            this.prev = this.curr;
            ++this.index;
            return this.curr;
        }

        public int previousEntry() {
            if (!this.hasPrevious()) {
                return -1;
            }
            this.curr = this.prev;
            this.prev = Double2ByteLinkedOpenHashMap.this.link[this.curr] ^ this.next;
            this.next = this.curr;
            --this.index;
            return this.curr;
        }

        public void remove() {
            if (this.curr == -1) {
                throw new IllegalStateException();
            }
            if (this.curr == this.prev) {
                --this.index;
                this.prev = Double2ByteLinkedOpenHashMap.this.link[this.curr] ^ this.next;
            } else {
                this.next = Double2ByteLinkedOpenHashMap.this.link[this.curr] ^ this.prev;
            }
            --Double2ByteLinkedOpenHashMap.this.size;
            if (this.prev == -1) {
                Double2ByteLinkedOpenHashMap.this.first = this.next;
            } else {
                int n = this.prev;
                Double2ByteLinkedOpenHashMap.this.link[n] = Double2ByteLinkedOpenHashMap.this.link[n] ^ (this.curr ^ this.next);
            }
            if (this.next == -1) {
                Double2ByteLinkedOpenHashMap.this.last = this.prev;
            } else {
                int n = this.next;
                Double2ByteLinkedOpenHashMap.this.link[n] = Double2ByteLinkedOpenHashMap.this.link[n] ^ (this.curr ^ this.prev);
            }
            int pos = this.curr;
            while (true) {
                int last = pos;
                pos = last + 1 & Double2ByteLinkedOpenHashMap.this.mask;
                while (Double2ByteLinkedOpenHashMap.this.used[pos]) {
                    int slot = (int)HashCommon.murmurHash3(Double.doubleToRawLongBits(Double2ByteLinkedOpenHashMap.this.key[pos])) & Double2ByteLinkedOpenHashMap.this.mask;
                    if (last <= pos ? last >= slot || slot > pos : last >= slot && slot > pos) break;
                    pos = pos + 1 & Double2ByteLinkedOpenHashMap.this.mask;
                }
                if (!Double2ByteLinkedOpenHashMap.this.used[pos]) break;
                Double2ByteLinkedOpenHashMap.this.key[last] = Double2ByteLinkedOpenHashMap.this.key[pos];
                Double2ByteLinkedOpenHashMap.this.value[last] = Double2ByteLinkedOpenHashMap.this.value[pos];
                if (this.next == pos) {
                    this.next = last;
                }
                if (this.prev == pos) {
                    this.prev = last;
                }
                Double2ByteLinkedOpenHashMap.this.fixPointers(pos, last);
            }
            Double2ByteLinkedOpenHashMap.this.used[last] = false;
            this.curr = -1;
        }

        public int skip(int n) {
            int i = n;
            while (i-- != 0 && this.hasNext()) {
                this.nextEntry();
            }
            return n - i - 1;
        }

        public int back(int n) {
            int i = n;
            while (i-- != 0 && this.hasPrevious()) {
                this.previousEntry();
            }
            return n - i - 1;
        }
    }

    private final class MapEntry
    implements Double2ByteMap.Entry,
    Map.Entry<Double, Byte> {
        private int index;

        MapEntry(int index) {
            this.index = index;
        }

        @Override
        public Double getKey() {
            return Double2ByteLinkedOpenHashMap.this.key[this.index];
        }

        @Override
        public double getDoubleKey() {
            return Double2ByteLinkedOpenHashMap.this.key[this.index];
        }

        @Override
        public Byte getValue() {
            return Double2ByteLinkedOpenHashMap.this.value[this.index];
        }

        @Override
        public byte getByteValue() {
            return Double2ByteLinkedOpenHashMap.this.value[this.index];
        }

        @Override
        public byte setValue(byte v) {
            byte oldValue = Double2ByteLinkedOpenHashMap.this.value[this.index];
            Double2ByteLinkedOpenHashMap.this.value[this.index] = v;
            return oldValue;
        }

        @Override
        public Byte setValue(Byte v) {
            return this.setValue((byte)v);
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return Double2ByteLinkedOpenHashMap.this.key[this.index] == (Double)e.getKey() && Double2ByteLinkedOpenHashMap.this.value[this.index] == (Byte)e.getValue();
        }

        @Override
        public int hashCode() {
            return HashCommon.double2int(Double2ByteLinkedOpenHashMap.this.key[this.index]) ^ Double2ByteLinkedOpenHashMap.this.value[this.index];
        }

        public String toString() {
            return Double2ByteLinkedOpenHashMap.this.key[this.index] + "=>" + Double2ByteLinkedOpenHashMap.this.value[this.index];
        }
    }
}

