/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.ints;

import it.unimi.dsi.fastutil.ints.AbstractIntPriorityQueue;
import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.ints.IntComparator;
import java.util.NoSuchElementException;

public class IntArrayPriorityQueue
extends AbstractIntPriorityQueue {
    protected int[] array = IntArrays.EMPTY_ARRAY;
    protected int size;
    protected IntComparator c;

    public IntArrayPriorityQueue(int capacity, IntComparator c) {
        if (capacity > 0) {
            this.array = new int[capacity];
        }
        this.c = c;
    }

    public IntArrayPriorityQueue(int capacity) {
        this(capacity, null);
    }

    public IntArrayPriorityQueue(IntComparator c) {
        this(0, c);
    }

    public IntArrayPriorityQueue() {
        this(0, null);
    }

    public IntArrayPriorityQueue(int[] a, int size, IntComparator c) {
        this(c);
        this.array = a;
        this.size = size;
    }

    public IntArrayPriorityQueue(int[] a, IntComparator c) {
        this(a, a.length, c);
    }

    public IntArrayPriorityQueue(int[] a, int size) {
        this(a, size, null);
    }

    public IntArrayPriorityQueue(int[] a) {
        this(a, a.length);
    }

    private int findFirst() {
        int i = this.size;
        int firstIndex = --i;
        int first = this.array[firstIndex];
        if (this.c == null) {
            while (i-- != 0) {
                if (this.array[i] >= first) continue;
                firstIndex = i;
                first = this.array[firstIndex];
            }
        } else {
            while (i-- != 0) {
                if (this.c.compare(this.array[i], first) >= 0) continue;
                firstIndex = i;
                first = this.array[firstIndex];
            }
        }
        return firstIndex;
    }

    private void ensureNonEmpty() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
    }

    @Override
    public void enqueue(int x) {
        if (this.size == this.array.length) {
            this.array = IntArrays.grow(this.array, this.size + 1);
        }
        this.array[this.size++] = x;
    }

    @Override
    public int dequeueInt() {
        this.ensureNonEmpty();
        int first = this.findFirst();
        int result = this.array[first];
        System.arraycopy(this.array, first + 1, this.array, first, --this.size - first);
        return result;
    }

    @Override
    public int firstInt() {
        this.ensureNonEmpty();
        return this.array[this.findFirst()];
    }

    @Override
    public void changed() {
        this.ensureNonEmpty();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void clear() {
        this.size = 0;
    }

    public void trim() {
        this.array = IntArrays.trim(this.array, this.size);
    }

    @Override
    public IntComparator comparator() {
        return this.c;
    }
}

