/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.longs;

import it.unimi.dsi.fastutil.Arrays;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.longs.LongComparator;
import java.io.Serializable;

public class LongArrays {
    public static final long ONEOVERPHI = 106039L;
    public static final long[] EMPTY_ARRAY = new long[0];
    private static final int SMALL = 7;
    private static final int MEDIUM = 40;
    public static final Hash.Strategy HASH_STRATEGY = new ArrayHashStrategy();

    private LongArrays() {
    }

    public static long[] ensureCapacity(long[] array, int length) {
        if (length > array.length) {
            long[] t = new long[length];
            System.arraycopy(array, 0, t, 0, array.length);
            return t;
        }
        return array;
    }

    public static long[] ensureCapacity(long[] array, int length, int preserve) {
        if (length > array.length) {
            long[] t = new long[length];
            System.arraycopy(array, 0, t, 0, preserve);
            return t;
        }
        return array;
    }

    public static long[] grow(long[] array, int length) {
        if (length > array.length) {
            int newLength = (int)Math.min(Math.max(106039L * (long)array.length >>> 16, (long)length), Integer.MAX_VALUE);
            long[] t = new long[newLength];
            System.arraycopy(array, 0, t, 0, array.length);
            return t;
        }
        return array;
    }

    public static long[] grow(long[] array, int length, int preserve) {
        if (length > array.length) {
            int newLength = (int)Math.min(Math.max(106039L * (long)array.length >>> 16, (long)length), Integer.MAX_VALUE);
            long[] t = new long[newLength];
            System.arraycopy(array, 0, t, 0, preserve);
            return t;
        }
        return array;
    }

    public static long[] trim(long[] array, int length) {
        if (length >= array.length) {
            return array;
        }
        long[] t = length == 0 ? EMPTY_ARRAY : new long[length];
        System.arraycopy(array, 0, t, 0, length);
        return t;
    }

    public static long[] setLength(long[] array, int length) {
        if (length == array.length) {
            return array;
        }
        if (length < array.length) {
            return LongArrays.trim(array, length);
        }
        return LongArrays.ensureCapacity(array, length);
    }

    public static long[] copy(long[] array, int offset, int length) {
        LongArrays.ensureOffsetLength(array, offset, length);
        long[] a = length == 0 ? EMPTY_ARRAY : new long[length];
        System.arraycopy(array, offset, a, 0, length);
        return a;
    }

    public static long[] copy(long[] array) {
        return (long[])array.clone();
    }

    public static void fill(long[] array, long value) {
        int i = array.length;
        while (i-- != 0) {
            array[i] = value;
        }
    }

    public static void fill(long[] array, int from, int to, long value) {
        LongArrays.ensureFromTo(array, from, to);
        if (from == 0) {
            while (to-- != 0) {
                array[to] = value;
            }
        } else {
            for (int i = from; i < to; ++i) {
                array[i] = value;
            }
        }
    }

    public static boolean equals(long[] a1, long[] a2) {
        int i = a1.length;
        if (i != a2.length) {
            return false;
        }
        while (i-- != 0) {
            if (a1[i] == a2[i]) continue;
            return false;
        }
        return true;
    }

    public static void ensureFromTo(long[] a, int from, int to) {
        Arrays.ensureFromTo(a.length, from, to);
    }

    public static void ensureOffsetLength(long[] a, int offset, int length) {
        Arrays.ensureOffsetLength(a.length, offset, length);
    }

    private static void swap(long[] x, int a, int b) {
        long t = x[a];
        x[a] = x[b];
        x[b] = t;
    }

    private static void vecSwap(long[] x, int a, int b, int n) {
        int i = 0;
        while (i < n) {
            LongArrays.swap(x, a, b);
            ++i;
            ++a;
            ++b;
        }
    }

    private static int med3(long[] x, int a, int b, int c, LongComparator comp) {
        int ab = comp.compare(x[a], x[b]);
        int ac = comp.compare(x[a], x[c]);
        int bc = comp.compare(x[b], x[c]);
        return ab < 0 ? (bc < 0 ? b : (ac < 0 ? c : a)) : (bc > 0 ? b : (ac > 0 ? c : a));
    }

    public static void quickSort(long[] x, int from, int to, LongComparator comp) {
        int c;
        int a;
        int len = to - from;
        if (len < 7) {
            for (int i = from; i < to; ++i) {
                for (int j = i; j > from && comp.compare(x[j - 1], x[j]) > 0; --j) {
                    LongArrays.swap(x, j, j - 1);
                }
            }
            return;
        }
        int m = from + len / 2;
        if (len > 7) {
            int l = from;
            int n = to - 1;
            if (len > 40) {
                int s = len / 8;
                l = LongArrays.med3(x, l, l + s, l + 2 * s, comp);
                m = LongArrays.med3(x, m - s, m, m + s, comp);
                n = LongArrays.med3(x, n - 2 * s, n - s, n, comp);
            }
            m = LongArrays.med3(x, l, m, n, comp);
        }
        long v = x[m];
        int b = a = from;
        int d = c = to - 1;
        while (true) {
            int comparison;
            if (b <= c && (comparison = comp.compare(x[b], v)) <= 0) {
                if (comparison == 0) {
                    LongArrays.swap(x, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && (comparison = comp.compare(x[c], v)) >= 0) {
                if (comparison == 0) {
                    LongArrays.swap(x, c, d--);
                }
                --c;
            }
            if (b > c) break;
            LongArrays.swap(x, b++, c--);
        }
        int n = to;
        int s = Math.min(a - from, b - a);
        LongArrays.vecSwap(x, from, b - s, s);
        s = Math.min(d - c, n - d - 1);
        LongArrays.vecSwap(x, b, n - s, s);
        s = b - a;
        if (s > 1) {
            LongArrays.quickSort(x, from, from + s, comp);
        }
        if ((s = d - c) > 1) {
            LongArrays.quickSort(x, n - s, n, comp);
        }
    }

    public static void quickSort(long[] x, LongComparator comp) {
        LongArrays.quickSort(x, 0, x.length, comp);
    }

    private static int med3(long[] x, int a, int b, int c) {
        int bc;
        int ac;
        int ab;
        int n = x[a] < x[b] ? -1 : (ab = x[a] == x[b] ? 0 : 1);
        int n2 = x[a] < x[c] ? -1 : (ac = x[a] == x[c] ? 0 : 1);
        int n3 = x[b] < x[c] ? -1 : (bc = x[b] == x[c] ? 0 : 1);
        return ab < 0 ? (bc < 0 ? b : (ac < 0 ? c : a)) : (bc > 0 ? b : (ac > 0 ? c : a));
    }

    public static void quickSort(long[] x, int from, int to) {
        int c;
        int a;
        int len = to - from;
        if (len < 7) {
            for (int i = from; i < to; ++i) {
                for (int j = i; j > from && x[j] < x[j - 1]; --j) {
                    LongArrays.swap(x, j, j - 1);
                }
            }
            return;
        }
        int m = from + len / 2;
        if (len > 7) {
            int l = from;
            int n = to - 1;
            if (len > 40) {
                int s = len / 8;
                l = LongArrays.med3(x, l, l + s, l + 2 * s);
                m = LongArrays.med3(x, m - s, m, m + s);
                n = LongArrays.med3(x, n - 2 * s, n - s, n);
            }
            m = LongArrays.med3(x, l, m, n);
        }
        long v = x[m];
        int b = a = from;
        int d = c = to - 1;
        while (true) {
            int comparison;
            if (b <= c && (x[b] < v ? -1 : (comparison = x[b] == v ? 0 : 1)) <= 0) {
                if (comparison == 0) {
                    LongArrays.swap(x, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && (x[c] < v ? -1 : (comparison = x[c] == v ? 0 : 1)) >= 0) {
                if (comparison == 0) {
                    LongArrays.swap(x, c, d--);
                }
                --c;
            }
            if (b > c) break;
            LongArrays.swap(x, b++, c--);
        }
        int n = to;
        int s = Math.min(a - from, b - a);
        LongArrays.vecSwap(x, from, b - s, s);
        s = Math.min(d - c, n - d - 1);
        LongArrays.vecSwap(x, b, n - s, s);
        s = b - a;
        if (s > 1) {
            LongArrays.quickSort(x, from, from + s);
        }
        if ((s = d - c) > 1) {
            LongArrays.quickSort(x, n - s, n);
        }
    }

    public static void quickSort(long[] x) {
        LongArrays.quickSort(x, 0, x.length);
    }

    public static void mergeSort(long[] a, int from, int to, long[] supp) {
        int len = to - from;
        if (len < 7) {
            for (int i = from; i < to; ++i) {
                for (int j = i; j > from && a[j] < a[j - 1]; --j) {
                    LongArrays.swap(a, j, j - 1);
                }
            }
            return;
        }
        int mid = from + to >>> 1;
        LongArrays.mergeSort(supp, from, mid, a);
        LongArrays.mergeSort(supp, mid, to, a);
        if (supp[mid - 1] <= supp[mid]) {
            System.arraycopy(supp, from, a, from, len);
            return;
        }
        int p = from;
        int q = mid;
        for (int i = from; i < to; ++i) {
            a[i] = q >= to || p < mid && supp[p] <= supp[q] ? supp[p++] : supp[q++];
        }
    }

    public static void mergeSort(long[] a, int from, int to) {
        LongArrays.mergeSort(a, from, to, (long[])a.clone());
    }

    public static void mergeSort(long[] a) {
        LongArrays.mergeSort(a, 0, a.length);
    }

    public static void mergeSort(long[] a, int from, int to, LongComparator comp, long[] supp) {
        int len = to - from;
        if (len < 7) {
            for (int i = from; i < to; ++i) {
                for (int j = i; j > from && comp.compare(a[j - 1], a[j]) > 0; --j) {
                    LongArrays.swap(a, j, j - 1);
                }
            }
            return;
        }
        int mid = from + to >>> 1;
        LongArrays.mergeSort(supp, from, mid, comp, a);
        LongArrays.mergeSort(supp, mid, to, comp, a);
        if (comp.compare(supp[mid - 1], supp[mid]) <= 0) {
            System.arraycopy(supp, from, a, from, len);
            return;
        }
        int p = from;
        int q = mid;
        for (int i = from; i < to; ++i) {
            a[i] = q >= to || p < mid && comp.compare(supp[p], supp[q]) <= 0 ? supp[p++] : supp[q++];
        }
    }

    public static void mergeSort(long[] a, int from, int to, LongComparator comp) {
        LongArrays.mergeSort(a, from, to, comp, (long[])a.clone());
    }

    public static void mergeSort(long[] a, LongComparator comp) {
        LongArrays.mergeSort(a, 0, a.length, comp);
    }

    public static int binarySearch(long[] a, int from, int to, long key) {
        while (from <= to) {
            int mid = from + to >>> 1;
            long midVal = a[mid];
            if (midVal < key) {
                from = mid + 1;
                continue;
            }
            if (midVal > key) {
                to = mid - 1;
                continue;
            }
            return mid;
        }
        return -(from + 1);
    }

    public static int binarySearch(long[] a, long key) {
        return LongArrays.binarySearch(a, 0, a.length, key);
    }

    public static int binarySearch(long[] a, int from, int to, long key, LongComparator c) {
        while (from <= to) {
            int mid = from + to >>> 1;
            long midVal = a[mid];
            int cmp = c.compare(midVal, key);
            if (cmp < 0) {
                from = mid + 1;
                continue;
            }
            if (cmp > 0) {
                to = mid - 1;
                continue;
            }
            return mid;
        }
        return -(from + 1);
    }

    public static int binarySearch(long[] a, long key, LongComparator c) {
        return LongArrays.binarySearch(a, 0, a.length, key, c);
    }

    private static final class ArrayHashStrategy
    implements Hash.Strategy<long[]>,
    Serializable {
        public static final long serialVersionUID = -7046029254386353129L;

        private ArrayHashStrategy() {
        }

        @Override
        public int hashCode(long[] o) {
            return java.util.Arrays.hashCode(o);
        }

        @Override
        public boolean equals(long[] a, long[] b) {
            return LongArrays.equals(a, b);
        }
    }
}

