/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.longs;

import it.unimi.dsi.fastutil.BigArrays;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.longs.LongArrays;
import it.unimi.dsi.fastutil.longs.LongComparator;
import java.io.Serializable;
import java.util.Arrays;

public class LongBigArrays {
    public static final long ONEOVERPHI = 106039L;
    public static final long[][] EMPTY_BIG_ARRAY = new long[0][];
    public static final Hash.Strategy HASH_STRATEGY = new BigArrayHashStrategy();
    private static final int SMALL = 7;
    private static final int MEDIUM = 40;

    private LongBigArrays() {
    }

    public static long get(long[][] array, long index) {
        return array[BigArrays.segment(index)][BigArrays.displacement(index)];
    }

    public static void set(long[][] array, long index, long value) {
        array[BigArrays.segment((long)index)][BigArrays.displacement((long)index)] = value;
    }

    public static void swap(long[][] array, long first, long second) {
        long t = array[BigArrays.segment(first)][BigArrays.displacement(first)];
        array[BigArrays.segment((long)first)][BigArrays.displacement((long)first)] = array[BigArrays.segment(second)][BigArrays.displacement(second)];
        array[BigArrays.segment((long)second)][BigArrays.displacement((long)second)] = t;
    }

    public static void add(long[][] array, long index, long incr) {
        long[] lArray = array[BigArrays.segment(index)];
        int n = BigArrays.displacement(index);
        lArray[n] = lArray[n] + incr;
    }

    public static void mul(long[][] array, long index, long factor) {
        long[] lArray = array[BigArrays.segment(index)];
        int n = BigArrays.displacement(index);
        lArray[n] = lArray[n] * factor;
    }

    public static void incr(long[][] array, long index) {
        long[] lArray = array[BigArrays.segment(index)];
        int n = BigArrays.displacement(index);
        lArray[n] = lArray[n] + 1L;
    }

    public static void decr(long[][] array, long index) {
        long[] lArray = array[BigArrays.segment(index)];
        int n = BigArrays.displacement(index);
        lArray[n] = lArray[n] - 1L;
    }

    public static long length(long[][] array) {
        int length = array.length;
        return length == 0 ? 0L : BigArrays.start(length - 1) + (long)array[length - 1].length;
    }

    public static void copy(long[][] srcArray, long srcPos, long[][] destArray, long destPos, long length) {
        if (destPos <= srcPos) {
            int srcSegment = BigArrays.segment(srcPos);
            int destSegment = BigArrays.segment(destPos);
            int srcDispl = BigArrays.displacement(srcPos);
            int destDispl = BigArrays.displacement(destPos);
            while (length > 0L) {
                int l = (int)Math.min(length, (long)Math.min(srcArray[srcSegment].length - srcDispl, destArray[destSegment].length - destDispl));
                System.arraycopy(srcArray[srcSegment], srcDispl, destArray[destSegment], destDispl, l);
                if ((srcDispl += l) == 0x8000000) {
                    srcDispl = 0;
                    ++srcSegment;
                }
                if ((destDispl += l) == 0x8000000) {
                    destDispl = 0;
                    ++destSegment;
                }
                length -= (long)l;
            }
        } else {
            int srcSegment = BigArrays.segment(srcPos + length);
            int destSegment = BigArrays.segment(destPos + length);
            int srcDispl = BigArrays.displacement(srcPos + length);
            int destDispl = BigArrays.displacement(destPos + length);
            while (length > 0L) {
                if (srcDispl == 0) {
                    srcDispl = 0x8000000;
                    --srcSegment;
                }
                if (destDispl == 0) {
                    destDispl = 0x8000000;
                    --destSegment;
                }
                int l = (int)Math.min(length, (long)Math.min(srcDispl, destDispl));
                System.arraycopy(srcArray[srcSegment], srcDispl - l, destArray[destSegment], destDispl - l, l);
                srcDispl -= l;
                destDispl -= l;
                length -= (long)l;
            }
        }
    }

    public static void copyFromBig(long[][] srcArray, long srcPos, long[] destArray, int destPos, int length) {
        int srcSegment = BigArrays.segment(srcPos);
        int srcDispl = BigArrays.displacement(srcPos);
        while (length > 0) {
            int l = Math.min(srcArray[srcSegment].length - srcDispl, length);
            System.arraycopy(srcArray[srcSegment], srcDispl, destArray, destPos, l);
            if ((srcDispl += l) == 0x8000000) {
                srcDispl = 0;
                ++srcSegment;
            }
            destPos += l;
            length -= l;
        }
    }

    public static void copyToBig(long[] srcArray, int srcPos, long[][] destArray, long destPos, long length) {
        int destSegment = BigArrays.segment(destPos);
        int destDispl = BigArrays.displacement(destPos);
        while (length > 0L) {
            int l = (int)Math.min((long)(destArray[destSegment].length - destDispl), length);
            System.arraycopy(srcArray, srcPos, destArray[destSegment], destDispl, l);
            if ((destDispl += l) == 0x8000000) {
                destDispl = 0;
                ++destSegment;
            }
            srcPos += l;
            length -= (long)l;
        }
    }

    public static long[][] newBigArray(long length) {
        if (length == 0L) {
            return EMPTY_BIG_ARRAY;
        }
        int baseLength = (int)((length + 0x7FFFFFFL) / 0x8000000L);
        long[][] base = new long[baseLength][];
        int residual = (int)(length & 0x7FFFFFFL);
        if (residual != 0) {
            for (int i = 0; i < baseLength - 1; ++i) {
                base[i] = new long[0x8000000];
            }
            base[baseLength - 1] = new long[residual];
        } else {
            for (int i = 0; i < baseLength; ++i) {
                base[i] = new long[0x8000000];
            }
        }
        return base;
    }

    public static long[][] wrap(long[] array) {
        if (array.length == 0) {
            return EMPTY_BIG_ARRAY;
        }
        if (array.length <= 0x8000000) {
            return new long[][]{array};
        }
        long[][] bigArray = LongBigArrays.newBigArray(array.length);
        for (int i = 0; i < bigArray.length; ++i) {
            System.arraycopy(array, (int)BigArrays.start(i), bigArray[i], 0, bigArray[i].length);
        }
        return bigArray;
    }

    public static long[][] ensureCapacity(long[][] array, long length) {
        return LongBigArrays.ensureCapacity(array, length, LongBigArrays.length(array));
    }

    public static long[][] ensureCapacity(long[][] array, long length, long preserve) {
        long oldLength = LongBigArrays.length(array);
        if (length > oldLength) {
            int valid = array.length - (array.length == 0 || array.length > 0 && array[array.length - 1].length == 0x8000000 ? 0 : 1);
            int baseLength = (int)((length + 0x7FFFFFFL) / 0x8000000L);
            long[][] base = (long[][])Arrays.copyOf(array, baseLength);
            int residual = (int)(length & 0x7FFFFFFL);
            if (residual != 0) {
                for (int i = valid; i < baseLength - 1; ++i) {
                    base[i] = new long[0x8000000];
                }
                base[baseLength - 1] = new long[residual];
            } else {
                for (int i = valid; i < baseLength; ++i) {
                    base[i] = new long[0x8000000];
                }
            }
            if (preserve - (long)valid * 0x8000000L > 0L) {
                LongBigArrays.copy(array, (long)valid * 0x8000000L, base, (long)valid * 0x8000000L, preserve - (long)valid * 0x8000000L);
            }
            return base;
        }
        return array;
    }

    public static long[][] grow(long[][] array, long length) {
        long oldLength = LongBigArrays.length(array);
        return length > oldLength ? LongBigArrays.grow(array, length, oldLength) : array;
    }

    public static long[][] grow(long[][] array, long length, long preserve) {
        long oldLength = LongBigArrays.length(array);
        return length > oldLength ? LongBigArrays.ensureCapacity(array, Math.max(106039L * oldLength >>> 16, length), preserve) : array;
    }

    public static long[][] trim(long[][] array, long length) {
        long oldLength = LongBigArrays.length(array);
        if (length >= oldLength) {
            return array;
        }
        int baseLength = (int)((length + 0x7FFFFFFL) / 0x8000000L);
        long[][] base = (long[][])Arrays.copyOf(array, baseLength);
        int residual = (int)(length & 0x7FFFFFFL);
        if (residual != 0) {
            base[baseLength - 1] = LongArrays.trim(base[baseLength - 1], residual);
        }
        return base;
    }

    public static long[][] setLength(long[][] array, long length) {
        long oldLength = LongBigArrays.length(array);
        if (length == oldLength) {
            return array;
        }
        if (length < oldLength) {
            return LongBigArrays.trim(array, length);
        }
        return LongBigArrays.ensureCapacity(array, length);
    }

    public static long[][] copy(long[][] array, long offset, long length) {
        LongBigArrays.ensureOffsetLength(array, offset, length);
        long[][] a = LongBigArrays.newBigArray(length);
        LongBigArrays.copy(array, offset, a, 0L, length);
        return a;
    }

    public static long[][] copy(long[][] array) {
        long[][] base = (long[][])array.clone();
        int i = base.length;
        while (i-- != 0) {
            base[i] = (long[])array[i].clone();
        }
        return base;
    }

    public static void fill(long[][] array, long value) {
        int i = array.length;
        while (i-- != 0) {
            LongArrays.fill(array[i], value);
        }
    }

    public static void fill(long[][] array, long from, long to, long value) {
        long length = LongBigArrays.length(array);
        BigArrays.ensureFromTo(length, from, to);
        int fromSegment = BigArrays.segment(from);
        int toSegment = BigArrays.segment(to);
        int fromDispl = BigArrays.displacement(from);
        int toDispl = BigArrays.displacement(to);
        if (fromSegment == toSegment) {
            LongArrays.fill(array[fromSegment], fromDispl, toDispl, value);
            return;
        }
        if (toDispl != 0) {
            LongArrays.fill(array[toSegment], 0, toDispl, value);
        }
        while (--toSegment > fromSegment) {
            LongArrays.fill(array[toSegment], value);
        }
        LongArrays.fill(array[fromSegment], fromDispl, 0x8000000, value);
    }

    public static boolean equals(long[][] a1, long[][] a2) {
        if (LongBigArrays.length(a1) != LongBigArrays.length(a2)) {
            return false;
        }
        int i = a1.length;
        while (i-- != 0) {
            long[] t = a1[i];
            long[] u = a2[i];
            int j = t.length;
            while (j-- != 0) {
                if (t[j] == u[j]) continue;
                return false;
            }
        }
        return true;
    }

    public static String toString(long[][] a) {
        if (a == null) {
            return "null";
        }
        long last = LongBigArrays.length(a) - 1L;
        if (last == -1L) {
            return "[]";
        }
        StringBuilder b = new StringBuilder();
        b.append('[');
        long i = 0L;
        while (true) {
            b.append(String.valueOf(LongBigArrays.get(a, i)));
            if (i == last) {
                return b.append(']').toString();
            }
            b.append(", ");
            ++i;
        }
    }

    public static void ensureFromTo(long[][] a, long from, long to) {
        BigArrays.ensureFromTo(LongBigArrays.length(a), from, to);
    }

    public static void ensureOffsetLength(long[][] a, long offset, long length) {
        BigArrays.ensureOffsetLength(LongBigArrays.length(a), offset, length);
    }

    private static void vecSwap(long[][] x, long a, long b, long n) {
        int i = 0;
        while ((long)i < n) {
            LongBigArrays.swap(x, a, b);
            ++i;
            ++a;
            ++b;
        }
    }

    private static long med3(long[][] x, long a, long b, long c, LongComparator comp) {
        int ab = comp.compare(LongBigArrays.get(x, a), LongBigArrays.get(x, b));
        int ac = comp.compare(LongBigArrays.get(x, a), LongBigArrays.get(x, c));
        int bc = comp.compare(LongBigArrays.get(x, b), LongBigArrays.get(x, c));
        return ab < 0 ? (bc < 0 ? b : (ac < 0 ? c : a)) : (bc > 0 ? b : (ac > 0 ? c : a));
    }

    public static void quickSort(long[][] x, long from, long to, LongComparator comp) {
        long c;
        long a;
        long len = to - from;
        if (len < 7L) {
            for (long i = from; i < to; ++i) {
                for (long j = i; j > from && comp.compare(LongBigArrays.get(x, j - 1L), LongBigArrays.get(x, j)) > 0; --j) {
                    LongBigArrays.swap(x, j, j - 1L);
                }
            }
            return;
        }
        long m = from + len / 2L;
        if (len > 7L) {
            long l = from;
            long n = to - 1L;
            if (len > 40L) {
                long s = len / 8L;
                l = LongBigArrays.med3(x, l, l + s, l + 2L * s, comp);
                m = LongBigArrays.med3(x, m - s, m, m + s, comp);
                n = LongBigArrays.med3(x, n - 2L * s, n - s, n, comp);
            }
            m = LongBigArrays.med3(x, l, m, n, comp);
        }
        long v = LongBigArrays.get(x, m);
        long b = a = from;
        long d = c = to - 1L;
        while (true) {
            int comparison;
            if (b <= c && (comparison = comp.compare(LongBigArrays.get(x, b), v)) <= 0) {
                if (comparison == 0) {
                    LongBigArrays.swap(x, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && (comparison = comp.compare(LongBigArrays.get(x, c), v)) >= 0) {
                if (comparison == 0) {
                    LongBigArrays.swap(x, c, d--);
                }
                --c;
            }
            if (b > c) break;
            LongBigArrays.swap(x, b++, c--);
        }
        long n = to;
        long s = Math.min(a - from, b - a);
        LongBigArrays.vecSwap(x, from, b - s, s);
        s = Math.min(d - c, n - d - 1L);
        LongBigArrays.vecSwap(x, b, n - s, s);
        s = b - a;
        if (s > 1L) {
            LongBigArrays.quickSort(x, from, from + s, comp);
        }
        if ((s = d - c) > 1L) {
            LongBigArrays.quickSort(x, n - s, n, comp);
        }
    }

    private static long med3(long[][] x, long a, long b, long c) {
        int bc;
        int ac;
        int ab;
        int n = LongBigArrays.get(x, a) < LongBigArrays.get(x, b) ? -1 : (ab = LongBigArrays.get(x, a) == LongBigArrays.get(x, b) ? 0 : 1);
        int n2 = LongBigArrays.get(x, a) < LongBigArrays.get(x, c) ? -1 : (ac = LongBigArrays.get(x, a) == LongBigArrays.get(x, c) ? 0 : 1);
        int n3 = LongBigArrays.get(x, b) < LongBigArrays.get(x, c) ? -1 : (bc = LongBigArrays.get(x, b) == LongBigArrays.get(x, c) ? 0 : 1);
        return ab < 0 ? (bc < 0 ? b : (ac < 0 ? c : a)) : (bc > 0 ? b : (ac > 0 ? c : a));
    }

    public static void quickSort(long[][] x, LongComparator comp) {
        LongBigArrays.quickSort(x, 0L, LongBigArrays.length(x), comp);
    }

    public static void quickSort(long[][] x, long from, long to) {
        long c;
        long a;
        long len = to - from;
        if (len < 7L) {
            for (long i = from; i < to; ++i) {
                for (long j = i; j > from && (LongBigArrays.get(x, j - 1L) < LongBigArrays.get(x, j) ? -1 : (LongBigArrays.get(x, j - 1L) == LongBigArrays.get(x, j) ? 0 : 1)) > 0; --j) {
                    LongBigArrays.swap(x, j, j - 1L);
                }
            }
            return;
        }
        long m = from + len / 2L;
        if (len > 7L) {
            long l = from;
            long n = to - 1L;
            if (len > 40L) {
                long s = len / 8L;
                l = LongBigArrays.med3(x, l, l + s, l + 2L * s);
                m = LongBigArrays.med3(x, m - s, m, m + s);
                n = LongBigArrays.med3(x, n - 2L * s, n - s, n);
            }
            m = LongBigArrays.med3(x, l, m, n);
        }
        long v = LongBigArrays.get(x, m);
        long b = a = from;
        long d = c = to - 1L;
        while (true) {
            int comparison;
            if (b <= c && (LongBigArrays.get(x, b) < v ? -1 : (comparison = LongBigArrays.get(x, b) == v ? 0 : 1)) <= 0) {
                if (comparison == 0) {
                    LongBigArrays.swap(x, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && (LongBigArrays.get(x, c) < v ? -1 : (comparison = LongBigArrays.get(x, c) == v ? 0 : 1)) >= 0) {
                if (comparison == 0) {
                    LongBigArrays.swap(x, c, d--);
                }
                --c;
            }
            if (b > c) break;
            LongBigArrays.swap(x, b++, c--);
        }
        long n = to;
        long s = Math.min(a - from, b - a);
        LongBigArrays.vecSwap(x, from, b - s, s);
        s = Math.min(d - c, n - d - 1L);
        LongBigArrays.vecSwap(x, b, n - s, s);
        s = b - a;
        if (s > 1L) {
            LongBigArrays.quickSort(x, from, from + s);
        }
        if ((s = d - c) > 1L) {
            LongBigArrays.quickSort(x, n - s, n);
        }
    }

    public static void quickSort(long[][] x) {
        LongBigArrays.quickSort(x, 0L, LongBigArrays.length(x));
    }

    public static long binarySearch(long[][] a, long from, long to, long key) {
        while (from <= to) {
            long mid = from + to >>> 1;
            long midVal = LongBigArrays.get(a, mid);
            if (midVal < key) {
                from = mid + 1L;
                continue;
            }
            if (midVal > key) {
                to = mid - 1L;
                continue;
            }
            return mid;
        }
        return -(from + 1L);
    }

    public static long binarySearch(long[][] a, long key) {
        return LongBigArrays.binarySearch(a, 0L, LongBigArrays.length(a), key);
    }

    public static long binarySearch(long[][] a, long from, long to, long key, LongComparator c) {
        while (from <= to) {
            long mid = from + to >>> 1;
            long midVal = LongBigArrays.get(a, mid);
            int cmp = c.compare(midVal, key);
            if (cmp < 0) {
                from = mid + 1L;
                continue;
            }
            if (cmp > 0) {
                to = mid - 1L;
                continue;
            }
            return mid;
        }
        return -(from + 1L);
    }

    public static long binarySearch(long[][] a, long key, LongComparator c) {
        return LongBigArrays.binarySearch(a, 0L, LongBigArrays.length(a), key, c);
    }

    private static final class BigArrayHashStrategy
    implements Hash.Strategy<long[][]>,
    Serializable {
        public static final long serialVersionUID = -7046029254386353129L;

        private BigArrayHashStrategy() {
        }

        @Override
        public int hashCode(long[][] o) {
            return Arrays.deepHashCode((Object[])o);
        }

        @Override
        public boolean equals(long[][] a, long[][] b) {
            return LongBigArrays.equals(a, b);
        }
    }
}

