/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.floats;

import it.unimi.dsi.fastutil.floats.AbstractFloatPriorityQueue;
import it.unimi.dsi.fastutil.floats.FloatArrays;
import it.unimi.dsi.fastutil.floats.FloatComparator;
import java.util.NoSuchElementException;

public class FloatArrayFIFOQueue
extends AbstractFloatPriorityQueue {
    public static final int INITIAL_CAPACITY = 16;
    protected float[] array = FloatArrays.EMPTY_ARRAY;
    protected int length;
    protected int start;
    protected int end;

    public FloatArrayFIFOQueue(int capacity) {
        if (capacity > 0) {
            this.array = new float[capacity];
        }
        this.length = this.array.length;
    }

    public FloatArrayFIFOQueue() {
        this(16);
    }

    public FloatComparator comparator() {
        return null;
    }

    public float dequeueFloat() {
        if (this.start == this.end) {
            throw new NoSuchElementException();
        }
        float t = this.array[this.start];
        if (++this.start == this.length) {
            this.start = 0;
        }
        return t;
    }

    public void enqueue(float x) {
        this.array[this.end++] = x;
        if (this.end == this.length) {
            this.end = 0;
        }
        if (this.end == this.start) {
            float[] newArray = FloatArrays.grow(this.array, this.length + 1, 0);
            System.arraycopy(this.array, this.start, newArray, 0, this.length - this.start);
            System.arraycopy(this.array, 0, newArray, this.length - this.start, this.end);
            this.start = 0;
            this.end = this.length;
            this.array = newArray;
            this.length = newArray.length;
        }
    }

    public float firstFloat() {
        if (this.start == this.end) {
            throw new NoSuchElementException();
        }
        return this.array[this.start];
    }

    public float lastFloat() {
        if (this.start == this.end) {
            throw new NoSuchElementException();
        }
        return this.array[(this.end == 0 ? this.length : this.end) - 1];
    }

    public void clear() {
        this.end = 0;
        this.start = 0;
    }

    public void trim() {
        int size = this.size();
        float[] newArray = new float[size + 1];
        if (this.start <= this.end) {
            System.arraycopy(this.array, this.start, newArray, 0, this.end - this.start);
        } else {
            System.arraycopy(this.array, this.start, newArray, 0, this.length - this.start);
            System.arraycopy(this.array, 0, newArray, this.length - this.start, this.end);
        }
        this.start = 0;
        this.end = size;
        this.length = this.end + 1;
        this.array = newArray;
    }

    public int size() {
        int apparentLength = this.end - this.start;
        return apparentLength >= 0 ? apparentLength : this.length + apparentLength;
    }
}

