/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.objects;

import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.booleans.BooleanArrays;
import it.unimi.dsi.fastutil.chars.AbstractCharCollection;
import it.unimi.dsi.fastutil.chars.CharCollection;
import it.unimi.dsi.fastutil.chars.CharIterator;
import it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import it.unimi.dsi.fastutil.objects.AbstractReference2CharMap;
import it.unimi.dsi.fastutil.objects.AbstractReferenceSet;
import it.unimi.dsi.fastutil.objects.ObjectArrays;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.Reference2CharMap;
import it.unimi.dsi.fastutil.objects.ReferenceSet;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Map;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Reference2CharOpenHashMap<K>
extends AbstractReference2CharMap<K>
implements Serializable,
Cloneable,
Hash {
    public static final long serialVersionUID = 0L;
    private static final boolean ASSERTS = false;
    protected transient K[] key;
    protected transient char[] value;
    protected transient boolean[] used;
    protected final float f;
    protected transient int n;
    protected transient int maxFill;
    protected transient int mask;
    protected int size;
    protected volatile transient Reference2CharMap.FastEntrySet<K> entries;
    protected volatile transient ReferenceSet<K> keys;
    protected volatile transient CharCollection values;

    public Reference2CharOpenHashMap(int expected, float f) {
        if (f <= 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and smaller than or equal to 1");
        }
        if (expected < 0) {
            throw new IllegalArgumentException("The expected number of elements must be nonnegative");
        }
        this.f = f;
        this.n = HashCommon.arraySize(expected, f);
        this.mask = this.n - 1;
        this.maxFill = HashCommon.maxFill(this.n, f);
        this.key = new Object[this.n];
        this.value = new char[this.n];
        this.used = new boolean[this.n];
    }

    public Reference2CharOpenHashMap(int expected) {
        this(expected, 0.75f);
    }

    public Reference2CharOpenHashMap() {
        this(16, 0.75f);
    }

    public Reference2CharOpenHashMap(Map<? extends K, ? extends Character> m, float f) {
        this(m.size(), f);
        this.putAll(m);
    }

    public Reference2CharOpenHashMap(Map<? extends K, ? extends Character> m) {
        this(m, 0.75f);
    }

    public Reference2CharOpenHashMap(Reference2CharMap<K> m, float f) {
        this(m.size(), f);
        this.putAll(m);
    }

    public Reference2CharOpenHashMap(Reference2CharMap<K> m) {
        this(m, 0.75f);
    }

    public Reference2CharOpenHashMap(K[] k, char[] v, float f) {
        this(k.length, f);
        if (k.length != v.length) {
            throw new IllegalArgumentException("The key array and the value array have different lengths (" + k.length + " and " + v.length + ")");
        }
        for (int i = 0; i < k.length; ++i) {
            this.put(k[i], v[i]);
        }
    }

    public Reference2CharOpenHashMap(K[] k, char[] v) {
        this(k, v, 0.75f);
    }

    @Override
    public char put(K k, char v) {
        int pos = (k == null ? 142593372 : HashCommon.murmurHash3(System.identityHashCode(k))) & this.mask;
        while (this.used[pos]) {
            if (k == this.key[pos]) {
                char oldValue = this.value[pos];
                this.value[pos] = v;
                return oldValue;
            }
            pos = pos + 1 & this.mask;
        }
        this.used[pos] = true;
        this.key[pos] = k;
        this.value[pos] = v;
        if (++this.size >= this.maxFill) {
            this.rehash(HashCommon.arraySize(this.size + 1, this.f));
        }
        return this.defRetValue;
    }

    @Override
    public Character put(K ok, Character ov) {
        char v = ov.charValue();
        K k = ok;
        int pos = (k == null ? 142593372 : HashCommon.murmurHash3(System.identityHashCode(k))) & this.mask;
        while (this.used[pos]) {
            if (k == this.key[pos]) {
                Character oldValue = Character.valueOf(this.value[pos]);
                this.value[pos] = v;
                return oldValue;
            }
            pos = pos + 1 & this.mask;
        }
        this.used[pos] = true;
        this.key[pos] = k;
        this.value[pos] = v;
        if (++this.size >= this.maxFill) {
            this.rehash(HashCommon.arraySize(this.size + 1, this.f));
        }
        return null;
    }

    protected final void shiftKeys(int pos) {
        while (true) {
            int last = pos;
            pos = last + 1 & this.mask;
            while (this.used[pos]) {
                int slot = (this.key[pos] == null ? 142593372 : HashCommon.murmurHash3(System.identityHashCode(this.key[pos]))) & this.mask;
                if (last <= pos ? last >= slot || slot > pos : last >= slot && slot > pos) break;
                pos = pos + 1 & this.mask;
            }
            if (!this.used[pos]) break;
            this.key[last] = this.key[pos];
            this.value[last] = this.value[pos];
        }
        this.used[last] = false;
        this.key[last] = null;
    }

    @Override
    public char removeChar(Object k) {
        int pos = (k == null ? 142593372 : HashCommon.murmurHash3(System.identityHashCode(k))) & this.mask;
        while (this.used[pos]) {
            if (k == this.key[pos]) {
                --this.size;
                char v = this.value[pos];
                this.shiftKeys(pos);
                return v;
            }
            pos = pos + 1 & this.mask;
        }
        return this.defRetValue;
    }

    @Override
    public Character remove(Object ok) {
        Object k = ok;
        int pos = (k == null ? 142593372 : HashCommon.murmurHash3(System.identityHashCode(k))) & this.mask;
        while (this.used[pos]) {
            if (k == this.key[pos]) {
                --this.size;
                char v = this.value[pos];
                this.shiftKeys(pos);
                return Character.valueOf(v);
            }
            pos = pos + 1 & this.mask;
        }
        return null;
    }

    @Override
    public char getChar(Object k) {
        int pos = (k == null ? 142593372 : HashCommon.murmurHash3(System.identityHashCode(k))) & this.mask;
        while (this.used[pos]) {
            if (k == this.key[pos]) {
                return this.value[pos];
            }
            pos = pos + 1 & this.mask;
        }
        return this.defRetValue;
    }

    @Override
    public boolean containsKey(Object k) {
        int pos = (k == null ? 142593372 : HashCommon.murmurHash3(System.identityHashCode(k))) & this.mask;
        while (this.used[pos]) {
            if (k == this.key[pos]) {
                return true;
            }
            pos = pos + 1 & this.mask;
        }
        return false;
    }

    @Override
    public boolean containsValue(char v) {
        char[] value = this.value;
        boolean[] used = this.used;
        int i = this.n;
        while (i-- != 0) {
            if (!used[i] || value[i] != v) continue;
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        if (this.size == 0) {
            return;
        }
        this.size = 0;
        BooleanArrays.fill(this.used, false);
        ObjectArrays.fill(this.key, null);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Deprecated
    public void growthFactor(int growthFactor) {
    }

    @Deprecated
    public int growthFactor() {
        return 16;
    }

    public Reference2CharMap.FastEntrySet<K> reference2CharEntrySet() {
        if (this.entries == null) {
            this.entries = new MapEntrySet();
        }
        return this.entries;
    }

    @Override
    public ReferenceSet<K> keySet() {
        if (this.keys == null) {
            this.keys = new KeySet();
        }
        return this.keys;
    }

    @Override
    public CharCollection values() {
        if (this.values == null) {
            this.values = new AbstractCharCollection(){

                public CharIterator iterator() {
                    return new ValueIterator();
                }

                public int size() {
                    return Reference2CharOpenHashMap.this.size;
                }

                public boolean contains(char v) {
                    return Reference2CharOpenHashMap.this.containsValue(v);
                }

                public void clear() {
                    Reference2CharOpenHashMap.this.clear();
                }
            };
        }
        return this.values;
    }

    @Deprecated
    public boolean rehash() {
        return true;
    }

    public boolean trim() {
        int l = HashCommon.arraySize(this.size, this.f);
        if (l >= this.n) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    public boolean trim(int n) {
        int l = HashCommon.nextPowerOfTwo((int)Math.ceil((float)n / this.f));
        if (this.n <= l) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    protected void rehash(int newN) {
        int i = 0;
        boolean[] used = this.used;
        K[] key = this.key;
        char[] value = this.value;
        int newMask = newN - 1;
        Object[] newKey = new Object[newN];
        char[] newValue = new char[newN];
        boolean[] newUsed = new boolean[newN];
        int j = this.size;
        while (j-- != 0) {
            while (!used[i]) {
                ++i;
            }
            K k = key[i];
            int pos = (k == null ? 142593372 : HashCommon.murmurHash3(System.identityHashCode(k))) & newMask;
            while (newUsed[pos]) {
                pos = pos + 1 & newMask;
            }
            newUsed[pos] = true;
            newKey[pos] = k;
            newValue[pos] = value[i];
            ++i;
        }
        this.n = newN;
        this.mask = newMask;
        this.maxFill = HashCommon.maxFill(this.n, this.f);
        this.key = newKey;
        this.value = newValue;
        this.used = newUsed;
    }

    public Reference2CharOpenHashMap<K> clone() {
        Reference2CharOpenHashMap c;
        try {
            c = (Reference2CharOpenHashMap)super.clone();
        }
        catch (CloneNotSupportedException cantHappen) {
            throw new InternalError();
        }
        c.keys = null;
        c.values = null;
        c.entries = null;
        c.key = (Object[])this.key.clone();
        c.value = (char[])this.value.clone();
        c.used = (boolean[])this.used.clone();
        return c;
    }

    @Override
    public int hashCode() {
        int h = 0;
        int j = this.size;
        int i = 0;
        int t = 0;
        while (j-- != 0) {
            while (!this.used[i]) {
                ++i;
            }
            if (this != this.key[i]) {
                t = this.key[i] == null ? 0 : System.identityHashCode(this.key[i]);
            }
            h += (t ^= this.value[i]);
            ++i;
        }
        return h;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        K[] key = this.key;
        char[] value = this.value;
        MapIterator i = new MapIterator();
        s.defaultWriteObject();
        int j = this.size;
        while (j-- != 0) {
            int e = i.nextEntry();
            s.writeObject(key[e]);
            s.writeChar(value[e]);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.n = HashCommon.arraySize(this.size, this.f);
        this.maxFill = HashCommon.maxFill(this.n, this.f);
        this.mask = this.n - 1;
        this.key = new Object[this.n];
        Object[] key = this.key;
        this.value = new char[this.n];
        char[] value = this.value;
        this.used = new boolean[this.n];
        boolean[] used = this.used;
        int i = this.size;
        int pos = 0;
        while (i-- != 0) {
            Object k = s.readObject();
            char v = s.readChar();
            pos = (k == null ? 142593372 : HashCommon.murmurHash3(System.identityHashCode(k))) & this.mask;
            while (used[pos]) {
                pos = pos + 1 & this.mask;
            }
            used[pos] = true;
            key[pos] = k;
            value[pos] = v;
        }
    }

    private void checkTable() {
    }

    private final class ValueIterator
    extends MapIterator
    implements CharIterator {
        public char nextChar() {
            return Reference2CharOpenHashMap.this.value[this.nextEntry()];
        }

        public Character next() {
            return Character.valueOf(Reference2CharOpenHashMap.this.value[this.nextEntry()]);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class KeySet
    extends AbstractReferenceSet<K> {
        private KeySet() {
        }

        @Override
        public ObjectIterator<K> iterator() {
            return new KeyIterator();
        }

        @Override
        public int size() {
            return Reference2CharOpenHashMap.this.size;
        }

        @Override
        public boolean contains(Object k) {
            return Reference2CharOpenHashMap.this.containsKey(k);
        }

        @Override
        public boolean remove(Object k) {
            int oldSize = Reference2CharOpenHashMap.this.size;
            Reference2CharOpenHashMap.this.remove(k);
            return Reference2CharOpenHashMap.this.size != oldSize;
        }

        @Override
        public void clear() {
            Reference2CharOpenHashMap.this.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class KeyIterator
    extends MapIterator
    implements ObjectIterator<K> {
        @Override
        public K next() {
            return Reference2CharOpenHashMap.this.key[this.nextEntry()];
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class MapEntrySet
    extends AbstractObjectSet<Reference2CharMap.Entry<K>>
    implements Reference2CharMap.FastEntrySet<K> {
        private MapEntrySet() {
        }

        @Override
        public ObjectIterator<Reference2CharMap.Entry<K>> iterator() {
            return new EntryIterator();
        }

        @Override
        public ObjectIterator<Reference2CharMap.Entry<K>> fastIterator() {
            return new FastEntryIterator();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object k = e.getKey();
            int pos = (k == null ? 142593372 : HashCommon.murmurHash3(System.identityHashCode(k))) & Reference2CharOpenHashMap.this.mask;
            while (Reference2CharOpenHashMap.this.used[pos]) {
                if (k == Reference2CharOpenHashMap.this.key[pos]) {
                    return Reference2CharOpenHashMap.this.value[pos] == ((Character)e.getValue()).charValue();
                }
                pos = pos + 1 & Reference2CharOpenHashMap.this.mask;
            }
            return false;
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object k = e.getKey();
            int pos = (k == null ? 142593372 : HashCommon.murmurHash3(System.identityHashCode(k))) & Reference2CharOpenHashMap.this.mask;
            while (Reference2CharOpenHashMap.this.used[pos]) {
                if (k == Reference2CharOpenHashMap.this.key[pos]) {
                    Reference2CharOpenHashMap.this.remove(e.getKey());
                    return true;
                }
                pos = pos + 1 & Reference2CharOpenHashMap.this.mask;
            }
            return false;
        }

        @Override
        public int size() {
            return Reference2CharOpenHashMap.this.size;
        }

        @Override
        public void clear() {
            Reference2CharOpenHashMap.this.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FastEntryIterator
    extends MapIterator
    implements ObjectIterator<Reference2CharMap.Entry<K>> {
        final AbstractReference2CharMap.BasicEntry<K> entry;

        private FastEntryIterator() {
            this.entry = new AbstractReference2CharMap.BasicEntry<Object>(null, '\u0000');
        }

        @Override
        public AbstractReference2CharMap.BasicEntry<K> next() {
            int e = this.nextEntry();
            this.entry.key = Reference2CharOpenHashMap.this.key[e];
            this.entry.value = Reference2CharOpenHashMap.this.value[e];
            return this.entry;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntryIterator
    extends MapIterator
    implements ObjectIterator<Reference2CharMap.Entry<K>> {
        private EntryIterator() {
        }

        @Override
        public Reference2CharMap.Entry<K> next() {
            return new MapEntry(this.nextEntry());
        }
    }

    private class MapIterator {
        int pos;
        int last;
        int c;

        private MapIterator() {
            this.pos = Reference2CharOpenHashMap.this.n;
            this.last = -1;
            this.c = Reference2CharOpenHashMap.this.size;
            boolean[] used = Reference2CharOpenHashMap.this.used;
            if (this.c != 0) {
                while (!used[--this.pos]) {
                }
            }
        }

        public boolean hasNext() {
            return this.c != 0;
        }

        public int nextEntry() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.last = this.pos;
            if (--this.c != 0) {
                boolean[] used = Reference2CharOpenHashMap.this.used;
                while (!used[this.pos = this.pos - 1 & Reference2CharOpenHashMap.this.mask]) {
                }
            }
            return this.last;
        }

        public void remove() {
            if (this.last == -1) {
                throw new IllegalStateException();
            }
            --Reference2CharOpenHashMap.this.size;
            Reference2CharOpenHashMap.this.shiftKeys(this.last);
            this.last = -1;
        }

        public int skip(int n) {
            int i = n;
            while (i-- != 0 && this.hasNext()) {
                this.nextEntry();
            }
            return n - i - 1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class MapEntry
    implements Reference2CharMap.Entry<K>,
    Map.Entry<K, Character> {
        private int index;

        MapEntry(int index) {
            this.index = index;
        }

        @Override
        public K getKey() {
            return Reference2CharOpenHashMap.this.key[this.index];
        }

        @Override
        public Character getValue() {
            return Character.valueOf(Reference2CharOpenHashMap.this.value[this.index]);
        }

        @Override
        public char getCharValue() {
            return Reference2CharOpenHashMap.this.value[this.index];
        }

        @Override
        public char setValue(char v) {
            char oldValue = Reference2CharOpenHashMap.this.value[this.index];
            Reference2CharOpenHashMap.this.value[this.index] = v;
            return oldValue;
        }

        @Override
        public Character setValue(Character v) {
            return Character.valueOf(this.setValue(v.charValue()));
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return Reference2CharOpenHashMap.this.key[this.index] == e.getKey() && Reference2CharOpenHashMap.this.value[this.index] == ((Character)e.getValue()).charValue();
        }

        @Override
        public int hashCode() {
            return (Reference2CharOpenHashMap.this.key[this.index] == null ? 0 : System.identityHashCode(Reference2CharOpenHashMap.this.key[this.index])) ^ Reference2CharOpenHashMap.this.value[this.index];
        }

        public String toString() {
            return Reference2CharOpenHashMap.this.key[this.index] + "=>" + Reference2CharOpenHashMap.this.value[this.index];
        }
    }
}

