/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.doubles;

import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.SafeMath;
import it.unimi.dsi.fastutil.doubles.AbstractDouble2ShortMap;
import it.unimi.dsi.fastutil.doubles.AbstractDoubleSet;
import it.unimi.dsi.fastutil.doubles.Double2ShortFunction;
import it.unimi.dsi.fastutil.doubles.Double2ShortMap;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleIterator;
import it.unimi.dsi.fastutil.doubles.DoubleSet;
import it.unimi.dsi.fastutil.doubles.DoubleShortPair;
import it.unimi.dsi.fastutil.doubles.DoubleSpliterator;
import it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectSpliterator;
import it.unimi.dsi.fastutil.shorts.AbstractShortCollection;
import it.unimi.dsi.fastutil.shorts.ShortBinaryOperator;
import it.unimi.dsi.fastutil.shorts.ShortCollection;
import it.unimi.dsi.fastutil.shorts.ShortConsumer;
import it.unimi.dsi.fastutil.shorts.ShortIterator;
import it.unimi.dsi.fastutil.shorts.ShortSpliterator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.DoubleFunction;
import java.util.function.DoubleToIntFunction;

public class Double2ShortOpenHashMap
extends AbstractDouble2ShortMap
implements Serializable,
Cloneable,
Hash {
    private static final long serialVersionUID = 0L;
    private static final boolean ASSERTS = false;
    protected transient double[] key;
    protected transient short[] value;
    protected transient int mask;
    protected transient boolean containsNullKey;
    protected transient int n;
    protected transient int maxFill;
    protected final transient int minN;
    protected int size;
    protected final float f;
    protected transient Double2ShortMap.FastEntrySet entries;
    protected transient DoubleSet keys;
    protected transient ShortCollection values;

    public Double2ShortOpenHashMap(int expected, float f) {
        if (f <= 0.0f || f >= 1.0f) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and smaller than 1");
        }
        if (expected < 0) {
            throw new IllegalArgumentException("The expected number of elements must be nonnegative");
        }
        this.f = f;
        this.minN = this.n = HashCommon.arraySize(expected, f);
        this.mask = this.n - 1;
        this.maxFill = HashCommon.maxFill(this.n, f);
        this.key = new double[this.n + 1];
        this.value = new short[this.n + 1];
    }

    public Double2ShortOpenHashMap(int expected) {
        this(expected, 0.75f);
    }

    public Double2ShortOpenHashMap() {
        this(16, 0.75f);
    }

    public Double2ShortOpenHashMap(Map<? extends Double, ? extends Short> m, float f) {
        this(m.size(), f);
        this.putAll(m);
    }

    public Double2ShortOpenHashMap(Map<? extends Double, ? extends Short> m) {
        this(m, 0.75f);
    }

    public Double2ShortOpenHashMap(Double2ShortMap m, float f) {
        this(m.size(), f);
        this.putAll(m);
    }

    public Double2ShortOpenHashMap(Double2ShortMap m) {
        this(m, 0.75f);
    }

    public Double2ShortOpenHashMap(double[] k, short[] v, float f) {
        this(k.length, f);
        if (k.length != v.length) {
            throw new IllegalArgumentException("The key array and the value array have different lengths (" + k.length + " and " + v.length + ")");
        }
        for (int i = 0; i < k.length; ++i) {
            this.put(k[i], v[i]);
        }
    }

    public Double2ShortOpenHashMap(double[] k, short[] v) {
        this(k, v, 0.75f);
    }

    private int realSize() {
        return this.containsNullKey ? this.size - 1 : this.size;
    }

    public void ensureCapacity(int capacity) {
        int needed = HashCommon.arraySize(capacity, this.f);
        if (needed > this.n) {
            this.rehash(needed);
        }
    }

    private void tryCapacity(long capacity) {
        int needed = (int)Math.min(0x40000000L, Math.max(2L, HashCommon.nextPowerOfTwo((long)Math.ceil((float)capacity / this.f))));
        if (needed > this.n) {
            this.rehash(needed);
        }
    }

    private short removeEntry(int pos) {
        short oldValue = this.value[pos];
        --this.size;
        this.shiftKeys(pos);
        if (this.n > this.minN && this.size < this.maxFill / 4 && this.n > 16) {
            this.rehash(this.n / 2);
        }
        return oldValue;
    }

    private short removeNullEntry() {
        this.containsNullKey = false;
        short oldValue = this.value[this.n];
        --this.size;
        if (this.n > this.minN && this.size < this.maxFill / 4 && this.n > 16) {
            this.rehash(this.n / 2);
        }
        return oldValue;
    }

    @Override
    public void putAll(Map<? extends Double, ? extends Short> m) {
        if ((double)this.f <= 0.5) {
            this.ensureCapacity(m.size());
        } else {
            this.tryCapacity(this.size() + m.size());
        }
        super.putAll(m);
    }

    private int find(double k) {
        if (Double.doubleToRawLongBits(k) == 0L) {
            return this.containsNullKey ? this.n : -(this.n + 1);
        }
        double[] key = this.key;
        int pos = (int)HashCommon.mix(Double.doubleToRawLongBits(k)) & this.mask;
        double curr = key[pos];
        if (Double.doubleToRawLongBits(curr) == 0L) {
            return -(pos + 1);
        }
        if (Double.doubleToRawLongBits(k) == Double.doubleToRawLongBits(curr)) {
            return pos;
        }
        do {
            if (Double.doubleToRawLongBits(curr = key[pos = pos + 1 & this.mask]) != 0L) continue;
            return -(pos + 1);
        } while (Double.doubleToRawLongBits(k) != Double.doubleToRawLongBits(curr));
        return pos;
    }

    private void insert(int pos, double k, short v) {
        if (pos == this.n) {
            this.containsNullKey = true;
        }
        this.key[pos] = k;
        this.value[pos] = v;
        if (this.size++ >= this.maxFill) {
            this.rehash(HashCommon.arraySize(this.size + 1, this.f));
        }
    }

    @Override
    public short put(double k, short v) {
        int pos = this.find(k);
        if (pos < 0) {
            this.insert(-pos - 1, k, v);
            return this.defRetValue;
        }
        short oldValue = this.value[pos];
        this.value[pos] = v;
        return oldValue;
    }

    private short addToValue(int pos, short incr) {
        short oldValue = this.value[pos];
        this.value[pos] = (short)(oldValue + incr);
        return oldValue;
    }

    public short addTo(double k, short incr) {
        int pos;
        if (Double.doubleToRawLongBits(k) == 0L) {
            if (this.containsNullKey) {
                return this.addToValue(this.n, incr);
            }
            pos = this.n;
            this.containsNullKey = true;
        } else {
            double[] key = this.key;
            pos = (int)HashCommon.mix(Double.doubleToRawLongBits(k)) & this.mask;
            double curr = key[pos];
            if (Double.doubleToRawLongBits(curr) != 0L) {
                if (Double.doubleToRawLongBits(curr) == Double.doubleToRawLongBits(k)) {
                    return this.addToValue(pos, incr);
                }
                while (Double.doubleToRawLongBits(curr = key[pos = pos + 1 & this.mask]) != 0L) {
                    if (Double.doubleToRawLongBits(curr) != Double.doubleToRawLongBits(k)) continue;
                    return this.addToValue(pos, incr);
                }
            }
        }
        this.key[pos] = k;
        this.value[pos] = (short)(this.defRetValue + incr);
        if (this.size++ >= this.maxFill) {
            this.rehash(HashCommon.arraySize(this.size + 1, this.f));
        }
        return this.defRetValue;
    }

    protected final void shiftKeys(int pos) {
        double[] key = this.key;
        short[] value = this.value;
        while (true) {
            double curr;
            int last = pos;
            pos = last + 1 & this.mask;
            while (true) {
                if (Double.doubleToRawLongBits(curr = key[pos]) == 0L) {
                    key[last] = 0.0;
                    return;
                }
                int slot = (int)HashCommon.mix(Double.doubleToRawLongBits(curr)) & this.mask;
                if (last <= pos ? last >= slot || slot > pos : last >= slot && slot > pos) break;
                pos = pos + 1 & this.mask;
            }
            key[last] = curr;
            value[last] = value[pos];
        }
    }

    @Override
    public short remove(double k) {
        if (Double.doubleToRawLongBits(k) == 0L) {
            if (this.containsNullKey) {
                return this.removeNullEntry();
            }
            return this.defRetValue;
        }
        double[] key = this.key;
        int pos = (int)HashCommon.mix(Double.doubleToRawLongBits(k)) & this.mask;
        double curr = key[pos];
        if (Double.doubleToRawLongBits(curr) == 0L) {
            return this.defRetValue;
        }
        if (Double.doubleToRawLongBits(k) == Double.doubleToRawLongBits(curr)) {
            return this.removeEntry(pos);
        }
        do {
            if (Double.doubleToRawLongBits(curr = key[pos = pos + 1 & this.mask]) != 0L) continue;
            return this.defRetValue;
        } while (Double.doubleToRawLongBits(k) != Double.doubleToRawLongBits(curr));
        return this.removeEntry(pos);
    }

    @Override
    public short get(double k) {
        if (Double.doubleToRawLongBits(k) == 0L) {
            return this.containsNullKey ? this.value[this.n] : this.defRetValue;
        }
        double[] key = this.key;
        int pos = (int)HashCommon.mix(Double.doubleToRawLongBits(k)) & this.mask;
        double curr = key[pos];
        if (Double.doubleToRawLongBits(curr) == 0L) {
            return this.defRetValue;
        }
        if (Double.doubleToRawLongBits(k) == Double.doubleToRawLongBits(curr)) {
            return this.value[pos];
        }
        do {
            if (Double.doubleToRawLongBits(curr = key[pos = pos + 1 & this.mask]) != 0L) continue;
            return this.defRetValue;
        } while (Double.doubleToRawLongBits(k) != Double.doubleToRawLongBits(curr));
        return this.value[pos];
    }

    @Override
    public boolean containsKey(double k) {
        if (Double.doubleToRawLongBits(k) == 0L) {
            return this.containsNullKey;
        }
        double[] key = this.key;
        int pos = (int)HashCommon.mix(Double.doubleToRawLongBits(k)) & this.mask;
        double curr = key[pos];
        if (Double.doubleToRawLongBits(curr) == 0L) {
            return false;
        }
        if (Double.doubleToRawLongBits(k) == Double.doubleToRawLongBits(curr)) {
            return true;
        }
        do {
            if (Double.doubleToRawLongBits(curr = key[pos = pos + 1 & this.mask]) != 0L) continue;
            return false;
        } while (Double.doubleToRawLongBits(k) != Double.doubleToRawLongBits(curr));
        return true;
    }

    @Override
    public boolean containsValue(short v) {
        double[] key = this.key;
        short[] value = this.value;
        if (this.containsNullKey && value[this.n] == v) {
            return true;
        }
        int i = this.n;
        while (i-- != 0) {
            if (Double.doubleToRawLongBits(key[i]) == 0L || value[i] != v) continue;
            return true;
        }
        return false;
    }

    @Override
    public short getOrDefault(double k, short defaultValue) {
        if (Double.doubleToRawLongBits(k) == 0L) {
            return this.containsNullKey ? this.value[this.n] : defaultValue;
        }
        double[] key = this.key;
        int pos = (int)HashCommon.mix(Double.doubleToRawLongBits(k)) & this.mask;
        double curr = key[pos];
        if (Double.doubleToRawLongBits(curr) == 0L) {
            return defaultValue;
        }
        if (Double.doubleToRawLongBits(k) == Double.doubleToRawLongBits(curr)) {
            return this.value[pos];
        }
        do {
            if (Double.doubleToRawLongBits(curr = key[pos = pos + 1 & this.mask]) != 0L) continue;
            return defaultValue;
        } while (Double.doubleToRawLongBits(k) != Double.doubleToRawLongBits(curr));
        return this.value[pos];
    }

    @Override
    public short putIfAbsent(double k, short v) {
        int pos = this.find(k);
        if (pos >= 0) {
            return this.value[pos];
        }
        this.insert(-pos - 1, k, v);
        return this.defRetValue;
    }

    @Override
    public boolean remove(double k, short v) {
        if (Double.doubleToRawLongBits(k) == 0L) {
            if (this.containsNullKey && v == this.value[this.n]) {
                this.removeNullEntry();
                return true;
            }
            return false;
        }
        double[] key = this.key;
        int pos = (int)HashCommon.mix(Double.doubleToRawLongBits(k)) & this.mask;
        double curr = key[pos];
        if (Double.doubleToRawLongBits(curr) == 0L) {
            return false;
        }
        if (Double.doubleToRawLongBits(k) == Double.doubleToRawLongBits(curr) && v == this.value[pos]) {
            this.removeEntry(pos);
            return true;
        }
        do {
            if (Double.doubleToRawLongBits(curr = key[pos = pos + 1 & this.mask]) != 0L) continue;
            return false;
        } while (Double.doubleToRawLongBits(k) != Double.doubleToRawLongBits(curr) || v != this.value[pos]);
        this.removeEntry(pos);
        return true;
    }

    @Override
    public boolean replace(double k, short oldValue, short v) {
        int pos = this.find(k);
        if (pos < 0 || oldValue != this.value[pos]) {
            return false;
        }
        this.value[pos] = v;
        return true;
    }

    @Override
    public short replace(double k, short v) {
        int pos = this.find(k);
        if (pos < 0) {
            return this.defRetValue;
        }
        short oldValue = this.value[pos];
        this.value[pos] = v;
        return oldValue;
    }

    @Override
    public short computeIfAbsent(double k, DoubleToIntFunction mappingFunction) {
        Objects.requireNonNull(mappingFunction);
        int pos = this.find(k);
        if (pos >= 0) {
            return this.value[pos];
        }
        short newValue = SafeMath.safeIntToShort(mappingFunction.applyAsInt(k));
        this.insert(-pos - 1, k, newValue);
        return newValue;
    }

    @Override
    public short computeIfAbsent(double key, Double2ShortFunction mappingFunction) {
        Objects.requireNonNull(mappingFunction);
        int pos = this.find(key);
        if (pos >= 0) {
            return this.value[pos];
        }
        if (!mappingFunction.containsKey(key)) {
            return this.defRetValue;
        }
        short newValue = mappingFunction.get(key);
        this.insert(-pos - 1, key, newValue);
        return newValue;
    }

    @Override
    public short computeIfAbsentNullable(double k, DoubleFunction<? extends Short> mappingFunction) {
        Objects.requireNonNull(mappingFunction);
        int pos = this.find(k);
        if (pos >= 0) {
            return this.value[pos];
        }
        Short newValue = mappingFunction.apply(k);
        if (newValue == null) {
            return this.defRetValue;
        }
        short v = newValue;
        this.insert(-pos - 1, k, v);
        return v;
    }

    @Override
    public short computeIfPresent(double k, BiFunction<? super Double, ? super Short, ? extends Short> remappingFunction) {
        Objects.requireNonNull(remappingFunction);
        int pos = this.find(k);
        if (pos < 0) {
            return this.defRetValue;
        }
        Short newValue = remappingFunction.apply((Double)k, (Short)this.value[pos]);
        if (newValue == null) {
            if (Double.doubleToRawLongBits(k) == 0L) {
                this.removeNullEntry();
            } else {
                this.removeEntry(pos);
            }
            return this.defRetValue;
        }
        this.value[pos] = newValue;
        return this.value[pos];
    }

    @Override
    public short compute(double k, BiFunction<? super Double, ? super Short, ? extends Short> remappingFunction) {
        Objects.requireNonNull(remappingFunction);
        int pos = this.find(k);
        Short newValue = remappingFunction.apply((Double)k, pos >= 0 ? Short.valueOf(this.value[pos]) : null);
        if (newValue == null) {
            if (pos >= 0) {
                if (Double.doubleToRawLongBits(k) == 0L) {
                    this.removeNullEntry();
                } else {
                    this.removeEntry(pos);
                }
            }
            return this.defRetValue;
        }
        short newVal = newValue;
        if (pos < 0) {
            this.insert(-pos - 1, k, newVal);
            return newVal;
        }
        this.value[pos] = newVal;
        return this.value[pos];
    }

    @Override
    public short mergeShort(double k, short v, ShortBinaryOperator remappingFunction) {
        short newValue;
        Objects.requireNonNull(remappingFunction);
        int pos = this.find(k);
        if (pos < 0) {
            this.insert(-pos - 1, k, v);
            return v;
        }
        this.value[pos] = newValue = remappingFunction.apply(this.value[pos], v);
        return this.value[pos];
    }

    @Override
    public short merge(double k, short v, BiFunction<? super Short, ? super Short, ? extends Short> remappingFunction) {
        Objects.requireNonNull(remappingFunction);
        int pos = this.find(k);
        if (pos < 0) {
            if (pos < 0) {
                this.insert(-pos - 1, k, v);
            } else {
                this.value[pos] = v;
            }
            return v;
        }
        Short newValue = remappingFunction.apply((Short)this.value[pos], (Short)v);
        if (newValue == null) {
            if (Double.doubleToRawLongBits(k) == 0L) {
                this.removeNullEntry();
            } else {
                this.removeEntry(pos);
            }
            return this.defRetValue;
        }
        this.value[pos] = newValue;
        return this.value[pos];
    }

    @Override
    public void clear() {
        if (this.size == 0) {
            return;
        }
        this.size = 0;
        this.containsNullKey = false;
        Arrays.fill(this.key, 0.0);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public void forEach(Double2ShortMap.EntryConsumer consumer) {
        if (this.containsNullKey) {
            consumer.accept(this.key[this.n], this.value[this.n]);
        }
        double[] key = this.key;
        int pos = this.n;
        while (pos-- != 0) {
            if (Double.doubleToRawLongBits(key[pos]) == 0L) continue;
            consumer.accept(key[pos], this.value[pos]);
        }
    }

    public Double2ShortMap.FastEntrySet double2ShortEntrySet() {
        if (this.entries == null) {
            this.entries = new MapEntrySet();
        }
        return this.entries;
    }

    @Override
    public DoubleSet keySet() {
        if (this.keys == null) {
            this.keys = new KeySet();
        }
        return this.keys;
    }

    @Override
    public ShortCollection values() {
        if (this.values == null) {
            this.values = new AbstractShortCollection(){

                @Override
                public ShortIterator iterator() {
                    return new ValueIterator();
                }

                @Override
                public ShortSpliterator spliterator() {
                    return new ValueSpliterator();
                }

                @Override
                public void forEach(ShortConsumer consumer) {
                    double[] key = Double2ShortOpenHashMap.this.key;
                    short[] value = Double2ShortOpenHashMap.this.value;
                    if (Double2ShortOpenHashMap.this.containsNullKey) {
                        consumer.accept(value[Double2ShortOpenHashMap.this.n]);
                    }
                    int pos = Double2ShortOpenHashMap.this.n;
                    while (pos-- != 0) {
                        if (Double.doubleToRawLongBits(key[pos]) == 0L) continue;
                        consumer.accept(value[pos]);
                    }
                }

                @Override
                public int size() {
                    return Double2ShortOpenHashMap.this.size;
                }

                @Override
                public boolean contains(short v) {
                    return Double2ShortOpenHashMap.this.containsValue(v);
                }

                @Override
                public void clear() {
                    Double2ShortOpenHashMap.this.clear();
                }
            };
        }
        return this.values;
    }

    public boolean trim() {
        return this.trim(this.size);
    }

    public boolean trim(int n) {
        int l = HashCommon.nextPowerOfTwo((int)Math.ceil((float)n / this.f));
        if (l >= this.n || this.size > HashCommon.maxFill(l, this.f)) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    protected void rehash(int newN) {
        double[] key = this.key;
        short[] value = this.value;
        int mask = newN - 1;
        double[] newKey = new double[newN + 1];
        short[] newValue = new short[newN + 1];
        int i = this.n;
        int j = this.realSize();
        while (j-- != 0) {
            while (Double.doubleToRawLongBits(key[--i]) == 0L) {
            }
            int pos = (int)HashCommon.mix(Double.doubleToRawLongBits(key[i])) & mask;
            if (Double.doubleToRawLongBits(newKey[pos]) != 0L) {
                while (Double.doubleToRawLongBits(newKey[pos = pos + 1 & mask]) != 0L) {
                }
            }
            newKey[pos] = key[i];
            newValue[pos] = value[i];
        }
        newValue[newN] = value[this.n];
        this.n = newN;
        this.mask = mask;
        this.maxFill = HashCommon.maxFill(this.n, this.f);
        this.key = newKey;
        this.value = newValue;
    }

    public Double2ShortOpenHashMap clone() {
        Double2ShortOpenHashMap c;
        try {
            c = (Double2ShortOpenHashMap)super.clone();
        }
        catch (CloneNotSupportedException cantHappen) {
            throw new InternalError();
        }
        c.keys = null;
        c.values = null;
        c.entries = null;
        c.containsNullKey = this.containsNullKey;
        c.key = (double[])this.key.clone();
        c.value = (short[])this.value.clone();
        return c;
    }

    @Override
    public int hashCode() {
        int h = 0;
        double[] key = this.key;
        short[] value = this.value;
        int j = this.realSize();
        int i = 0;
        int t = 0;
        while (j-- != 0) {
            while (Double.doubleToRawLongBits(key[i]) == 0L) {
                ++i;
            }
            t = HashCommon.double2int(key[i]);
            h += (t ^= value[i]);
            ++i;
        }
        if (this.containsNullKey) {
            h += value[this.n];
        }
        return h;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        double[] key = this.key;
        short[] value = this.value;
        EntryIterator i = new EntryIterator();
        s.defaultWriteObject();
        int j = this.size;
        while (j-- != 0) {
            int e = i.nextEntry();
            s.writeDouble(key[e]);
            s.writeShort(value[e]);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.n = HashCommon.arraySize(this.size, this.f);
        this.maxFill = HashCommon.maxFill(this.n, this.f);
        this.mask = this.n - 1;
        this.key = new double[this.n + 1];
        double[] key = this.key;
        this.value = new short[this.n + 1];
        short[] value = this.value;
        int i = this.size;
        while (i-- != 0) {
            int pos;
            double k = s.readDouble();
            short v = s.readShort();
            if (Double.doubleToRawLongBits(k) == 0L) {
                pos = this.n;
                this.containsNullKey = true;
            } else {
                pos = (int)HashCommon.mix(Double.doubleToRawLongBits(k)) & this.mask;
                while (Double.doubleToRawLongBits(key[pos]) != 0L) {
                    pos = pos + 1 & this.mask;
                }
            }
            key[pos] = k;
            value[pos] = v;
        }
    }

    private void checkTable() {
    }

    private final class MapEntrySet
    extends AbstractObjectSet<Double2ShortMap.Entry>
    implements Double2ShortMap.FastEntrySet {
        private MapEntrySet() {
        }

        @Override
        public ObjectIterator<Double2ShortMap.Entry> iterator() {
            return new EntryIterator();
        }

        @Override
        public ObjectIterator<Double2ShortMap.Entry> fastIterator() {
            return new FastEntryIterator();
        }

        @Override
        public ObjectSpliterator<Double2ShortMap.Entry> spliterator() {
            return new EntrySpliterator();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            if (e.getKey() == null || !(e.getKey() instanceof Double)) {
                return false;
            }
            if (e.getValue() == null || !(e.getValue() instanceof Short)) {
                return false;
            }
            double k = (Double)e.getKey();
            short v = (Short)e.getValue();
            if (Double.doubleToRawLongBits(k) == 0L) {
                return Double2ShortOpenHashMap.this.containsNullKey && Double2ShortOpenHashMap.this.value[Double2ShortOpenHashMap.this.n] == v;
            }
            double[] key = Double2ShortOpenHashMap.this.key;
            int pos = (int)HashCommon.mix(Double.doubleToRawLongBits(k)) & Double2ShortOpenHashMap.this.mask;
            double curr = key[pos];
            if (Double.doubleToRawLongBits(curr) == 0L) {
                return false;
            }
            if (Double.doubleToRawLongBits(k) == Double.doubleToRawLongBits(curr)) {
                return Double2ShortOpenHashMap.this.value[pos] == v;
            }
            do {
                if (Double.doubleToRawLongBits(curr = key[pos = pos + 1 & Double2ShortOpenHashMap.this.mask]) != 0L) continue;
                return false;
            } while (Double.doubleToRawLongBits(k) != Double.doubleToRawLongBits(curr));
            return Double2ShortOpenHashMap.this.value[pos] == v;
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            if (e.getKey() == null || !(e.getKey() instanceof Double)) {
                return false;
            }
            if (e.getValue() == null || !(e.getValue() instanceof Short)) {
                return false;
            }
            double k = (Double)e.getKey();
            short v = (Short)e.getValue();
            if (Double.doubleToRawLongBits(k) == 0L) {
                if (Double2ShortOpenHashMap.this.containsNullKey && Double2ShortOpenHashMap.this.value[Double2ShortOpenHashMap.this.n] == v) {
                    Double2ShortOpenHashMap.this.removeNullEntry();
                    return true;
                }
                return false;
            }
            double[] key = Double2ShortOpenHashMap.this.key;
            int pos = (int)HashCommon.mix(Double.doubleToRawLongBits(k)) & Double2ShortOpenHashMap.this.mask;
            double curr = key[pos];
            if (Double.doubleToRawLongBits(curr) == 0L) {
                return false;
            }
            if (Double.doubleToRawLongBits(curr) == Double.doubleToRawLongBits(k)) {
                if (Double2ShortOpenHashMap.this.value[pos] == v) {
                    Double2ShortOpenHashMap.this.removeEntry(pos);
                    return true;
                }
                return false;
            }
            do {
                if (Double.doubleToRawLongBits(curr = key[pos = pos + 1 & Double2ShortOpenHashMap.this.mask]) != 0L) continue;
                return false;
            } while (Double.doubleToRawLongBits(curr) != Double.doubleToRawLongBits(k) || Double2ShortOpenHashMap.this.value[pos] != v);
            Double2ShortOpenHashMap.this.removeEntry(pos);
            return true;
        }

        @Override
        public int size() {
            return Double2ShortOpenHashMap.this.size;
        }

        @Override
        public void clear() {
            Double2ShortOpenHashMap.this.clear();
        }

        @Override
        public void forEach(Consumer<? super Double2ShortMap.Entry> consumer) {
            if (Double2ShortOpenHashMap.this.containsNullKey) {
                consumer.accept(new MapEntry(Double2ShortOpenHashMap.this.n));
            }
            double[] key = Double2ShortOpenHashMap.this.key;
            int pos = Double2ShortOpenHashMap.this.n;
            while (pos-- != 0) {
                if (Double.doubleToRawLongBits(key[pos]) == 0L) continue;
                consumer.accept(new MapEntry(pos));
            }
        }

        @Override
        public void fastForEach(Consumer<? super Double2ShortMap.Entry> consumer) {
            MapEntry entry = new MapEntry();
            if (Double2ShortOpenHashMap.this.containsNullKey) {
                entry.index = Double2ShortOpenHashMap.this.n;
                consumer.accept(entry);
            }
            double[] key = Double2ShortOpenHashMap.this.key;
            int pos = Double2ShortOpenHashMap.this.n;
            while (pos-- != 0) {
                if (Double.doubleToRawLongBits(key[pos]) == 0L) continue;
                entry.index = pos;
                consumer.accept(entry);
            }
        }
    }

    private final class KeySet
    extends AbstractDoubleSet {
        private KeySet() {
        }

        @Override
        public DoubleIterator iterator() {
            return new KeyIterator();
        }

        @Override
        public DoubleSpliterator spliterator() {
            return new KeySpliterator();
        }

        @Override
        public void forEach(DoubleConsumer consumer) {
            double[] key = Double2ShortOpenHashMap.this.key;
            if (Double2ShortOpenHashMap.this.containsNullKey) {
                consumer.accept(key[Double2ShortOpenHashMap.this.n]);
            }
            int pos = Double2ShortOpenHashMap.this.n;
            while (pos-- != 0) {
                double k = key[pos];
                if (Double.doubleToRawLongBits(k) == 0L) continue;
                consumer.accept(k);
            }
        }

        @Override
        public int size() {
            return Double2ShortOpenHashMap.this.size;
        }

        @Override
        public boolean contains(double k) {
            return Double2ShortOpenHashMap.this.containsKey(k);
        }

        @Override
        public boolean remove(double k) {
            int oldSize = Double2ShortOpenHashMap.this.size;
            Double2ShortOpenHashMap.this.remove(k);
            return Double2ShortOpenHashMap.this.size != oldSize;
        }

        @Override
        public void clear() {
            Double2ShortOpenHashMap.this.clear();
        }
    }

    private final class EntryIterator
    extends MapIterator<Consumer<? super Double2ShortMap.Entry>>
    implements ObjectIterator<Double2ShortMap.Entry> {
        private MapEntry entry;

        private EntryIterator() {
        }

        @Override
        public MapEntry next() {
            this.entry = new MapEntry(this.nextEntry());
            return this.entry;
        }

        @Override
        final void acceptOnIndex(Consumer<? super Double2ShortMap.Entry> action, int index) {
            this.entry = new MapEntry(index);
            action.accept(this.entry);
        }

        @Override
        public void remove() {
            super.remove();
            this.entry.index = -1;
        }
    }

    private final class ValueSpliterator
    extends MapSpliterator<ShortConsumer, ValueSpliterator>
    implements ShortSpliterator {
        private static final int POST_SPLIT_CHARACTERISTICS = 256;

        ValueSpliterator() {
        }

        ValueSpliterator(int pos, int max, boolean mustReturnNull, boolean hasSplit) {
            super(pos, max, mustReturnNull, hasSplit);
        }

        @Override
        public int characteristics() {
            return this.hasSplit ? 256 : 320;
        }

        @Override
        final void acceptOnIndex(ShortConsumer action, int index) {
            action.accept(Double2ShortOpenHashMap.this.value[index]);
        }

        @Override
        final ValueSpliterator makeForSplit(int pos, int max, boolean mustReturnNull) {
            return new ValueSpliterator(pos, max, mustReturnNull, true);
        }
    }

    private final class ValueIterator
    extends MapIterator<ShortConsumer>
    implements ShortIterator {
        @Override
        final void acceptOnIndex(ShortConsumer action, int index) {
            action.accept(Double2ShortOpenHashMap.this.value[index]);
        }

        @Override
        public short nextShort() {
            return Double2ShortOpenHashMap.this.value[this.nextEntry()];
        }
    }

    private final class KeySpliterator
    extends MapSpliterator<DoubleConsumer, KeySpliterator>
    implements DoubleSpliterator {
        private static final int POST_SPLIT_CHARACTERISTICS = 257;

        KeySpliterator() {
        }

        KeySpliterator(int pos, int max, boolean mustReturnNull, boolean hasSplit) {
            super(pos, max, mustReturnNull, hasSplit);
        }

        @Override
        public int characteristics() {
            return this.hasSplit ? 257 : 321;
        }

        @Override
        final void acceptOnIndex(DoubleConsumer action, int index) {
            action.accept(Double2ShortOpenHashMap.this.key[index]);
        }

        @Override
        final KeySpliterator makeForSplit(int pos, int max, boolean mustReturnNull) {
            return new KeySpliterator(pos, max, mustReturnNull, true);
        }
    }

    private final class KeyIterator
    extends MapIterator<DoubleConsumer>
    implements DoubleIterator {
        @Override
        final void acceptOnIndex(DoubleConsumer action, int index) {
            action.accept(Double2ShortOpenHashMap.this.key[index]);
        }

        @Override
        public double nextDouble() {
            return Double2ShortOpenHashMap.this.key[this.nextEntry()];
        }
    }

    private final class EntrySpliterator
    extends MapSpliterator<Consumer<? super Double2ShortMap.Entry>, EntrySpliterator>
    implements ObjectSpliterator<Double2ShortMap.Entry> {
        private static final int POST_SPLIT_CHARACTERISTICS = 1;

        EntrySpliterator() {
        }

        EntrySpliterator(int pos, int max, boolean mustReturnNull, boolean hasSplit) {
            super(pos, max, mustReturnNull, hasSplit);
        }

        @Override
        public int characteristics() {
            return this.hasSplit ? 1 : 65;
        }

        @Override
        final void acceptOnIndex(Consumer<? super Double2ShortMap.Entry> action, int index) {
            action.accept(new MapEntry(index));
        }

        @Override
        final EntrySpliterator makeForSplit(int pos, int max, boolean mustReturnNull) {
            return new EntrySpliterator(pos, max, mustReturnNull, true);
        }
    }

    private abstract class MapSpliterator<ConsumerType, SplitType extends MapSpliterator<ConsumerType, SplitType>> {
        int pos = 0;
        int max;
        int c;
        boolean mustReturnNull;
        boolean hasSplit;

        MapSpliterator() {
            this.max = Double2ShortOpenHashMap.this.n;
            this.c = 0;
            this.mustReturnNull = Double2ShortOpenHashMap.this.containsNullKey;
            this.hasSplit = false;
        }

        MapSpliterator(int pos, int max, boolean mustReturnNull, boolean hasSplit) {
            this.max = Double2ShortOpenHashMap.this.n;
            this.c = 0;
            this.mustReturnNull = Double2ShortOpenHashMap.this.containsNullKey;
            this.hasSplit = false;
            this.pos = pos;
            this.max = max;
            this.mustReturnNull = mustReturnNull;
            this.hasSplit = hasSplit;
        }

        abstract void acceptOnIndex(ConsumerType var1, int var2);

        abstract SplitType makeForSplit(int var1, int var2, boolean var3);

        public boolean tryAdvance(ConsumerType action) {
            if (this.mustReturnNull) {
                this.mustReturnNull = false;
                ++this.c;
                this.acceptOnIndex(action, Double2ShortOpenHashMap.this.n);
                return true;
            }
            double[] key = Double2ShortOpenHashMap.this.key;
            while (this.pos < this.max) {
                if (Double.doubleToRawLongBits(key[this.pos]) != 0L) {
                    ++this.c;
                    this.acceptOnIndex(action, this.pos++);
                    return true;
                }
                ++this.pos;
            }
            return false;
        }

        public void forEachRemaining(ConsumerType action) {
            if (this.mustReturnNull) {
                this.mustReturnNull = false;
                ++this.c;
                this.acceptOnIndex(action, Double2ShortOpenHashMap.this.n);
            }
            double[] key = Double2ShortOpenHashMap.this.key;
            while (this.pos < this.max) {
                if (Double.doubleToRawLongBits(key[this.pos]) != 0L) {
                    this.acceptOnIndex(action, this.pos);
                    ++this.c;
                }
                ++this.pos;
            }
        }

        public long estimateSize() {
            if (!this.hasSplit) {
                return Double2ShortOpenHashMap.this.size - this.c;
            }
            return Math.min((long)(Double2ShortOpenHashMap.this.size - this.c), (long)((double)Double2ShortOpenHashMap.this.realSize() / (double)Double2ShortOpenHashMap.this.n * (double)(this.max - this.pos)) + (long)(this.mustReturnNull ? 1 : 0));
        }

        public SplitType trySplit() {
            if (this.pos >= this.max - 1) {
                return null;
            }
            int retLen = this.max - this.pos >> 1;
            if (retLen <= 1) {
                return null;
            }
            int myNewPos = this.pos + retLen;
            int retPos = this.pos;
            int retMax = myNewPos;
            SplitType split = this.makeForSplit(retPos, retMax, this.mustReturnNull);
            this.pos = myNewPos;
            this.mustReturnNull = false;
            this.hasSplit = true;
            return split;
        }

        public long skip(long n) {
            if (n < 0L) {
                throw new IllegalArgumentException("Argument must be nonnegative: " + n);
            }
            if (n == 0L) {
                return 0L;
            }
            long skipped = 0L;
            if (this.mustReturnNull) {
                this.mustReturnNull = false;
                ++skipped;
                --n;
            }
            double[] key = Double2ShortOpenHashMap.this.key;
            while (this.pos < this.max && n > 0L) {
                if (Double.doubleToRawLongBits(key[this.pos++]) == 0L) continue;
                ++skipped;
                --n;
            }
            return skipped;
        }
    }

    private final class FastEntryIterator
    extends MapIterator<Consumer<? super Double2ShortMap.Entry>>
    implements ObjectIterator<Double2ShortMap.Entry> {
        private final MapEntry entry;

        private FastEntryIterator() {
            this.entry = new MapEntry();
        }

        @Override
        public MapEntry next() {
            this.entry.index = this.nextEntry();
            return this.entry;
        }

        @Override
        final void acceptOnIndex(Consumer<? super Double2ShortMap.Entry> action, int index) {
            this.entry.index = index;
            action.accept(this.entry);
        }
    }

    private abstract class MapIterator<ConsumerType> {
        int pos;
        int last;
        int c;
        boolean mustReturnNullKey;
        DoubleArrayList wrapped;

        private MapIterator() {
            this.pos = Double2ShortOpenHashMap.this.n;
            this.last = -1;
            this.c = Double2ShortOpenHashMap.this.size;
            this.mustReturnNullKey = Double2ShortOpenHashMap.this.containsNullKey;
        }

        abstract void acceptOnIndex(ConsumerType var1, int var2);

        public boolean hasNext() {
            return this.c != 0;
        }

        public int nextEntry() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            --this.c;
            if (this.mustReturnNullKey) {
                this.mustReturnNullKey = false;
                this.last = Double2ShortOpenHashMap.this.n;
                return this.last;
            }
            double[] key = Double2ShortOpenHashMap.this.key;
            do {
                if (--this.pos >= 0) continue;
                this.last = Integer.MIN_VALUE;
                double k = this.wrapped.getDouble(-this.pos - 1);
                int p = (int)HashCommon.mix(Double.doubleToRawLongBits(k)) & Double2ShortOpenHashMap.this.mask;
                while (Double.doubleToRawLongBits(k) != Double.doubleToRawLongBits(key[p])) {
                    p = p + 1 & Double2ShortOpenHashMap.this.mask;
                }
                return p;
            } while (Double.doubleToRawLongBits(key[this.pos]) == 0L);
            this.last = this.pos;
            return this.last;
        }

        public void forEachRemaining(ConsumerType action) {
            if (this.mustReturnNullKey) {
                this.mustReturnNullKey = false;
                this.last = Double2ShortOpenHashMap.this.n;
                this.acceptOnIndex(action, this.last);
                --this.c;
            }
            double[] key = Double2ShortOpenHashMap.this.key;
            while (this.c != 0) {
                if (--this.pos < 0) {
                    this.last = Integer.MIN_VALUE;
                    double k = this.wrapped.getDouble(-this.pos - 1);
                    int p = (int)HashCommon.mix(Double.doubleToRawLongBits(k)) & Double2ShortOpenHashMap.this.mask;
                    while (Double.doubleToRawLongBits(k) != Double.doubleToRawLongBits(key[p])) {
                        p = p + 1 & Double2ShortOpenHashMap.this.mask;
                    }
                    this.acceptOnIndex(action, p);
                    --this.c;
                    continue;
                }
                if (Double.doubleToRawLongBits(key[this.pos]) == 0L) continue;
                this.last = this.pos;
                this.acceptOnIndex(action, this.last);
                --this.c;
            }
        }

        private void shiftKeys(int pos) {
            double[] key = Double2ShortOpenHashMap.this.key;
            short[] value = Double2ShortOpenHashMap.this.value;
            while (true) {
                double curr;
                int last = pos;
                pos = last + 1 & Double2ShortOpenHashMap.this.mask;
                while (true) {
                    if (Double.doubleToRawLongBits(curr = key[pos]) == 0L) {
                        key[last] = 0.0;
                        return;
                    }
                    int slot = (int)HashCommon.mix(Double.doubleToRawLongBits(curr)) & Double2ShortOpenHashMap.this.mask;
                    if (last <= pos ? last >= slot || slot > pos : last >= slot && slot > pos) break;
                    pos = pos + 1 & Double2ShortOpenHashMap.this.mask;
                }
                if (pos < last) {
                    if (this.wrapped == null) {
                        this.wrapped = new DoubleArrayList(2);
                    }
                    this.wrapped.add(key[pos]);
                }
                key[last] = curr;
                value[last] = value[pos];
            }
        }

        public void remove() {
            if (this.last == -1) {
                throw new IllegalStateException();
            }
            if (this.last == Double2ShortOpenHashMap.this.n) {
                Double2ShortOpenHashMap.this.containsNullKey = false;
            } else if (this.pos >= 0) {
                this.shiftKeys(this.last);
            } else {
                Double2ShortOpenHashMap.this.remove(this.wrapped.getDouble(-this.pos - 1));
                this.last = -1;
                return;
            }
            --Double2ShortOpenHashMap.this.size;
            this.last = -1;
        }

        public int skip(int n) {
            int i = n;
            while (i-- != 0 && this.hasNext()) {
                this.nextEntry();
            }
            return n - i - 1;
        }
    }

    final class MapEntry
    implements Double2ShortMap.Entry,
    Map.Entry<Double, Short>,
    DoubleShortPair {
        int index;

        MapEntry(int index) {
            this.index = index;
        }

        MapEntry() {
        }

        @Override
        public double getDoubleKey() {
            return Double2ShortOpenHashMap.this.key[this.index];
        }

        @Override
        public double leftDouble() {
            return Double2ShortOpenHashMap.this.key[this.index];
        }

        @Override
        public short getShortValue() {
            return Double2ShortOpenHashMap.this.value[this.index];
        }

        @Override
        public short rightShort() {
            return Double2ShortOpenHashMap.this.value[this.index];
        }

        @Override
        public short setValue(short v) {
            short oldValue = Double2ShortOpenHashMap.this.value[this.index];
            Double2ShortOpenHashMap.this.value[this.index] = v;
            return oldValue;
        }

        @Override
        public DoubleShortPair right(short v) {
            Double2ShortOpenHashMap.this.value[this.index] = v;
            return this;
        }

        @Override
        @Deprecated
        public Double getKey() {
            return Double2ShortOpenHashMap.this.key[this.index];
        }

        @Override
        @Deprecated
        public Short getValue() {
            return Double2ShortOpenHashMap.this.value[this.index];
        }

        @Override
        @Deprecated
        public Short setValue(Short v) {
            return this.setValue((short)v);
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return Double.doubleToRawLongBits(Double2ShortOpenHashMap.this.key[this.index]) == Double.doubleToRawLongBits((Double)e.getKey()) && Double2ShortOpenHashMap.this.value[this.index] == (Short)e.getValue();
        }

        @Override
        public int hashCode() {
            return HashCommon.double2int(Double2ShortOpenHashMap.this.key[this.index]) ^ Double2ShortOpenHashMap.this.value[this.index];
        }

        public String toString() {
            return Double2ShortOpenHashMap.this.key[this.index] + "=>" + Double2ShortOpenHashMap.this.value[this.index];
        }
    }
}

