/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.objects;

import it.unimi.dsi.fastutil.booleans.BooleanCollection;
import it.unimi.dsi.fastutil.objects.AbstractReference2BooleanMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.objects.Reference2BooleanArrayMap;
import it.unimi.dsi.fastutil.objects.Reference2BooleanFunction;
import it.unimi.dsi.fastutil.objects.Reference2BooleanMaps;
import it.unimi.dsi.fastutil.objects.Reference2BooleanOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceSet;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;

public interface Reference2BooleanMap<K>
extends Reference2BooleanFunction<K>,
Map<K, Boolean> {
    @Override
    public int size();

    @Override
    default public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void defaultReturnValue(boolean var1);

    @Override
    public boolean defaultReturnValue();

    public ObjectSet<Entry<K>> reference2BooleanEntrySet();

    @Override
    @Deprecated
    default public ObjectSet<Map.Entry<K, Boolean>> entrySet() {
        return this.reference2BooleanEntrySet();
    }

    @Override
    @Deprecated
    default public Boolean put(K key, Boolean value) {
        return Reference2BooleanFunction.super.put(key, value);
    }

    @Override
    @Deprecated
    default public Boolean get(Object key) {
        return Reference2BooleanFunction.super.get(key);
    }

    @Override
    @Deprecated
    default public Boolean remove(Object key) {
        return Reference2BooleanFunction.super.remove(key);
    }

    @Override
    public ReferenceSet<K> keySet();

    public BooleanCollection values();

    @Override
    public boolean containsKey(Object var1);

    public boolean containsValue(boolean var1);

    @Override
    @Deprecated
    default public boolean containsValue(Object value) {
        return value == null ? false : this.containsValue((Boolean)value);
    }

    default public void forEach(EntryConsumer<K> consumer) {
        ObjectSet<Entry<K>> entrySet = this.reference2BooleanEntrySet();
        Consumer<Entry> wrappingConsumer = entry -> consumer.accept((Object)entry.getKey(), entry.getBooleanValue());
        if (entrySet instanceof FastEntrySet) {
            ((FastEntrySet)entrySet).fastForEach(wrappingConsumer);
        } else {
            entrySet.forEach(wrappingConsumer);
        }
    }

    @Override
    @Deprecated
    default public void forEach(BiConsumer<? super K, ? super Boolean> action) {
        Map.super.forEach(action);
    }

    @Override
    default public boolean getOrDefault(Object key, boolean defaultValue) {
        boolean v = this.getBoolean(key);
        return v != this.defaultReturnValue() || this.containsKey(key) ? v : defaultValue;
    }

    @Override
    @Deprecated
    default public Boolean getOrDefault(Object key, Boolean defaultValue) {
        return Map.super.getOrDefault(key, defaultValue);
    }

    @Override
    default public boolean putIfAbsent(K key, boolean value) {
        boolean drv;
        boolean v = this.getBoolean(key);
        if (v != (drv = this.defaultReturnValue()) || this.containsKey(key)) {
            return v;
        }
        this.put(key, value);
        return drv;
    }

    default public boolean remove(Object key, boolean value) {
        boolean curValue = this.getBoolean(key);
        if (curValue != value || curValue == this.defaultReturnValue() && !this.containsKey(key)) {
            return false;
        }
        this.removeBoolean(key);
        return true;
    }

    @Override
    default public boolean replace(K key, boolean oldValue, boolean newValue) {
        boolean curValue = this.getBoolean(key);
        if (curValue != oldValue || curValue == this.defaultReturnValue() && !this.containsKey(key)) {
            return false;
        }
        this.put(key, newValue);
        return true;
    }

    @Override
    default public boolean replace(K key, boolean value) {
        return this.containsKey(key) ? this.put(key, value) : this.defaultReturnValue();
    }

    default public boolean computeIfAbsent(K key, Predicate<? super K> mappingFunction) {
        Objects.requireNonNull(mappingFunction);
        boolean v = this.getBoolean(key);
        if (v != this.defaultReturnValue() || this.containsKey(key)) {
            return v;
        }
        boolean newValue = mappingFunction.test(key);
        this.put(key, newValue);
        return newValue;
    }

    @Deprecated
    default public boolean computeBooleanIfAbsent(K key, Predicate<? super K> mappingFunction) {
        return this.computeIfAbsent(key, mappingFunction);
    }

    default public boolean computeIfAbsent(K key, Reference2BooleanFunction<? super K> mappingFunction) {
        Objects.requireNonNull(mappingFunction);
        boolean v = this.getBoolean(key);
        boolean drv = this.defaultReturnValue();
        if (v != drv || this.containsKey(key)) {
            return v;
        }
        if (!mappingFunction.containsKey(key)) {
            return drv;
        }
        boolean newValue = mappingFunction.getBoolean(key);
        this.put(key, newValue);
        return newValue;
    }

    @Deprecated
    default public boolean computeBooleanIfAbsentPartial(K key, Reference2BooleanFunction<? super K> mappingFunction) {
        return this.computeIfAbsent(key, mappingFunction);
    }

    default public boolean computeBooleanIfPresent(K key, BiFunction<? super K, ? super Boolean, ? extends Boolean> remappingFunction) {
        Objects.requireNonNull(remappingFunction);
        boolean oldValue = this.getBoolean(key);
        boolean drv = this.defaultReturnValue();
        if (oldValue == drv && !this.containsKey(key)) {
            return drv;
        }
        Boolean newValue = remappingFunction.apply(key, oldValue);
        if (newValue == null) {
            this.removeBoolean(key);
            return drv;
        }
        boolean newVal = newValue;
        this.put(key, newVal);
        return newVal;
    }

    default public boolean computeBoolean(K key, BiFunction<? super K, ? super Boolean, ? extends Boolean> remappingFunction) {
        Objects.requireNonNull(remappingFunction);
        boolean oldValue = this.getBoolean(key);
        boolean drv = this.defaultReturnValue();
        boolean contained = oldValue != drv || this.containsKey(key);
        Boolean newValue = remappingFunction.apply(key, contained ? Boolean.valueOf(oldValue) : null);
        if (newValue == null) {
            if (contained) {
                this.removeBoolean(key);
            }
            return drv;
        }
        boolean newVal = newValue;
        this.put(key, newVal);
        return newVal;
    }

    @Override
    default public boolean merge(K key, boolean value, BiFunction<? super Boolean, ? super Boolean, ? extends Boolean> remappingFunction) {
        boolean newValue;
        Objects.requireNonNull(remappingFunction);
        boolean oldValue = this.getBoolean(key);
        boolean drv = this.defaultReturnValue();
        if (oldValue != drv || this.containsKey(key)) {
            Boolean mergedValue = remappingFunction.apply((Boolean)oldValue, (Boolean)value);
            if (mergedValue == null) {
                this.removeBoolean(key);
                return drv;
            }
            newValue = mergedValue;
        } else {
            newValue = value;
        }
        this.put(key, newValue);
        return newValue;
    }

    @SafeVarargs
    public static <K> Reference2BooleanMap<K> ofEntries(Entry<K> ... entries) {
        if (entries.length == 0) {
            return Reference2BooleanMaps.EMPTY_MAP;
        }
        if (entries.length == 1) {
            return Reference2BooleanMaps.singleton(entries[0].getKey(), entries[0].getBooleanValue());
        }
        if (entries.length <= 8) {
            Object[] keys = new Object[entries.length];
            boolean[] vals = new boolean[entries.length];
            for (int i = 0; i < entries.length; ++i) {
                Entry<K> entry = entries[i];
                keys[i] = entry.getKey();
                for (int j = 0; j < i; ++j) {
                    if (keys[j] != keys[i]) continue;
                    throw new IllegalArgumentException("duplicate key: " + keys[i]);
                }
                vals[i] = entry.getBooleanValue();
            }
            return Reference2BooleanMaps.unmodifiable(new Reference2BooleanArrayMap(keys, vals, entries.length));
        }
        Reference2BooleanOpenHashMap newMap = new Reference2BooleanOpenHashMap(entries.length, 0.75f);
        for (Entry<K> entry : entries) {
            if (!newMap.put(entry.getKey(), entry.getBooleanValue())) continue;
            throw new IllegalArgumentException("duplicate key: " + entry.getKey());
        }
        return Reference2BooleanMaps.unmodifiable(newMap);
    }

    public static <K> Entry<K> entry(K key, boolean value) {
        return new AbstractReference2BooleanMap.BasicEntry<K>(key, value);
    }

    public static interface EntryConsumer<K>
    extends BiConsumer<K, Boolean> {
        @Override
        public void accept(K var1, boolean var2);

        @Override
        @Deprecated
        default public void accept(K key, Boolean value) {
            this.accept(key, (boolean)value);
        }

        default public EntryConsumer<K> andThen(EntryConsumer<K> after) {
            Objects.requireNonNull(after);
            return (k, v) -> {
                this.accept((K)k, v);
                after.accept((K)k, v);
            };
        }

        @Override
        @Deprecated
        default public BiConsumer<K, Boolean> andThen(BiConsumer<? super K, ? super Boolean> after) {
            return BiConsumer.super.andThen(after);
        }
    }

    public static interface FastEntrySet<K>
    extends ObjectSet<Entry<K>> {
        public ObjectIterator<Entry<K>> fastIterator();

        default public void fastForEach(Consumer<? super Entry<K>> consumer) {
            this.forEach(consumer);
        }
    }

    public static interface Entry<K>
    extends Map.Entry<K, Boolean> {
        public boolean getBooleanValue();

        @Override
        public boolean setValue(boolean var1);

        @Override
        @Deprecated
        default public Boolean getValue() {
            return this.getBooleanValue();
        }

        @Override
        @Deprecated
        default public Boolean setValue(Boolean value) {
            return this.setValue((boolean)value);
        }
    }
}

