package it.unimi.dsi.mg4j.index.cluster;

/*		 
 * MG4J: Managing Gigabytes for Java
 *
 * Copyright (C) 2006-2011 Sebastiano Vigna 
 *
 *  This library is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU Lesser General Public License as published by the Free
 *  Software Foundation; either version 3 of the License, or (at your option)
 *  any later version.
 *
 *  This library is distributed in the hope that it will be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
 *  for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
 */

/** Static utility methods for documental strategies.
 * 
 * @author Alessandro Arabito
 * @author Sebastiano Vigna
 */

public class DocumentalStrategies {
	
	protected DocumentalStrategies() {}
	
	/** Creates an equally spaced {@linkplain ContiguousDocumentalStrategy contiguous documental strategy}.
	 * 
	 * @param numberOfLocalIndices the number of local indices.
	 * @param numberOfDocuments the global number of documents.
	 * @return a {@link ContiguousDocumentalStrategy} that will partition in <code>index</code> in
	 * <code>numberOfLocalIndices</code> local indices of approximately equal size.
	 */
	public static ContiguousDocumentalStrategy uniform( final int numberOfLocalIndices, final int numberOfDocuments ) {
		if ( numberOfLocalIndices > numberOfDocuments )
			throw new IllegalArgumentException( "The number of local indices (" + numberOfLocalIndices + ") is larger than the number of documents (" + numberOfDocuments + ")" );
		final int intervalSize = numberOfDocuments / numberOfLocalIndices;
		final int[] cutPoint = new int[ numberOfLocalIndices + 1 ];
		cutPoint[ numberOfLocalIndices ] = numberOfDocuments;
		for ( int i = 1; i < numberOfLocalIndices; i++ )
			cutPoint[ i ] = intervalSize * i;
		return new ContiguousDocumentalStrategy( cutPoint );
	}
}
