package it.unimi.dsi.mg4j.index.remote;

/*		 
 * MG4J: Managing Gigabytes for Java
 *
 * Copyright (C) 2006-2011 Sebastiano Vigna 
 *
 *  This library is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU Lesser General Public License as published by the Free
 *  Software Foundation; either version 3 of the License, or (at your option)
 *  any later version.
 *
 *  This library is distributed in the hope that it will be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
 *  for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
 */

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;

/** A abstract class representing a thread that provides services inside an {@linkplain it.unimi.dsi.mg4j.index.remote.IndexServer index server}.
 * 
 * <P>Implementing subclasses must just implement the {@link #run()} method,
 * using the predefined {@linkplain #inputStream socket input stream} and {@linkplain #outputStream socket output stream}.
 *
 * @author Sebastiano Vigna
 */
public abstract class ServerThread implements Runnable {
	/** The socket associated with this server thread.*/
	protected final Socket socket;
	/** The input stream of {@link #socket}, buffered and wrapped inside a data input stream. */
	protected final DataInputStream inputStream;
	/** The output stream of {@link #socket}, buffered and wrapped inside a data output stream. */
	protected final DataOutputStream outputStream;	

	/** Creates a new server thread.
	 * @param socket a socket in listening mode that handles client connections.
	 */
	public ServerThread( final Socket socket ) throws IOException {
		this.socket = socket;
		inputStream = new DataInputStream( new BufferedInputStream( socket.getInputStream() ) );
		outputStream = new DataOutputStream( new BufferedOutputStream( socket.getOutputStream() ) );
	}
}
