package it.unimi.dsi.mg4j.search;

/*		 
 * MG4J: Managing Gigabytes for Java
 *
 * Copyright (C) 2003-2011 Paolo Boldi and Sebastiano Vigna 
 *
 *  This library is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU Lesser General Public License as published by the Free
 *  Software Foundation; either version 3 of the License, or (at your option)
 *  any later version.
 *
 *  This library is distributed in the hope that it will be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
 *  for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
 */

import it.unimi.dsi.fastutil.objects.Reference2ReferenceMap;
import it.unimi.dsi.fastutil.objects.ReferenceSet;
import it.unimi.dsi.fastutil.objects.ReferenceSets;
import it.unimi.dsi.mg4j.index.Index;
import it.unimi.dsi.mg4j.search.visitor.DocumentIteratorVisitor;

/** An empty document iterator. */

public class FalseDocumentIterator extends AbstractDocumentIterator {
	final ReferenceSet<Index> indices;
	
	protected FalseDocumentIterator( final Index index ) {
		indices = ReferenceSets.singleton( index );
	}

	/** Creates a false document iterator with given index.
	 * 
	 * @param index the index of this iterator.
	 * @return a false document iterator with given index.
	 */
	public static FalseDocumentIterator getInstance( final Index index ) {
		return new FalseDocumentIterator( index );
	}
	
	public IntervalIterator intervalIterator() {
		throw new IllegalStateException();
	}

	public IntervalIterator intervalIterator( Index index ) {
		throw new IllegalStateException();
	}

	public Reference2ReferenceMap<Index, IntervalIterator> intervalIterators() {
		throw new IllegalStateException();
	}

	public ReferenceSet<Index> indices() {
		return indices;
	}

	protected int nextDocumentInternal() {
		throw new IllegalStateException();
	}
	
	@Override
	public int nextDocument() {
		return -1;
	}

	public int skipTo( int n ) {
		return Integer.MAX_VALUE;
	}

	public <T> T accept( DocumentIteratorVisitor<T> visitor ) {
		if ( !visitor.visitPre( this ) ) return null;
		return visitor.visitPost( this, null );
	}

	public <T> T acceptOnTruePaths( DocumentIteratorVisitor<T> visitor ) {
		throw new IllegalStateException();
	}

	public void dispose() {}
}
