package it.unimi.dsi.mg4j.search.score;

/*		 
 * MG4J: Managing Gigabytes for Java
 *
 * Copyright (C) 2004-2011 Paolo Boldi
 *
 *  This library is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU Lesser General Public License as published by the Free
 *  Software Foundation; either version 3 of the License, or (at your option)
 *  any later version.
 *
 *  This library is distributed in the hope that it will be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *  or FITfNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
 *  for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
 */

import it.unimi.dsi.fastutil.io.BinIO;
import it.unimi.dsi.mg4j.index.Index;

import java.io.IOException;

/** Compute scores that do not depend on intervals, but that
 *  just assign a fixed score to each document; scores are read
 *  from a file whose name is passed to the constructor.
 */
public class DocumentRankScorer extends AbstractScorer implements DelegatingScorer {
	/** The array of scores. */
	private double[] score;
	
	/** Builds a document scorer by first reading the ranks from a file.
	 *  Ranks are saved as doubles (the first double is the rank of document 0
	 *  and so on).
	 * 
	 *  @param filename the name of the rank file.
	 */
	public DocumentRankScorer( final String filename ) throws IOException {
		this( BinIO.loadDoubles( filename ) );
	}

	/** Builds a document scorer with given scores.
	 * 
	 *  @param score the scores (they are not copied, so the caller is supposed
	 *   not to change their values).
	 */
	public DocumentRankScorer( final double[] score ) {
		this.score = score;
	}
	
	public DocumentRankScorer copy() {
		return new DocumentRankScorer( score );
	}

	public double score() {
		return score[ documentIterator.document() ];
	}

	public double score( final Index index ) {
		throw new UnsupportedOperationException();
	}

	public String toString() {
		return "DocumentRank";
	}

	public boolean usesIntervals() {
		return false;
	}
}
