package it.unimi.dsi.mg4j.index.snowball;

import static org.junit.Assert.*;

import org.junit.Test;

import it.unimi.dsi.lang.MutableString;

public class PorterStemmerTest {
	
	@Test
	public void testShort() {
		PorterStemmer stemmer = new PorterStemmer();
		
		MutableString s = new MutableString();
		s.append( 's' );
		stemmer.processTerm( s );
		assertEquals( "s", s.toString() );

		s.append( 's' );
		stemmer.processTerm( s );
		assertEquals( "ss", s.toString() );

	
		s.length( 0 );

		s.append( 'S' );
		stemmer.processTerm( s );
		assertEquals( "s", s.toString() );

		s.append( 's' );
		stemmer.processTerm( s );
		assertEquals( "ss", s.toString() );

	}
}
