package it.unimi.dsi.mg4j.mock.search;

/*		 
 * MG4J: Managing Gigabytes for Java
 *
 * Copyright (C) 2003-2011 Paolo Boldi and Sebastiano Vigna 
 *
 *  This library is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU Lesser General Public License as published by the Free
 *  Software Foundation; either version 3 of the License, or (at your option)
 *  any later version.
 *
 *  This library is distributed in the hope that it will be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
 *  for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
 */

import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.mg4j.index.Index;
import it.unimi.dsi.mg4j.search.DocumentIterator;

import java.io.IOException;



public class NotDocumentIterator extends MockDocumentIterator {


	private final DocumentIterator documentIterator;
	private final int numberOfDocuments;

	/** Creates a NOT document iterator over a given iterator.
	 *
	 * @param documentIterator the iterator to be filtered.
	 * @param numberOfDocuments the number of documents.
	 */
	protected NotDocumentIterator( final DocumentIterator documentIterator, final int numberOfDocuments ) {
		this.documentIterator = documentIterator;
		this.numberOfDocuments = numberOfDocuments;
		indices.addAll( documentIterator.indices() );
		try {
			IntSet inside = new IntOpenHashSet();
			while ( documentIterator.hasNext() )
				inside.add( documentIterator.nextDocument() );
			for ( int i = 0; i < numberOfDocuments; i++ )
				if ( ! inside.contains( i ) )
					for ( Index index: indices )						
						addTrueIteratorDocument( i, index );

			documentIterator.dispose();
			start( true );
		}
		catch ( IOException e ) {
			throw new RuntimeException( e );
		}
		
	}

	/** Returns a NOT document iterator over a given iterator.
	 * @param it the iterator to be filtered.
	 * @param numberOfDocuments the number of documents in the collection.
	 */
	public static DocumentIterator getInstance( final DocumentIterator it, final int numberOfDocuments ) {
		return new NotDocumentIterator( it, numberOfDocuments );
	}

	public String toString() {
	   return this.getClass().getSimpleName() + "(" + documentIterator + ", " + numberOfDocuments + ")";
	}
	
}
