package it.unimi.dsi.mg4j.search;

import static org.junit.Assert.*;

import java.io.IOException;

import org.junit.Test;

public class AndDocumentIteratorTest {

	@Test
	public void testExtentDocumentIterator() throws IOException {
		IntArrayDocumentIterator i0 = new IntArrayDocumentIterator( new int[] { 0, 1, 2 }, 
				new int[][][] { 
				{ { 0, 1 }, { 1, 2 } }, 
				{ { 0, 1 }, { 1, 2 } }, 
				{ { 1 }, { 2 } }, 
				} );
		IntArrayDocumentIterator i1 = new IntArrayDocumentIterator( new int[] { 0, 1, 2 }, 
				new int[][][] { 
				{ { 5, 7 } }, 
				{ {} }, 
				{ { 2 }, { 3 }, { 4 } }, 
				} );
		
		DocumentIterator andDocumentIterator = AndDocumentIterator.getInstance( i0, i1 );
		assertEquals( 0, andDocumentIterator.nextDocument() );
		assertEquals( 5, andDocumentIterator.intervalIterator().extent() );
		assertEquals( 1, andDocumentIterator.nextDocument() );
		assertEquals( 2, andDocumentIterator.intervalIterator().extent() );
		assertEquals( 2, andDocumentIterator.nextDocument() );
		assertEquals( 2, andDocumentIterator.intervalIterator().extent() );
	}

}
