package it.unimi.dsi.mg4j.search;

import static org.junit.Assert.*;
import it.unimi.dsi.mg4j.document.StringArrayDocumentCollection;
import it.unimi.dsi.mg4j.index.BitStreamIndex;
import it.unimi.dsi.mg4j.index.DiskBasedIndex;
import it.unimi.dsi.mg4j.tool.IndexBuilder;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;

import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.io.filefilter.PrefixFileFilter;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class TrueFalseDocumentIteratorTest {
	private static BitStreamIndex index;
	private static String basename;

	@BeforeClass
	public static void setUp() throws ConfigurationException, SecurityException, IOException, URISyntaxException, ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
		basename = File.createTempFile( TrueFalseDocumentIteratorTest.class.getSimpleName(), "test" ).getCanonicalPath();
		new IndexBuilder( basename, new StringArrayDocumentCollection( "a", "b", "c" ) ).run();
		index = DiskBasedIndex.getInstance( basename + "-text", true, true );
	}

	@AfterClass
	public static void tearDown() {
		for( File f: new File( basename ).getParentFile().listFiles( (FileFilter)new PrefixFileFilter( new File( basename ).getName() ) ) )	f.delete();
	}
	
	@SuppressWarnings("deprecation")
	@Test
	public void testTrue() throws IOException {
		TrueDocumentIterator trueDocumentIterator = TrueDocumentIterator.getInstance( index );
		assertEquals( 0, trueDocumentIterator.nextDocument() );
		assertEquals( IntervalIterators.TRUE, trueDocumentIterator.intervalIterator() );
		assertEquals( 1, trueDocumentIterator.nextDocument() );
		assertEquals( IntervalIterators.TRUE, trueDocumentIterator.intervalIterator() );
		assertEquals( 2, trueDocumentIterator.nextDocument() );
		assertEquals( IntervalIterators.TRUE, trueDocumentIterator.intervalIterator() );
		assertEquals( -1, trueDocumentIterator.nextDocument() );

		trueDocumentIterator = TrueDocumentIterator.getInstance( index );
		assertTrue( trueDocumentIterator.hasNext() );
		assertEquals( 0, trueDocumentIterator.nextInt() );
		assertEquals( IntervalIterators.TRUE, trueDocumentIterator.intervalIterator() );
		assertTrue( trueDocumentIterator.hasNext() );
		assertEquals( 1, trueDocumentIterator.nextInt() );
		assertEquals( IntervalIterators.TRUE, trueDocumentIterator.intervalIterator() );
		assertTrue( trueDocumentIterator.hasNext() );
		assertEquals( 2, trueDocumentIterator.nextInt() );
		assertEquals( IntervalIterators.TRUE, trueDocumentIterator.intervalIterator() );
		assertFalse( trueDocumentIterator.hasNext() );
		assertEquals( -1, trueDocumentIterator.nextDocument() );
	}

	@Test
	public void testFalse() {
		FalseDocumentIterator falseDocumentIterator = FalseDocumentIterator.getInstance( index );
		assertEquals( -1, falseDocumentIterator.nextDocument() );
	}

}
