package it.unimi.dsi.mg4j.tool;

import static org.junit.Assert.*;
import it.unimi.dsi.mg4j.document.StringArrayDocumentCollection;
import it.unimi.dsi.mg4j.index.Index;
import it.unimi.dsi.mg4j.index.IndexIterator;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;

import org.apache.commons.configuration.ConfigurationException;
import org.junit.Test;

public class ScanTest {

	@Test
	public void testEverywhereTerms() throws IOException, ConfigurationException, SecurityException, URISyntaxException, ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
		String basename = File.createTempFile( getClass().getSimpleName(), "everywhereTerms" ).getCanonicalPath();
		new IndexBuilder( basename, new StringArrayDocumentCollection( "a a" ) ).keepBatches( true ).run();
		IndexIterator indexIterator = Index.getInstance( basename + "-text@0" ).documents( 0 );
		indexIterator.next();
		assertEquals( 2, indexIterator.count() );
		int[] position = new int[ 2 ];
		indexIterator.positions( position );
		assertEquals( 0, position[ 0 ] );
		assertEquals( 1, position[ 1 ] );
	} 


}
