/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.document;

import it.unimi.dsi.io.WordReader;
import it.unimi.dsi.mg4j.document.AbstractDocument;
import it.unimi.dsi.mg4j.document.AbstractDocumentSequence;
import it.unimi.dsi.mg4j.document.CompositeDocumentFactory;
import it.unimi.dsi.mg4j.document.Document;
import it.unimi.dsi.mg4j.document.DocumentFactory;
import it.unimi.dsi.mg4j.document.DocumentIterator;
import it.unimi.dsi.mg4j.document.DocumentSequence;
import java.io.IOException;

public class CompositeDocumentSequence
extends AbstractDocumentSequence {
    private final DocumentSequence[] sequence;
    private CompositeDocumentFactory factory;

    public CompositeDocumentSequence(DocumentSequence ... sequence) {
        this(sequence, (String[])null);
    }

    public CompositeDocumentSequence(DocumentSequence[] sequence, String[] fieldName) {
        this.sequence = sequence;
        DocumentFactory[] factory = new DocumentFactory[sequence.length];
        int i = sequence.length;
        while (i-- != 0) {
            factory[i] = sequence[i].factory();
        }
        this.factory = new CompositeDocumentFactory(factory, fieldName);
    }

    @Override
    public void close() throws IOException {
        for (DocumentSequence s : this.sequence) {
            s.close();
        }
        super.close();
    }

    @Override
    public DocumentFactory factory() {
        return this.factory;
    }

    @Override
    public DocumentIterator iterator() throws IOException {
        return new DocumentIterator(){
            final DocumentIterator[] documentIterator;
            final Document[] document;
            {
                this.documentIterator = new DocumentIterator[CompositeDocumentSequence.this.sequence.length];
                this.document = new Document[CompositeDocumentSequence.this.sequence.length];
                for (int i = 0; i < CompositeDocumentSequence.this.sequence.length; ++i) {
                    this.documentIterator[i] = CompositeDocumentSequence.this.sequence[i].iterator();
                }
            }

            @Override
            public void close() throws IOException {
                for (DocumentIterator d : this.documentIterator) {
                    d.close();
                }
            }

            @Override
            public Document nextDocument() throws IOException {
                boolean someNull = false;
                boolean allNull = true;
                for (int i = 0; i < this.documentIterator.length; ++i) {
                    this.document[i] = this.documentIterator[i].nextDocument();
                    someNull |= this.document[i] == null;
                    allNull &= this.document[i] == null;
                }
                if (someNull != allNull) {
                    throw new IllegalArgumentException("The underlying document sequences have different lengths");
                }
                if (allNull) {
                    return null;
                }
                return new AbstractDocument(){

                    @Override
                    public Object content(int field) throws IOException {
                        return document[((CompositeDocumentSequence)CompositeDocumentSequence.this).factory.factoryIndex[field]].content(((CompositeDocumentSequence)CompositeDocumentSequence.this).factory.originalFieldIndex[field]);
                    }

                    @Override
                    public CharSequence title() {
                        return document[0].title();
                    }

                    @Override
                    public CharSequence uri() {
                        return document[0].uri();
                    }

                    @Override
                    public WordReader wordReader(int field) {
                        return document[((CompositeDocumentSequence)CompositeDocumentSequence.this).factory.factoryIndex[field]].wordReader(((CompositeDocumentSequence)CompositeDocumentSequence.this).factory.originalFieldIndex[field]);
                    }

                    @Override
                    public void close() throws IOException {
                        super.close();
                        for (Document d : document) {
                            d.close();
                        }
                    }
                };
            }
        };
    }
}

