/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.document;

import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.mg4j.document.AbstractDocumentCollection;
import it.unimi.dsi.mg4j.document.AbstractDocumentSequence;
import it.unimi.dsi.mg4j.document.Document;
import it.unimi.dsi.mg4j.document.DocumentCollection;
import it.unimi.dsi.mg4j.document.DocumentFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Arrays;

public class ConcatenatedDocumentCollection
extends AbstractDocumentCollection
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String[] collectionName;
    private transient DocumentCollection[] collection;
    private final int n;
    private long[] startDocument;

    protected ConcatenatedDocumentCollection(String[] collectionName, DocumentCollection[] collection) {
        if (collection.length != collectionName.length) {
            throw new IllegalArgumentException();
        }
        this.collectionName = collectionName;
        this.collection = collection;
        this.n = collection.length;
    }

    private void initCollections(CharSequence filename, boolean rethrow) throws IllegalArgumentException, SecurityException, IOException, ClassNotFoundException {
        block6: {
            try {
                this.collection = new DocumentCollection[this.n];
                File parent = filename != null ? new File(((Object)filename).toString()).getParentFile() : null;
                int i = this.n;
                while (i-- != 0) {
                    this.collection[i] = (DocumentCollection)AbstractDocumentSequence.load(new File(parent, this.collectionName[i]).toString());
                }
                if (this.n > 0) {
                    Class<?> factoryClass = this.collection[0].factory().getClass();
                    for (int i2 = 0; i2 < this.n; ++i2) {
                        if (this.collection[i2].factory().getClass() == factoryClass) continue;
                        throw new IllegalArgumentException("All segment in a concatenated document collection must used the same factory class");
                    }
                }
                this.startDocument = new long[this.n + 1];
                for (i = 0; i < this.n; ++i) {
                    this.startDocument[i + 1] = this.startDocument[i] + (long)this.collection[i].size();
                }
            }
            catch (IOException e) {
                if (!rethrow) break block6;
                throw e;
            }
        }
    }

    private void ensureCollections() {
        if (this.collection == null) {
            this.filename(null);
            if (this.collection == null) {
                throw new IllegalStateException("The collections composing this " + ConcatenatedDocumentCollection.class.getName() + " have not been loaded correctly; please use " + AbstractDocumentSequence.class.getSimpleName() + ".load() or call filename() after deserialising this instance, and ensure that the names stored are correct ");
            }
        }
    }

    public ConcatenatedDocumentCollection(String ... collectionName) throws IllegalArgumentException, SecurityException {
        this.collectionName = collectionName;
        this.n = collectionName.length;
    }

    @Override
    public void filename(CharSequence filename) {
        try {
            this.initCollections(filename, true);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public DocumentCollection copy() {
        DocumentCollection[] collection = new DocumentCollection[this.n];
        int i = this.n;
        while (i-- != 0) {
            collection[i] = this.collection[i].copy();
        }
        return new ConcatenatedDocumentCollection(this.collectionName, collection);
    }

    @Override
    public Document document(int index) throws IOException {
        this.ensureDocumentIndex(index);
        this.ensureCollections();
        int segment = Arrays.binarySearch(this.startDocument, (long)index);
        if (segment < 0) {
            segment = -segment - 2;
        }
        return this.collection[segment].document((int)((long)index - this.startDocument[segment]));
    }

    @Override
    public Reference2ObjectMap<Enum<?>, Object> metadata(int index) throws IOException {
        this.ensureDocumentIndex(index);
        this.ensureCollections();
        int segment = Arrays.binarySearch(this.startDocument, (long)index);
        if (segment < 0) {
            segment = -segment - 2;
        }
        return this.collection[segment].metadata((int)((long)index - this.startDocument[segment]));
    }

    @Override
    public int size() {
        return (int)this.startDocument[this.n];
    }

    @Override
    public InputStream stream(int index) throws IOException {
        this.ensureDocumentIndex(index);
        this.ensureCollections();
        int segment = Arrays.binarySearch(this.startDocument, (long)index);
        if (segment < 0) {
            segment = -segment - 2;
        }
        return this.collection[segment].stream((int)((long)index - this.startDocument[segment]));
    }

    @Override
    public DocumentFactory factory() {
        this.ensureCollections();
        return this.collection[0].factory();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.initCollections(null, false);
    }

    @Override
    public void close() throws IOException {
        super.close();
        for (DocumentCollection c : this.collection) {
            c.close();
        }
    }
}

