/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.document;

import it.unimi.dsi.mg4j.document.AbstractDocumentIterator;
import it.unimi.dsi.mg4j.document.AbstractDocumentSequence;
import it.unimi.dsi.mg4j.document.Document;
import it.unimi.dsi.mg4j.document.DocumentFactory;
import it.unimi.dsi.mg4j.document.DocumentIterator;
import it.unimi.dsi.mg4j.document.DocumentSequence;
import java.io.File;
import java.io.IOException;

public class ConcatenatedDocumentSequence
extends AbstractDocumentSequence {
    private static final long serialVersionUID = 1L;
    private final String[] sequenceName;
    private final DocumentSequence[] sequence;
    private DocumentFactory factory;
    private CharSequence filename;
    private DocumentSequence sequence0;
    private int n;

    public ConcatenatedDocumentSequence(DocumentSequence ... sequence) throws IOException {
        this((String[])null, sequence);
    }

    public ConcatenatedDocumentSequence(String ... sequenceName) throws IOException {
        this(sequenceName, (DocumentSequence[])null);
    }

    protected ConcatenatedDocumentSequence(String[] sequenceName, DocumentSequence[] sequence) throws IOException {
        this.sequenceName = sequenceName;
        this.sequence = sequence;
        this.n = sequenceName != null ? sequenceName.length : sequence.length;
        this.sequence0 = this.getSequence(0);
        this.factory = this.sequence0.factory();
    }

    private DocumentSequence getSequence(int i) throws IOException {
        DocumentSequence s;
        if (this.sequence != null) {
            s = this.sequence[i];
        } else {
            File parent = this.filename != null ? new File(((Object)this.filename).toString()).getParentFile() : null;
            try {
                s = AbstractDocumentSequence.load(new File(parent, this.sequenceName[i]).toString());
            }
            catch (SecurityException e) {
                throw new RuntimeException(e);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            if (this.factory != null && s.factory().getClass() != this.factory.getClass()) {
                throw new IllegalArgumentException("All segment in a concatenated document sequence must used the same factory class");
            }
        }
        return s;
    }

    @Override
    public void filename(CharSequence filename) {
        this.filename = filename;
    }

    @Override
    public DocumentFactory factory() {
        return this.factory;
    }

    @Override
    public void close() throws IOException {
        super.close();
        if (this.sequence0 != null) {
            this.sequence0.close();
        }
    }

    @Override
    public DocumentIterator iterator() throws IOException {
        return new AbstractDocumentIterator(){
            private DocumentSequence currentSequence;
            private DocumentIterator currentIterator;
            private int currSequenceIndex;
            {
                this.currentSequence = ConcatenatedDocumentSequence.this.sequence0 == null ? ConcatenatedDocumentSequence.this.getSequence(0) : ConcatenatedDocumentSequence.this.sequence0;
                this.currentIterator = this.currentSequence.iterator();
            }

            @Override
            public Document nextDocument() throws IOException {
                while (this.currentIterator != null) {
                    Document d = this.currentIterator.nextDocument();
                    if (d != null) {
                        return d;
                    }
                    this.currentIterator.close();
                    this.currentSequence.close();
                    if (this.currentSequence == ConcatenatedDocumentSequence.this.sequence0) {
                        ConcatenatedDocumentSequence.this.sequence0 = null;
                    }
                    this.currentIterator = null;
                    this.currentSequence = null;
                    if (this.currSequenceIndex >= ConcatenatedDocumentSequence.this.n - 1) continue;
                    this.currentSequence = ConcatenatedDocumentSequence.this.getSequence(++this.currSequenceIndex);
                    this.currentIterator = this.currentSequence.iterator();
                }
                return null;
            }

            @Override
            public void close() throws IOException {
                if (this.currentIterator != null) {
                    this.currentIterator.close();
                }
                if (this.currentSequence != null) {
                    this.currentSequence.close();
                }
                if (this.currentSequence == ConcatenatedDocumentSequence.this.sequence0) {
                    ConcatenatedDocumentSequence.this.sequence0 = null;
                }
            }
        };
    }
}

