/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.document;

import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.io.FastBufferedReader;
import it.unimi.dsi.io.WordReader;
import it.unimi.dsi.lang.ObjectParser;
import it.unimi.dsi.mg4j.document.Document;
import it.unimi.dsi.mg4j.document.DocumentFactory;
import it.unimi.dsi.mg4j.document.PropertyBasedDocumentFactory;
import it.unimi.dsi.mg4j.util.MG4JClassParser;
import it.unimi.dsi.util.Properties;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import org.apache.commons.configuration.ConfigurationException;

public class IdentityDocumentFactory
extends PropertyBasedDocumentFactory {
    private static final long serialVersionUID = 2L;
    private String fieldName;
    private transient WordReader wordReader;

    @Override
    protected boolean parseProperty(String key, String[] values, Reference2ObjectMap<Enum<?>, Object> metadata) throws ConfigurationException {
        if (IdentityDocumentFactory.sameKey(PropertyBasedDocumentFactory.MetadataKeys.ENCODING, key)) {
            metadata.put((Object)PropertyBasedDocumentFactory.MetadataKeys.ENCODING, (Object)Charset.forName(IdentityDocumentFactory.ensureJustOne(key, values)).toString());
            return true;
        }
        if (IdentityDocumentFactory.sameKey(PropertyBasedDocumentFactory.MetadataKeys.WORDREADER, key)) {
            try {
                String spec = IdentityDocumentFactory.ensureJustOne(key, values).toString();
                metadata.put((Object)PropertyBasedDocumentFactory.MetadataKeys.WORDREADER, (Object)spec);
                ObjectParser.fromSpec((String)spec, WordReader.class, (String[])MG4JClassParser.PACKAGE);
            }
            catch (ClassNotFoundException e) {
                throw new ConfigurationException((Throwable)e);
            }
            catch (Exception e) {
                throw new ConfigurationException((Throwable)e);
            }
            return true;
        }
        if (IdentityDocumentFactory.sameKey(MetadataKeys.FIELDNAME, key)) {
            metadata.put((Object)MetadataKeys.FIELDNAME, (Object)IdentityDocumentFactory.ensureJustOne(key, values));
            return true;
        }
        return super.parseProperty(key, values, metadata);
    }

    public IdentityDocumentFactory() {
        this.init();
    }

    private void init() {
        Object o = this.defaultMetadata.get((Object)MetadataKeys.FIELDNAME);
        this.fieldName = o == null ? "text" : o.toString();
        try {
            o = this.defaultMetadata.get((Object)PropertyBasedDocumentFactory.MetadataKeys.WORDREADER);
            this.wordReader = o == null ? new FastBufferedReader() : (WordReader)ObjectParser.fromSpec((String)o.toString(), WordReader.class, (String[])MG4JClassParser.PACKAGE);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public IdentityDocumentFactory(Reference2ObjectMap<Enum<?>, Object> defaultMetadata) {
        super(defaultMetadata);
        this.init();
    }

    public IdentityDocumentFactory(Properties properties) throws ConfigurationException {
        super(properties);
        this.init();
    }

    public IdentityDocumentFactory(String[] property) throws ConfigurationException {
        super(property);
        this.init();
    }

    @Override
    public IdentityDocumentFactory copy() {
        return new IdentityDocumentFactory(this.defaultMetadata);
    }

    @Override
    public int numberOfFields() {
        return 1;
    }

    @Override
    public String fieldName(int field) {
        this.ensureFieldIndex(field);
        return this.fieldName;
    }

    @Override
    public int fieldIndex(String fieldName) {
        return fieldName.equals(this.fieldName) ? 0 : -1;
    }

    @Override
    public DocumentFactory.FieldType fieldType(int field) {
        this.ensureFieldIndex(field);
        return DocumentFactory.FieldType.TEXT;
    }

    @Override
    public Document getDocument(final InputStream rawContent, final Reference2ObjectMap<Enum<?>, Object> metadata) {
        return new Document(){

            @Override
            public CharSequence title() {
                return (CharSequence)IdentityDocumentFactory.this.resolve(PropertyBasedDocumentFactory.MetadataKeys.TITLE, metadata);
            }

            public String toString() {
                return ((Object)this.title()).toString();
            }

            @Override
            public CharSequence uri() {
                return (CharSequence)IdentityDocumentFactory.this.resolve(PropertyBasedDocumentFactory.MetadataKeys.URI, metadata);
            }

            @Override
            public Object content(int field) {
                IdentityDocumentFactory.this.ensureFieldIndex(field);
                try {
                    return new InputStreamReader(rawContent, (String)IdentityDocumentFactory.this.resolveNotNull(PropertyBasedDocumentFactory.MetadataKeys.ENCODING, metadata));
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public WordReader wordReader(int field) {
                IdentityDocumentFactory.this.ensureFieldIndex(field);
                return IdentityDocumentFactory.this.wordReader;
            }

            @Override
            public void close() {
            }
        };
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.init();
    }

    public static enum MetadataKeys {
        FIELDNAME;

    }
}

