/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.document;

import it.unimi.dsi.fastutil.io.FastBufferedInputStream;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.mg4j.document.Document;
import it.unimi.dsi.mg4j.document.DocumentFactory;
import it.unimi.dsi.mg4j.document.DocumentIterator;
import it.unimi.dsi.mg4j.document.DocumentSequence;
import it.unimi.dsi.mg4j.document.PropertyBasedDocumentFactory;
import java.io.IOException;
import java.io.InputStream;

public class InputStreamDocumentSequence
extends FastBufferedInputStream
implements DocumentSequence {
    private final int separator;
    private final DocumentFactory factory;
    private boolean eof = true;
    private final int maxDocs;

    public InputStreamDocumentSequence(InputStream inputStream, int separator, DocumentFactory factory, int maxDocs) {
        super(inputStream);
        this.separator = separator;
        this.factory = factory;
        this.maxDocs = maxDocs;
    }

    public InputStreamDocumentSequence(InputStream inputStream, int separator, DocumentFactory factory) {
        this(inputStream, separator, factory, Integer.MAX_VALUE);
    }

    @Override
    public DocumentIterator iterator() {
        final Reference2ObjectArrayMap metadata = new Reference2ObjectArrayMap(2);
        return new DocumentIterator(){
            private int i;
            private Document last;

            @Override
            public Document nextDocument() throws IOException {
                if (this.last != null) {
                    this.last.close();
                }
                if (this.i >= InputStreamDocumentSequence.this.maxDocs) {
                    this.last = null;
                    return null;
                }
                if (!InputStreamDocumentSequence.this.eof) {
                    InputStreamDocumentSequence.this.close();
                }
                InputStreamDocumentSequence.this.eof = false;
                String documentIndex = Integer.toString(this.i++);
                metadata.put((Object)PropertyBasedDocumentFactory.MetadataKeys.TITLE, (Object)documentIndex);
                metadata.put((Object)PropertyBasedDocumentFactory.MetadataKeys.URI, (Object)documentIndex);
                this.last = InputStreamDocumentSequence.this.noMoreBytes() ? null : InputStreamDocumentSequence.this.factory.getDocument((InputStream)((Object)InputStreamDocumentSequence.this), (Reference2ObjectMap<Enum<?>, Object>)metadata);
                return this.last;
            }

            @Override
            public void close() {
            }
        };
    }

    @Override
    public DocumentFactory factory() {
        return this.factory;
    }

    public boolean noMoreBytes() throws IOException {
        if (this.avail > 0) {
            return false;
        }
        this.avail = this.is.read(this.buffer);
        if (this.avail <= 0) {
            this.avail = 0;
            this.eof = true;
            return true;
        }
        this.pos = 0;
        return false;
    }

    public int read() throws IOException {
        if (this.eof) {
            return -1;
        }
        int nextByte = super.read();
        if (nextByte == this.separator || nextByte == -1) {
            this.eof = true;
            return -1;
        }
        return nextByte;
    }

    public int read(byte[] b) throws IOException {
        if (this.eof) {
            return -1;
        }
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int offset, int length) throws IOException {
        if (this.eof) {
            return -1;
        }
        if (length == 0) {
            return 0;
        }
        int startOffset = offset;
        do {
            int i;
            int l = Math.min(length, this.avail);
            for (i = 0; i < l && this.buffer[this.pos + i] != this.separator; ++i) {
                b[offset + i] = this.buffer[this.pos + i];
            }
            this.pos += i;
            this.avail -= i;
            offset += i;
            if ((length -= i) == 0) {
                return offset - startOffset;
            }
            if (i >= l) continue;
            this.read();
            return offset - startOffset != 0 ? offset - startOffset : -1;
        } while (!this.noMoreBytes());
        return offset - startOffset != 0 ? offset - startOffset : -1;
    }

    public void mark(int readlimit) {
    }

    public boolean markSupported() {
        return false;
    }

    public long skip(long skip) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public void reset() {
        throw new UnsupportedOperationException();
    }

    public void flush() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() throws IOException {
        if (!this.eof) {
            while (this.read() != -1) {
            }
        }
        super.close();
    }

    @Override
    public void filename(CharSequence filename) throws IOException {
    }
}

