/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.document;

import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.io.WordReader;
import it.unimi.dsi.mg4j.document.AbstractDocument;
import it.unimi.dsi.mg4j.document.AbstractDocumentFactory;
import it.unimi.dsi.mg4j.document.Document;
import it.unimi.dsi.mg4j.document.DocumentFactory;
import java.io.IOException;
import java.io.InputStream;

public class ReplicatedDocumentFactory
extends AbstractDocumentFactory {
    private static final long serialVersionUID = 2L;
    public final DocumentFactory documentFactory;
    public final int numberOfCopies;
    private final Object2IntOpenHashMap<String> field2Index;
    private final String[] fieldName;

    private ReplicatedDocumentFactory(DocumentFactory documentFactory, int numberOfCopies, String[] fieldName) {
        this.documentFactory = documentFactory;
        this.numberOfCopies = numberOfCopies;
        this.fieldName = fieldName;
        if (this.numberOfFields() != fieldName.length) {
            throw new IllegalArgumentException("The number of field names (" + fieldName.length + ") is not equal to the number of fields in the replicated factory (" + this.numberOfFields() + ")");
        }
        this.field2Index = new Object2IntOpenHashMap(fieldName.length, 0.5f);
        this.field2Index.defaultReturnValue(-1);
        for (int i = 0; i < fieldName.length; ++i) {
            this.field2Index.put((Object)fieldName[i], i);
        }
        if (this.field2Index.size() != fieldName.length) {
            throw new IllegalArgumentException("The field name array " + ObjectArrayList.wrap((Object[])fieldName) + " contains duplicates");
        }
    }

    protected ReplicatedDocumentFactory(DocumentFactory documentFactory, int numberOfCopies, String[] fieldName, Object2IntOpenHashMap<String> field2Index) {
        this.documentFactory = documentFactory;
        this.numberOfCopies = numberOfCopies;
        this.field2Index = field2Index;
        this.fieldName = fieldName;
    }

    public static DocumentFactory getFactory(DocumentFactory documentFactory, int numberOfCopies, String[] fieldName) {
        return new ReplicatedDocumentFactory(documentFactory, numberOfCopies, fieldName);
    }

    @Override
    public ReplicatedDocumentFactory copy() {
        return new ReplicatedDocumentFactory(this.documentFactory.copy(), this.numberOfCopies, this.fieldName, this.field2Index);
    }

    @Override
    public int numberOfFields() {
        return this.numberOfCopies * this.documentFactory.numberOfFields();
    }

    @Override
    public String fieldName(int field) {
        this.ensureFieldIndex(field);
        return this.fieldName[field];
    }

    @Override
    public int fieldIndex(String fieldName) {
        return this.field2Index.getInt((Object)fieldName);
    }

    @Override
    public DocumentFactory.FieldType fieldType(int field) {
        this.ensureFieldIndex(field);
        return this.documentFactory.fieldType(field % this.documentFactory.numberOfFields());
    }

    @Override
    public Document getDocument(InputStream rawContent, Reference2ObjectMap<Enum<?>, Object> metadata) throws IOException {
        return new ReplicatedDocument(rawContent, metadata);
    }

    protected class ReplicatedDocument
    extends AbstractDocument {
        private int currField = -1;
        private Document currDocument;
        private CharSequence title;
        private CharSequence uri;
        private final InputStream rawContent;
        private final Reference2ObjectMap<Enum<?>, Object> metadata;

        protected ReplicatedDocument(InputStream rawContent, Reference2ObjectMap<Enum<?>, Object> metadata) throws IOException {
            this.rawContent = rawContent;
            this.metadata = metadata;
            this.currDocument = ReplicatedDocumentFactory.this.documentFactory.getDocument(rawContent, metadata);
            this.title = this.currDocument.title();
            this.uri = this.currDocument.uri();
        }

        @Override
        public CharSequence title() {
            return this.title;
        }

        @Override
        public String toString() {
            return ((Object)this.title()).toString();
        }

        @Override
        public CharSequence uri() {
            return this.uri;
        }

        @Override
        public Object content(int field) throws IOException {
            ReplicatedDocumentFactory.this.ensureFieldIndex(field);
            if (field <= this.currField) {
                throw new IOException("Composite document factories require sequential access");
            }
            while (this.currField < field) {
                ++this.currField;
                if (this.currField % ReplicatedDocumentFactory.this.documentFactory.numberOfFields() != 0) continue;
                if (this.currField > 0) {
                    this.rawContent.reset();
                }
                this.currDocument = ReplicatedDocumentFactory.this.documentFactory.getDocument(this.rawContent, this.metadata);
            }
            return this.currDocument.content(field % ReplicatedDocumentFactory.this.documentFactory.numberOfFields());
        }

        @Override
        public WordReader wordReader(int field) {
            ReplicatedDocumentFactory.this.ensureFieldIndex(field);
            return this.currDocument.wordReader(field % ReplicatedDocumentFactory.this.documentFactory.numberOfFields());
        }
    }
}

