/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.document;

import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.UnflaggedOption;
import it.unimi.dsi.fastutil.ints.AbstractIntComparator;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.ints.IntComparator;
import it.unimi.dsi.fastutil.io.FastBufferedInputStream;
import it.unimi.dsi.fastutil.io.FastBufferedOutputStream;
import it.unimi.dsi.fastutil.longs.AbstractLongIterator;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMaps;
import it.unimi.dsi.io.ByteBufferInputStream;
import it.unimi.dsi.io.FastBufferedReader;
import it.unimi.dsi.io.InputBitStream;
import it.unimi.dsi.io.NullInputStream;
import it.unimi.dsi.io.OutputBitStream;
import it.unimi.dsi.io.WordReader;
import it.unimi.dsi.lang.MutableString;
import it.unimi.dsi.mg4j.document.AbstractDocument;
import it.unimi.dsi.mg4j.document.AbstractDocumentCollection;
import it.unimi.dsi.mg4j.document.AbstractDocumentSequence;
import it.unimi.dsi.mg4j.document.Document;
import it.unimi.dsi.mg4j.document.DocumentCollection;
import it.unimi.dsi.mg4j.document.DocumentFactory;
import it.unimi.dsi.mg4j.document.FileSetDocumentCollection;
import it.unimi.dsi.mg4j.document.SimpleCompressedDocumentCollectionBuilder;
import it.unimi.dsi.mg4j.tool.Scan;
import it.unimi.dsi.mg4j.util.parser.callback.AnchorExtractor;
import it.unimi.dsi.sux4j.util.EliasFanoMonotoneLongBigList;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.nio.channels.FileChannel;
import java.util.NoSuchElementException;
import java.util.zip.ZipFile;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.io.IOUtils;

public class SimpleCompressedDocumentCollection
extends AbstractDocumentCollection
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final boolean DEBUG = false;
    protected static final boolean ASSERTS = false;
    public static final String DOCUMENTS_EXTENSION = ".documents";
    public static final String DOCUMENT_OFFSETS_EXTENSION = ".docoffsets";
    public static final String TERMS_EXTENSION = ".terms";
    public static final String TERM_OFFSETS_EXTENSION = ".termoffsets";
    public static final String NONTERMS_EXTENSION = ".nonterms";
    public static final String NONTERM_OFFSETS_EXTENSION = ".nontermoffsets";
    public static final String STATS_EXTENSION = ".stats";
    private final String basename;
    private final boolean exact;
    private final long documents;
    private final long terms;
    private final long nonTerms;
    private transient EliasFanoMonotoneLongBigList docOffsets;
    private transient EliasFanoMonotoneLongBigList termOffsets;
    private transient EliasFanoMonotoneLongBigList nonTermOffsets;
    private transient InputBitStream documentsInputBitStream;
    private transient FastBufferedInputStream termsInputStream;
    private transient FastBufferedInputStream nonTermsInputStream;
    private transient FrequencyCodec termsFrequencyKeeper;
    private transient FrequencyCodec nonTermsFrequencyKeeper;
    private final DocumentFactory factory;
    private final boolean hasNonText;
    private transient ZipFile zipFile;
    private transient ByteBufferInputStream documentsByteBufferInputStream;
    private transient ByteBufferInputStream termsByteBufferInputStream;
    private transient ByteBufferInputStream nonTermsByteBufferInputStream;
    private boolean fileOpenOk;
    private boolean fileMappingOk;

    private SimpleCompressedDocumentCollection(String basename, DocumentFactory factory, EliasFanoMonotoneLongBigList docOffsets, EliasFanoMonotoneLongBigList termOffsets, EliasFanoMonotoneLongBigList nonTermOffsets, ByteBufferInputStream documentsByteBufferInputStream, ByteBufferInputStream termsByteBufferInputStream, ByteBufferInputStream nonTermsByteBufferInputStream) {
        this.basename = basename;
        this.documents = docOffsets.size64() - 1L;
        this.terms = termOffsets.size64() - 1L;
        this.exact = nonTermOffsets != null;
        this.nonTerms = this.exact ? termOffsets.size64() - 1L : -1L;
        this.docOffsets = docOffsets;
        this.termOffsets = termOffsets;
        this.nonTermOffsets = nonTermOffsets;
        this.factory = factory;
        this.termsFrequencyKeeper = new FrequencyCodec();
        this.nonTermsFrequencyKeeper = this.exact ? new FrequencyCodec() : null;
        this.documentsByteBufferInputStream = documentsByteBufferInputStream;
        this.termsByteBufferInputStream = termsByteBufferInputStream;
        this.nonTermsByteBufferInputStream = nonTermsByteBufferInputStream;
        this.hasNonText = SimpleCompressedDocumentCollection.hasNonText(factory);
    }

    protected SimpleCompressedDocumentCollection(String basename, long documents, long terms, long nonTerms, boolean exact, DocumentFactory factory) {
        this.hasNonText = SimpleCompressedDocumentCollection.hasNonText(factory);
        this.basename = basename;
        this.documents = documents;
        this.terms = terms;
        this.nonTerms = nonTerms;
        this.exact = exact;
        this.factory = factory;
        this.termsFrequencyKeeper = null;
        this.nonTermsFrequencyKeeper = null;
        this.nonTermOffsets = null;
        this.termOffsets = null;
        this.docOffsets = null;
        this.documentsInputBitStream = null;
        this.nonTermsInputStream = null;
        this.termsInputStream = null;
        this.zipFile = null;
        try {
        }
        catch (IOException cantHappen) {
            throw new RuntimeException(cantHappen);
        }
    }

    private static boolean hasNonText(DocumentFactory factory) {
        boolean hasNonText = false;
        int i = factory.numberOfFields();
        while (i-- != 0) {
            hasNonText |= factory.fieldType(i) != DocumentFactory.FieldType.TEXT;
        }
        return hasNonText;
    }

    private void initMappings(String basename, boolean rethrow) throws IOException {
        block2: {
            try {
                this.termsByteBufferInputStream = ByteBufferInputStream.map((FileChannel)new FileInputStream(basename + TERMS_EXTENSION).getChannel(), (FileChannel.MapMode)FileChannel.MapMode.READ_ONLY);
                this.nonTermsByteBufferInputStream = this.nonTermOffsets != null ? ByteBufferInputStream.map((FileChannel)new FileInputStream(basename + NONTERMS_EXTENSION).getChannel(), (FileChannel.MapMode)FileChannel.MapMode.READ_ONLY) : null;
                this.fileMappingOk = true;
            }
            catch (IOException e) {
                if (!rethrow) break block2;
                throw e;
            }
        }
    }

    private void loadOffsets(String basename, boolean rethrow) throws IOException {
        block2: {
            try {
                this.docOffsets = SimpleCompressedDocumentCollection.loadOffsetsSuccinctly(basename + DOCUMENT_OFFSETS_EXTENSION, this.documents, new File(basename + DOCUMENTS_EXTENSION).length() * 8L + 1L);
                this.termOffsets = SimpleCompressedDocumentCollection.loadOffsetsSuccinctly(basename + TERM_OFFSETS_EXTENSION, this.terms, new File(basename + TERMS_EXTENSION).length() + 1L);
                this.nonTermOffsets = this.nonTerms < 0L ? null : SimpleCompressedDocumentCollection.loadOffsetsSuccinctly(basename + NONTERM_OFFSETS_EXTENSION, this.nonTerms, new File(basename + NONTERMS_EXTENSION).length() + 1L);
            }
            catch (IOException e) {
                if (!rethrow) break block2;
                throw e;
            }
        }
    }

    private void initFiles(String basename, boolean rethrow) throws IOException {
        block2: {
            try {
                this.documentsInputBitStream = this.documentsByteBufferInputStream != null ? new InputBitStream((InputStream)this.documentsByteBufferInputStream) : new InputBitStream(basename + DOCUMENTS_EXTENSION);
                this.termsInputStream = new FastBufferedInputStream((InputStream)(this.termsByteBufferInputStream != null ? this.termsByteBufferInputStream : new FileInputStream(basename + TERMS_EXTENSION)));
                this.nonTermsInputStream = this.exact ? new FastBufferedInputStream((InputStream)(this.nonTermsByteBufferInputStream != null ? this.nonTermsByteBufferInputStream : new FileInputStream(basename + NONTERMS_EXTENSION))) : null;
                this.zipFile = this.hasNonText ? new ZipFile(basename + ".zip") : null;
                this.fileOpenOk = true;
            }
            catch (IOException e) {
                if (!rethrow) break block2;
                throw e;
            }
        }
    }

    private void ensureFiles() {
        if (!this.fileOpenOk) {
            throw new IllegalStateException("Some of the files used by this " + SimpleCompressedDocumentCollection.class.getSimpleName() + " have not been loaded correctly; please use " + AbstractDocumentSequence.class.getName() + ".load() or call filename() after deserialising this instance");
        }
    }

    private static EliasFanoMonotoneLongBigList loadOffsetsSuccinctly(CharSequence filename, long numberOfItems, long upperBound) throws IOException {
        InputBitStream ibs = new InputBitStream(((Object)filename).toString());
        EliasFanoMonotoneLongBigList offsets = new EliasFanoMonotoneLongBigList(numberOfItems + 1L, upperBound, (LongIterator)new OffsetsLongIterator(ibs, numberOfItems + 1L));
        ibs.close();
        return offsets;
    }

    @Override
    public void filename(CharSequence filename) throws IOException {
        if (!this.fileMappingOk) {
            this.initMappings(new File(new File(((Object)filename).toString()).getParentFile(), this.basename).toString(), true);
        }
        if (!this.fileOpenOk) {
            this.loadOffsets(new File(new File(((Object)filename).toString()).getParentFile(), this.basename).toString(), true);
            this.initFiles(new File(new File(((Object)filename).toString()).getParentFile(), this.basename).toString(), true);
        }
    }

    @Override
    public DocumentCollection copy() {
        this.ensureFiles();
        try {
            SimpleCompressedDocumentCollection copy = new SimpleCompressedDocumentCollection(this.basename, this.factory.copy(), this.docOffsets, this.termOffsets, this.nonTermOffsets, this.documentsByteBufferInputStream != null ? this.documentsByteBufferInputStream.copy() : null, this.termsByteBufferInputStream != null ? this.termsByteBufferInputStream.copy() : null, this.nonTermsByteBufferInputStream != null ? this.nonTermsByteBufferInputStream.copy() : null);
            copy.initFiles(this.basename, true);
            return copy;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static MutableString readSelfDelimitedUtf8String(InputBitStream ibs, MutableString s) throws IOException {
        s.length(0);
        int length = ibs.readDelta();
        while (length-- != 0) {
            s.append((char)ibs.readZeta(7));
        }
        return s;
    }

    @Override
    public Document document(int index) throws IOException {
        this.ensureDocumentIndex(index);
        this.ensureFiles();
        this.documentsInputBitStream.position(this.docOffsets.getLong(index));
        final DataInputStream nonTextDataInputStream = this.hasNonText ? new DataInputStream((InputStream)new FastBufferedInputStream(this.zipFile.getInputStream(this.zipFile.getEntry(Integer.toString(index))))) : null;
        final MutableString uri = SimpleCompressedDocumentCollection.readSelfDelimitedUtf8String(this.documentsInputBitStream, new MutableString());
        final MutableString title = SimpleCompressedDocumentCollection.readSelfDelimitedUtf8String(this.documentsInputBitStream, new MutableString());
        return new AbstractDocument(){
            final MutableString fieldContent = new MutableString();
            final Document fakeDocument = SimpleCompressedDocumentCollection.access$000(SimpleCompressedDocumentCollection.this).getDocument((InputStream)NullInputStream.getInstance(), (Reference2ObjectMap<Enum<?>, Object>)Reference2ObjectMaps.EMPTY_MAP);
            int nextField = 0;

            @Override
            public Object content(int field) throws IOException {
                int nfrag;
                int len;
                DocumentFactory.FieldType fieldType = SimpleCompressedDocumentCollection.this.factory.fieldType(field);
                if (this.nextField > field) {
                    throw new IllegalStateException();
                }
                MutableString s = new MutableString();
                while (this.nextField < field) {
                    switch (fieldType) {
                        case TEXT: {
                            len = SimpleCompressedDocumentCollection.this.documentsInputBitStream.readDelta();
                            if (SimpleCompressedDocumentCollection.this.exact) {
                                len *= 2;
                            }
                            SimpleCompressedDocumentCollection.this.documentsInputBitStream.skipDeltas(len);
                            break;
                        }
                        case VIRTUAL: {
                            nfrag = nonTextDataInputStream.readInt();
                            for (int i = 0; i < 2 * nfrag; ++i) {
                                MutableString.skipSelfDelimUTF8((InputStream)nonTextDataInputStream);
                            }
                            break;
                        }
                        default: {
                            try {
                                new ObjectInputStream(nonTextDataInputStream).readObject();
                                break;
                            }
                            catch (ClassNotFoundException e) {
                                throw new RuntimeException(e);
                            }
                        }
                    }
                    ++this.nextField;
                }
                ++this.nextField;
                switch (fieldType) {
                    case TEXT: {
                        len = SimpleCompressedDocumentCollection.this.documentsInputBitStream.readDelta();
                        this.fieldContent.length(0);
                        SimpleCompressedDocumentCollection.this.termsFrequencyKeeper.reset();
                        if (SimpleCompressedDocumentCollection.this.exact) {
                            SimpleCompressedDocumentCollection.this.nonTermsFrequencyKeeper.reset();
                        }
                        while (len-- != 0) {
                            SimpleCompressedDocumentCollection.this.termsInputStream.position(SimpleCompressedDocumentCollection.this.termOffsets.getLong(SimpleCompressedDocumentCollection.this.termsFrequencyKeeper.decode(SimpleCompressedDocumentCollection.this.documentsInputBitStream.readDelta())));
                            s.readSelfDelimUTF8((InputStream)SimpleCompressedDocumentCollection.this.termsInputStream);
                            this.fieldContent.append(s);
                            if (SimpleCompressedDocumentCollection.this.exact) {
                                SimpleCompressedDocumentCollection.this.nonTermsInputStream.position(SimpleCompressedDocumentCollection.this.nonTermOffsets.getLong(SimpleCompressedDocumentCollection.this.nonTermsFrequencyKeeper.decode(SimpleCompressedDocumentCollection.this.documentsInputBitStream.readDelta())));
                                s.readSelfDelimUTF8((InputStream)SimpleCompressedDocumentCollection.this.nonTermsInputStream);
                                this.fieldContent.append(s);
                                continue;
                            }
                            this.fieldContent.append(' ');
                        }
                        return new FastBufferedReader(this.fieldContent);
                    }
                    case VIRTUAL: {
                        nfrag = nonTextDataInputStream.readInt();
                        MutableString doc = new MutableString();
                        MutableString text = new MutableString();
                        Object[] fragArray = new Scan.VirtualDocumentFragment[nfrag];
                        for (int i = 0; i < nfrag; ++i) {
                            doc.readSelfDelimUTF8((InputStream)nonTextDataInputStream);
                            text.readSelfDelimUTF8((InputStream)nonTextDataInputStream);
                            fragArray[i] = new AnchorExtractor.Anchor(doc.copy(), text.copy());
                        }
                        return new ObjectArrayList(fragArray);
                    }
                }
                try {
                    return new ObjectInputStream(nonTextDataInputStream).readObject();
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public CharSequence title() {
                return title;
            }

            @Override
            public CharSequence uri() {
                return uri.length() == 0 ? null : uri;
            }

            @Override
            public WordReader wordReader(int field) {
                switch (SimpleCompressedDocumentCollection.this.factory.fieldType(field)) {
                    case TEXT: 
                    case VIRTUAL: {
                        return this.fakeDocument.wordReader(field);
                    }
                }
                return null;
            }

            @Override
            public void close() throws IOException {
                super.close();
                if (SimpleCompressedDocumentCollection.this.hasNonText) {
                    nonTextDataInputStream.close();
                }
            }
        };
    }

    @Override
    public Reference2ObjectMap<Enum<?>, Object> metadata(int index) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return (int)this.documents;
    }

    @Override
    public InputStream stream(int index) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() throws IOException {
        super.close();
        if (this.documentsInputBitStream != null) {
            this.documentsInputBitStream.close();
        }
        IOUtils.closeQuietly((InputStream)this.termsInputStream);
        IOUtils.closeQuietly((InputStream)this.nonTermsInputStream);
    }

    @Override
    public DocumentFactory factory() {
        return this.factory;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.loadOffsets(this.basename, false);
        this.initMappings(this.basename, false);
        this.initFiles(this.basename, false);
        this.termsFrequencyKeeper = new FrequencyCodec();
        if (this.exact) {
            this.nonTermsFrequencyKeeper = new FrequencyCodec();
        }
    }

    public static void optimize(CharSequence basename) throws IOException, ClassNotFoundException {
        SimpleCompressedDocumentCollection collection = (SimpleCompressedDocumentCollection)AbstractDocumentCollection.load(basename);
        final long[] termFrequency = new long[(int)collection.terms];
        long[] nonTermFrequency = collection.exact ? new long[(int)collection.nonTerms] : null;
        InputBitStream documentsIbs = collection.documentsInputBitStream;
        DocumentFactory factory = collection.factory;
        boolean exact = collection.exact;
        MutableString s = new MutableString();
        documentsIbs.position(0L);
        int i = (int)collection.documents;
        while (i-- != 0) {
            SimpleCompressedDocumentCollection.readSelfDelimitedUtf8String(documentsIbs, s);
            SimpleCompressedDocumentCollection.readSelfDelimitedUtf8String(documentsIbs, s);
            int f = factory.numberOfFields() - 1;
            while (f-- != 0) {
                int len = documentsIbs.readDelta();
                while (len-- != 0) {
                    int n = documentsIbs.readDelta();
                    termFrequency[n] = termFrequency[n] + 1L;
                    if (!exact) continue;
                    int n2 = documentsIbs.readDelta();
                    nonTermFrequency[n2] = nonTermFrequency[n2] + 1L;
                }
            }
        }
        int[] termPerm = new int[termFrequency.length];
        int i2 = termPerm.length;
        while (i2-- != 0) {
            termPerm[i2] = i2;
        }
        IntArrays.quickSort((int[])termPerm, (int)0, (int)termPerm.length, (IntComparator)new AbstractIntComparator(){

            public int compare(int arg0, int arg1) {
                return termFrequency[arg1] - termFrequency[arg0] < 0L ? -1 : (termFrequency[arg1] == termFrequency[arg0] ? 0 : 1);
            }
        });
        int[] invTermPerm = new int[termFrequency.length];
        int i3 = invTermPerm.length;
        while (i3-- != 0) {
            invTermPerm[termPerm[i3]] = i3;
        }
        int[] nonTermPerm = null;
        int[] invNonTermPerm = null;
        if (exact) {
            nonTermPerm = new int[termFrequency.length];
            int i4 = nonTermPerm.length;
            while (i4-- != 0) {
                nonTermPerm[i4] = i4;
            }
            IntArrays.quickSort((int[])nonTermPerm, (int)0, (int)nonTermPerm.length, (IntComparator)new AbstractIntComparator(){

                public int compare(int arg0, int arg1) {
                    return termFrequency[arg1] - termFrequency[arg0] < 0L ? -1 : (termFrequency[arg1] == termFrequency[arg0] ? 0 : 1);
                }
            });
            invNonTermPerm = new int[nonTermFrequency.length];
            i4 = invNonTermPerm.length;
            while (i4-- != 0) {
                invNonTermPerm[nonTermPerm[i4]] = i4;
            }
        }
        File newDocumentsFile = File.createTempFile(SimpleCompressedDocumentCollection.class.getSimpleName(), "temp", new File(((Object)basename).toString()).getParentFile());
        OutputBitStream newDocumentsObs = new OutputBitStream(newDocumentsFile);
        documentsIbs.position(0L);
        int i5 = (int)collection.documents;
        while (i5-- != 0) {
            SimpleCompressedDocumentCollection.readSelfDelimitedUtf8String(documentsIbs, s);
            SimpleCompressedDocumentCollectionBuilder.writeSelfDelimitedUtf8String(newDocumentsObs, (CharSequence)s);
            SimpleCompressedDocumentCollection.readSelfDelimitedUtf8String(documentsIbs, s);
            SimpleCompressedDocumentCollectionBuilder.writeSelfDelimitedUtf8String(newDocumentsObs, (CharSequence)s);
            int f = factory.numberOfFields() - 1;
            while (f-- != 0) {
                int len = documentsIbs.readDelta();
                newDocumentsObs.writeDelta(len);
                while (len-- != 0) {
                    newDocumentsObs.writeDelta(invTermPerm[documentsIbs.readDelta()]);
                    if (!exact) continue;
                    newDocumentsObs.writeDelta(invNonTermPerm[documentsIbs.readDelta()]);
                }
            }
        }
        newDocumentsObs.close();
        new File(basename + DOCUMENTS_EXTENSION).delete();
        newDocumentsFile.renameTo(new File(basename + DOCUMENTS_EXTENSION));
        newDocumentsObs = null;
        invNonTermPerm = null;
        invTermPerm = null;
        FastBufferedInputStream termsStream = new FastBufferedInputStream((InputStream)new FileInputStream(basename + TERMS_EXTENSION));
        MutableString[] term = new MutableString[(int)collection.terms];
        for (int i6 = 0; i6 < term.length; ++i6) {
            term[i6] = new MutableString().readSelfDelimUTF8((InputStream)termsStream);
        }
        termsStream.close();
        new FastBufferedOutputStream((OutputStream)new FileOutputStream(basename + TERMS_EXTENSION));
    }

    public static void main(String[] arg) throws IOException, JSAPException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, ConfigurationException, ClassNotFoundException {
        SimpleJSAP jsap = new SimpleJSAP(FileSetDocumentCollection.class.getName(), "Optimises a simple compressed document collection.", new Parameter[]{new UnflaggedOption("basename", (StringParser)JSAP.STRING_PARSER, true, "The filename of the collection.")});
        JSAPResult jsapResult = jsap.parse(arg);
        if (jsap.messagePrinted()) {
            return;
        }
        SimpleCompressedDocumentCollection.optimize(jsapResult.getString("basename"));
    }

    protected static class FrequencyCodec {
        private static final int MAX_QUEUE_SIZE = 2048;
        private final int[] queue;
        private final int[] freq;
        private final Int2IntOpenHashMap code2Pos = new Int2IntOpenHashMap();
        private int queueSize;

        public FrequencyCodec() {
            this.code2Pos.defaultReturnValue(-1);
            this.queue = new int[2048];
            this.freq = new int[2048];
        }

        public void reset() {
            this.queueSize = 0;
            this.code2Pos.clear();
        }

        private final void newSymbol(int symbol) {
            if (this.queueSize == 2048) {
                int j;
                if (this.freq[2047] != 1) {
                    j = 2048;
                    while (j-- != 0) {
                        int n = j;
                        this.freq[n] = this.freq[n] / this.freq[2047];
                    }
                }
                j = 2048;
                while (j-- != 0 && this.freq[j] <= 1) {
                }
                for (int k = j + (2048 - j) / 2; k < 2048; ++k) {
                    this.code2Pos.remove(this.queue[k]);
                }
                this.queueSize = j + (2048 - j) / 2;
            }
            this.code2Pos.put(symbol, this.queueSize);
            this.queue[this.queueSize] = symbol;
            this.freq[this.queueSize] = 1;
            ++this.queueSize;
        }

        private final void oldSymbol(int pos) {
            int ex;
            for (ex = pos; ex >= 0 && this.freq[ex] == this.freq[pos]; --ex) {
            }
            int n = pos;
            this.freq[n] = this.freq[n] + 1;
            int t = this.queue[pos];
            this.queue[pos] = this.queue[++ex];
            this.queue[ex] = t;
            t = this.freq[pos];
            this.freq[pos] = this.freq[ex];
            this.freq[ex] = t;
            this.code2Pos.put(this.queue[ex], ex);
            this.code2Pos.put(this.queue[pos], pos);
        }

        public int encode(int symbol) {
            int pos = this.code2Pos.get(symbol);
            if (pos == -1) {
                int result = this.queueSize + symbol;
                this.newSymbol(symbol);
                return result;
            }
            this.oldSymbol(pos);
            return pos;
        }

        public int decode(int symbol) {
            if (symbol < this.queueSize) {
                int result = this.queue[symbol];
                this.oldSymbol(symbol);
                return result;
            }
            int term = symbol - this.queueSize;
            this.newSymbol(term);
            return term;
        }
    }

    private static final class OffsetsLongIterator
    extends AbstractLongIterator {
        private final long numberOfItems;
        private long currIndex;
        private long currValue;
        private final InputBitStream ibs;

        public OffsetsLongIterator(InputBitStream ibs, long numberOfItems) {
            this.ibs = ibs;
            this.numberOfItems = numberOfItems;
        }

        public boolean hasNext() {
            return this.currIndex < this.numberOfItems;
        }

        public long nextLong() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            try {
                ++this.currIndex;
                return this.currValue += (long)this.ibs.readDelta();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

