/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.document;

import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.io.WordReader;
import it.unimi.dsi.mg4j.document.AbstractDocument;
import it.unimi.dsi.mg4j.document.AbstractDocumentFactory;
import it.unimi.dsi.mg4j.document.Document;
import it.unimi.dsi.mg4j.document.DocumentFactory;
import java.io.IOException;
import java.io.InputStream;

public class SubDocumentFactory
extends AbstractDocumentFactory {
    private static final long serialVersionUID = 1L;
    private final DocumentFactory underlyingFactory;
    private final int[] visibleField;
    private final Int2IntOpenHashMap field2Pos;

    public SubDocumentFactory(DocumentFactory underlyingFactory, int ... visibleField) {
        this.underlyingFactory = underlyingFactory;
        this.visibleField = visibleField;
        int i = visibleField.length;
        while (i-- > 1) {
            if (visibleField[i - 1] < visibleField[i]) continue;
            throw new IllegalArgumentException("Fields must be provided in increasing order");
        }
        this.field2Pos = new Int2IntOpenHashMap(visibleField.length, 0.25f);
        i = visibleField.length;
        while (i-- != 0) {
            this.field2Pos.put(visibleField[i], i);
        }
        this.field2Pos.defaultReturnValue(-1);
    }

    @Override
    public DocumentFactory copy() {
        return new SubDocumentFactory(this.underlyingFactory.copy(), this.visibleField);
    }

    @Override
    public int fieldIndex(String fieldName) {
        return this.field2Pos.get(this.underlyingFactory.fieldIndex(fieldName));
    }

    @Override
    public String fieldName(int field) {
        this.ensureFieldIndex(field);
        return this.underlyingFactory.fieldName(this.visibleField[field]);
    }

    @Override
    public DocumentFactory.FieldType fieldType(int field) {
        this.ensureFieldIndex(field);
        return this.underlyingFactory.fieldType(this.visibleField[field]);
    }

    @Override
    public Document getDocument(final InputStream rawContent, final Reference2ObjectMap<Enum<?>, Object> metadata) throws IOException {
        return new AbstractDocument(){
            final Document underlyingDocument;
            {
                this.underlyingDocument = SubDocumentFactory.this.underlyingFactory.getDocument(rawContent, metadata);
            }

            @Override
            public void close() throws IOException {
                this.underlyingDocument.close();
            }

            @Override
            public Object content(int field) throws IOException {
                return this.underlyingDocument.content(SubDocumentFactory.this.visibleField[field]);
            }

            @Override
            public CharSequence title() {
                return this.underlyingDocument.title();
            }

            @Override
            public CharSequence uri() {
                return this.underlyingDocument.uri();
            }

            @Override
            public WordReader wordReader(int field) {
                return this.underlyingDocument.wordReader(SubDocumentFactory.this.visibleField[field]);
            }
        };
    }

    @Override
    public int numberOfFields() {
        return this.visibleField.length;
    }
}

