/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.document;

import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.io.BinIO;
import it.unimi.dsi.mg4j.document.AbstractDocumentIterator;
import it.unimi.dsi.mg4j.document.AbstractDocumentSequence;
import it.unimi.dsi.mg4j.document.Document;
import it.unimi.dsi.mg4j.document.DocumentCollection;
import it.unimi.dsi.mg4j.document.DocumentFactory;
import it.unimi.dsi.mg4j.document.DocumentIterator;
import it.unimi.dsi.mg4j.document.DocumentSequence;
import java.io.IOException;
import java.io.Serializable;

public class SubsetDocumentSequence
extends AbstractDocumentSequence
implements Serializable {
    private static final long serialVersionUID = 1L;
    final DocumentSequence underlyingSequence;
    final IntSet documents;

    public SubsetDocumentSequence(DocumentSequence underlyingSequence, IntSet documents) {
        this.underlyingSequence = underlyingSequence;
        this.documents = documents;
    }

    public SubsetDocumentSequence(String underlyingSequenceBasename, String documentFileBasename) throws NumberFormatException, IllegalArgumentException, SecurityException, IOException, ClassNotFoundException {
        this((DocumentCollection)AbstractDocumentSequence.load(underlyingSequenceBasename), (IntSet)BinIO.loadObject((CharSequence)documentFileBasename));
    }

    @Override
    public DocumentIterator iterator() throws IOException {
        final DocumentIterator underlyingIterator = this.underlyingSequence.iterator();
        return new AbstractDocumentIterator(){
            int docPointer = -1;
            boolean over = false;
            boolean closed = false;

            @Override
            public Document nextDocument() throws IOException {
                Document doc;
                if (this.over) {
                    return null;
                }
                do {
                    doc = underlyingIterator.nextDocument();
                    ++this.docPointer;
                } while (doc != null && !SubsetDocumentSequence.this.documents.contains(this.docPointer));
                this.over = doc == null;
                return doc;
            }

            @Override
            public void close() throws IOException {
                if (!this.closed) {
                    underlyingIterator.close();
                    super.close();
                }
                this.closed = true;
            }
        };
    }

    @Override
    public DocumentFactory factory() {
        return this.underlyingSequence.factory();
    }

    @Override
    public void close() throws IOException {
        this.underlyingSequence.close();
        super.close();
    }
}

