/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.document;

import it.unimi.dsi.fastutil.io.FastBufferedInputStream;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.io.WordReader;
import it.unimi.dsi.mg4j.document.AbstractDocument;
import it.unimi.dsi.mg4j.document.AbstractDocumentFactory;
import it.unimi.dsi.mg4j.document.Document;
import it.unimi.dsi.mg4j.document.DocumentFactory;
import it.unimi.dsi.mg4j.document.PropertyBasedDocumentFactory;
import it.unimi.dsi.mg4j.document.TRECDocumentCollection;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class TRECHeaderDocumentFactory
extends AbstractDocumentFactory {
    private static final long serialVersionUID = -8671564750345493607L;
    private byte[] buffer = new byte[8192];

    @Override
    public int numberOfFields() {
        return 0;
    }

    @Override
    public String fieldName(int fieldIndex) {
        throw new IllegalArgumentException();
    }

    @Override
    public int fieldIndex(String fieldName) {
        return -1;
    }

    @Override
    public DocumentFactory.FieldType fieldType(int fieldIndex) {
        throw new IllegalArgumentException();
    }

    protected static boolean startsWith(byte[] a, int l, byte[] b) {
        int len = b.length;
        if (len > l) {
            return false;
        }
        while (len-- != 0) {
            if (a[len] == b[len]) continue;
            return false;
        }
        return true;
    }

    protected static boolean startsWithIgnoreCase(byte[] a, int l, char[] b) {
        int len = b.length;
        if (len > l) {
            return false;
        }
        while (len-- != 0) {
            if (Character.toLowerCase((char)a[len]) == Character.toLowerCase(b[len])) continue;
            return false;
        }
        return true;
    }

    @Override
    public Document getDocument(InputStream rawContent, Reference2ObjectMap<Enum<?>, Object> metadata) throws IOException {
        FastBufferedInputStream fbis = new FastBufferedInputStream(rawContent);
        int startedHeader = 0;
        boolean foundDocNo = false;
        int l = fbis.readLine(this.buffer);
        if (l < 0) {
            throw new EOFException();
        }
        if (!TRECDocumentCollection.equals(this.buffer, l, TRECDocumentCollection.DOC_OPEN)) {
            throw new IllegalStateException("Document does not start with <DOC>: " + new String(this.buffer, 0, l));
        }
        while ((l = fbis.readLine(this.buffer)) != -1) {
            if (!foundDocNo && TRECHeaderDocumentFactory.startsWith(this.buffer, l, TRECDocumentCollection.DOCNO_OPEN)) {
                foundDocNo = true;
                metadata.put((Object)PropertyBasedDocumentFactory.MetadataKeys.TITLE, (Object)new String(this.buffer, TRECDocumentCollection.DOCNO_OPEN.length, l - (TRECDocumentCollection.DOCNO_OPEN.length + TRECDocumentCollection.DOCNO_CLOSE.length)));
            }
            switch (startedHeader) {
                case 0: {
                    if (!TRECDocumentCollection.equals(this.buffer, l, TRECDocumentCollection.DOCHDR_OPEN)) break;
                    startedHeader = 1;
                    break;
                }
                case 1: {
                    startedHeader = 2;
                    metadata.put((Object)PropertyBasedDocumentFactory.MetadataKeys.URI, (Object)new String(this.buffer, 0, l));
                    break;
                }
            }
            if (!TRECDocumentCollection.equals(this.buffer, l, TRECDocumentCollection.DOCHDR_CLOSE)) continue;
        }
        return new TRECHeaderDocument(metadata);
    }

    @Override
    public DocumentFactory copy() {
        return this;
    }

    private class TRECHeaderDocument
    extends AbstractDocument {
        final Reference2ObjectMap<Enum<?>, Object> metadata;

        @Override
        public CharSequence title() {
            CharSequence t = (CharSequence)this.metadata.get((Object)PropertyBasedDocumentFactory.MetadataKeys.TITLE);
            return t == null ? "Title for " + this.uri() : t;
        }

        @Override
        public CharSequence uri() {
            return (CharSequence)this.metadata.get((Object)PropertyBasedDocumentFactory.MetadataKeys.URI);
        }

        @Override
        public Object content(int fieldIndex) throws IOException {
            throw new IllegalArgumentException();
        }

        @Override
        public WordReader wordReader(int fieldIndex) {
            throw new IllegalArgumentException();
        }

        public TRECHeaderDocument(Reference2ObjectMap<Enum<?>, Object> metadata) {
            this.metadata = metadata;
        }
    }
}

