/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.document;

import it.unimi.dsi.Util;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.io.FastBufferedReader;
import it.unimi.dsi.io.WordReader;
import it.unimi.dsi.lang.MutableString;
import it.unimi.dsi.mg4j.document.AbstractDocument;
import it.unimi.dsi.mg4j.document.AbstractDocumentCollection;
import it.unimi.dsi.mg4j.document.AbstractDocumentFactory;
import it.unimi.dsi.mg4j.document.AbstractDocumentIterator;
import it.unimi.dsi.mg4j.document.AbstractDocumentSequence;
import it.unimi.dsi.mg4j.document.Document;
import it.unimi.dsi.mg4j.document.DocumentFactory;
import it.unimi.dsi.mg4j.document.DocumentIterator;
import it.unimi.dsi.mg4j.document.PropertyBasedDocumentFactory;
import it.unimi.dsi.mg4j.tool.Scan;
import it.unimi.dsi.mg4j.util.parser.callback.AnchorExtractor;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Reader;
import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.apache.log4j.Logger;

public class ZipDocumentCollection
extends AbstractDocumentCollection
implements Serializable {
    private static final long serialVersionUID = 2L;
    public static final String ZIP_EXTENSION = ".zip";
    private static final Logger LOGGER = Util.getLogger(ZipDocumentCollection.class);
    private static final boolean DEBUG = false;
    private String zipFilename;
    private transient ZipFile zipFile;
    private final DocumentFactory underlyingFactory;
    private final DocumentFactory factory;
    private final int numberOfDocuments;
    private final boolean exact;

    private void initZipFile() {
        try {
            this.zipFile = new ZipFile(this.zipFilename);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void ensureZipFile() {
        if (this.zipFile == null) {
            throw new IllegalStateException("The .zip file used by this " + ZipDocumentCollection.class.getSimpleName() + " has not been loaded correctly; please use " + AbstractDocumentSequence.class.getName() + ".load() or call filename() after deserialising this instance");
        }
    }

    public ZipDocumentCollection(String zipFilename, DocumentFactory underlyingFactory, int numberOfDocuments, boolean exact) {
        this.zipFilename = zipFilename;
        this.underlyingFactory = underlyingFactory;
        this.numberOfDocuments = numberOfDocuments;
        this.exact = exact;
        this.factory = new ZipFactory(underlyingFactory, exact);
        this.initZipFile();
    }

    @Override
    public void filename(CharSequence filename) throws IOException {
        if (this.zipFile == null) {
            this.zipFilename = new File(new File(((Object)filename).toString()).getParentFile(), this.zipFilename).toString();
            this.zipFile = new ZipFile(this.zipFilename);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.initZipFile();
    }

    @Override
    public ZipDocumentCollection copy() {
        return new ZipDocumentCollection(this.zipFilename, this.underlyingFactory, this.numberOfDocuments, this.exact);
    }

    @Override
    public DocumentFactory factory() {
        return this.factory;
    }

    @Override
    public int size() {
        return this.numberOfDocuments;
    }

    private ZipEntry getEntry(int index) {
        this.ensureDocumentIndex(index);
        this.ensureZipFile();
        ZipEntry entry = this.zipFile.getEntry(Integer.toString(index));
        if (entry == null) {
            throw new NoSuchElementException("Failure retrieving entry " + index);
        }
        return entry;
    }

    @Override
    public Document document(int index) throws IOException {
        ZipEntry entry = this.getEntry(index);
        Reference2ObjectMap<Enum<?>, Object> metadata = this.metadata(index, entry);
        InputStream is = this.zipFile.getInputStream(entry);
        return this.factory.getDocument(is, metadata);
    }

    private Reference2ObjectMap<Enum<?>, Object> metadata(int index, ZipEntry entry) {
        if (entry == null) {
            entry = this.getEntry(index);
        }
        Reference2ObjectArrayMap metadata = new Reference2ObjectArrayMap(1);
        metadata.put((Object)PropertyBasedDocumentFactory.MetadataKeys.TITLE, (Object)entry.getComment());
        return metadata;
    }

    @Override
    public Reference2ObjectMap<Enum<?>, Object> metadata(int index) {
        return this.metadata(index, null);
    }

    @Override
    public InputStream stream(int index) throws IOException {
        ZipEntry entry = this.getEntry(index);
        entry.getComment();
        InputStream is = this.zipFile.getInputStream(entry);
        return is;
    }

    @Override
    public DocumentIterator iterator() {
        try {
            return new AbstractDocumentIterator(){
                final Reference2ObjectArrayMap<Enum<?>, Object> metadata = new Reference2ObjectArrayMap((Object[])new Enum[1], new Object[1]);
                ZipInputStream zis = new ZipInputStream(new FileInputStream(ZipDocumentCollection.access$100(ZipDocumentCollection.this).getName()));

                @Override
                public Document nextDocument() throws IOException {
                    ZipEntry entry;
                    String name;
                    do {
                        if ((entry = this.zis.getNextEntry()) != null) continue;
                        return null;
                    } while (!Character.isDigit((name = entry.getName()).charAt(0)));
                    String title = entry.getComment();
                    InputStream is = ZipDocumentCollection.this.zipFile.getInputStream(entry);
                    this.metadata.put((Object)PropertyBasedDocumentFactory.MetadataKeys.TITLE, (Object)title);
                    return ZipDocumentCollection.this.factory.getDocument(is, (Reference2ObjectMap<Enum<?>, Object>)this.metadata);
                }
            };
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() throws IOException {
        super.close();
        if (this.zipFile != null) {
            this.zipFile.close();
        }
    }

    protected static class ZipFactory
    extends AbstractDocumentFactory {
        private static final long serialVersionUID = 1L;
        private final boolean exact;
        private final DocumentFactory underlyingFactory;

        protected ZipFactory(DocumentFactory underlyingFactory, boolean exact) {
            this.underlyingFactory = underlyingFactory;
            this.exact = exact;
        }

        @Override
        public ZipFactory copy() {
            return this;
        }

        @Override
        public int numberOfFields() {
            return this.underlyingFactory.numberOfFields();
        }

        @Override
        public String fieldName(int field) {
            this.ensureFieldIndex(field);
            return this.underlyingFactory.fieldName(field);
        }

        @Override
        public int fieldIndex(String fieldName) {
            return this.underlyingFactory.fieldIndex(fieldName);
        }

        @Override
        public DocumentFactory.FieldType fieldType(int field) {
            this.ensureFieldIndex(field);
            return this.underlyingFactory.fieldType(field);
        }

        @Override
        public Document getDocument(final InputStream rawContent, final Reference2ObjectMap<Enum<?>, Object> metadata) throws IOException {
            return new AbstractDocument(){
                final DataInputStream rawContentDataInputStream;
                int nextFieldToRead;
                final MutableString uri;
                {
                    this.rawContentDataInputStream = new DataInputStream(rawContent);
                    this.nextFieldToRead = 0;
                    this.uri = new MutableString();
                    this.uri.readSelfDelimUTF8(rawContent).compact();
                }

                @Override
                public void close() throws IOException {
                    super.close();
                    rawContent.close();
                }

                @Override
                public CharSequence title() {
                    return (CharSequence)metadata.get((Object)PropertyBasedDocumentFactory.MetadataKeys.TITLE);
                }

                @Override
                public String toString() {
                    return ((Object)this.title()).toString();
                }

                @Override
                public CharSequence uri() {
                    return this.uri.length() == 0 ? null : this.uri;
                }

                private void skipOneField() throws IOException, ClassNotFoundException {
                    switch (ZipFactory.this.fieldType(this.nextFieldToRead)) {
                        case TEXT: {
                            MutableString word = new MutableString();
                            MutableString nonWord = new MutableString();
                            do {
                                word.readSelfDelimUTF8(rawContent);
                                if (!ZipFactory.this.exact) continue;
                                nonWord.readSelfDelimUTF8(rawContent);
                            } while (word.length() > 0 || ZipFactory.this.exact && nonWord.length() > 0);
                            break;
                        }
                        case VIRTUAL: {
                            int nfrag = this.rawContentDataInputStream.readInt();
                            for (int i = 0; i < 2 * nfrag; ++i) {
                                MutableString.skipSelfDelimUTF8((InputStream)rawContent);
                            }
                            break;
                        }
                        default: {
                            new ObjectInputStream(rawContent).readObject();
                        }
                    }
                    ++this.nextFieldToRead;
                }

                private void skipToField(int field) throws IOException, ClassNotFoundException {
                    if (this.nextFieldToRead > field) {
                        throw new IllegalStateException("Trying to skip to field " + field + " after " + this.nextFieldToRead);
                    }
                    while (this.nextFieldToRead < field) {
                        this.skipOneField();
                    }
                }

                @Override
                public Object content(final int field) {
                    ZipFactory.this.ensureFieldIndex(field);
                    Object result = null;
                    try {
                        this.skipToField(field);
                        if (ZipFactory.this.fieldType(this.nextFieldToRead) == DocumentFactory.FieldType.VIRTUAL) {
                            int nfrag = this.rawContentDataInputStream.readInt();
                            MutableString doc = new MutableString();
                            MutableString text = new MutableString();
                            Object[] fragArray = new Scan.VirtualDocumentFragment[nfrag];
                            for (int i = 0; i < nfrag; ++i) {
                                doc.readSelfDelimUTF8(rawContent);
                                text.readSelfDelimUTF8(rawContent);
                                fragArray[i] = new AnchorExtractor.Anchor(doc.copy(), text.copy());
                            }
                            result = new ObjectArrayList(fragArray);
                        } else if (ZipFactory.this.fieldType(this.nextFieldToRead) != DocumentFactory.FieldType.TEXT) {
                            result = new ObjectInputStream(rawContent).readObject();
                            ++this.nextFieldToRead;
                        } else {
                            result = new Reader(){
                                FastBufferedReader fbr = null;
                                int f = field;

                                @Override
                                public void close() {
                                }

                                @Override
                                public int read(char[] cbuf, int off, int len) throws IOException {
                                    if (this.fbr == null) {
                                        MutableString text = new MutableString();
                                        MutableString word = new MutableString();
                                        MutableString nonWord = new MutableString();
                                        do {
                                            text.append(word.readSelfDelimUTF8(rawContent));
                                            if (ZipFactory.this.exact) {
                                                text.append(nonWord.readSelfDelimUTF8(rawContent));
                                                continue;
                                            }
                                            text.append(' ');
                                        } while (word.length() > 0 || ZipFactory.this.exact && nonWord.length() > 0);
                                        this.fbr = new FastBufferedReader(text);
                                        ++nextFieldToRead;
                                    }
                                    return this.fbr.read(cbuf, off, len);
                                }
                            };
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    catch (ClassNotFoundException e) {
                        throw new RuntimeException(e);
                    }
                    return result;
                }

                @Override
                public WordReader wordReader(int field) {
                    ZipFactory.this.ensureFieldIndex(field);
                    try {
                        this.skipToField(field);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                    switch (ZipFactory.this.fieldType(field)) {
                        case TEXT: {
                            return new WordReader(){
                                private static final long serialVersionUID = 1L;

                                public boolean next(MutableString word, MutableString nonWord) throws IOException {
                                    boolean goOn;
                                    try {
                                        word.readSelfDelimUTF8(rawContent);
                                    }
                                    catch (EOFException e) {
                                        return false;
                                    }
                                    nonWord.length(0);
                                    if (ZipFactory.this.exact) {
                                        try {
                                            nonWord.readSelfDelimUTF8(rawContent);
                                        }
                                        catch (EOFException e) {
                                            return true;
                                        }
                                    } else {
                                        nonWord.append(' ');
                                    }
                                    boolean bl = goOn = word.length() != 0 || ZipFactory.this.exact && nonWord.length() != 0;
                                    if (!goOn) {
                                        ++nextFieldToRead;
                                    }
                                    return goOn;
                                }

                                public WordReader setReader(Reader reader) {
                                    return this;
                                }

                                public WordReader copy() {
                                    throw new UnsupportedOperationException();
                                }
                            };
                        }
                        case VIRTUAL: {
                            return new FastBufferedReader();
                        }
                    }
                    return null;
                }
            };
        }
    }

    public static enum PropertyKeys {
        COLLECTION;

    }
}

