/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.document.tika;

import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.io.FastBufferedReader;
import it.unimi.dsi.io.WordReader;
import it.unimi.dsi.lang.ObjectParser;
import it.unimi.dsi.mg4j.document.AbstractDocument;
import it.unimi.dsi.mg4j.document.Document;
import it.unimi.dsi.mg4j.document.DocumentFactory;
import it.unimi.dsi.mg4j.document.PropertyBasedDocumentFactory;
import it.unimi.dsi.mg4j.document.tika.AbstractTikaDocumentFactory;
import it.unimi.dsi.mg4j.document.tika.TikaField;
import it.unimi.dsi.mg4j.util.MG4JClassParser;
import it.unimi.dsi.util.Properties;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.ParsingReader;

public abstract class AbstractSimpleTikaDocumentFactory
extends AbstractTikaDocumentFactory {
    private static final long serialVersionUID = 1L;
    private List<TikaField> fields;
    private WordReader wordReader;

    public AbstractSimpleTikaDocumentFactory() {
        this.init();
    }

    public AbstractSimpleTikaDocumentFactory(Reference2ObjectMap<Enum<?>, Object> defaultMetadata) {
        super(defaultMetadata);
        this.init();
    }

    public AbstractSimpleTikaDocumentFactory(Properties properties) throws ConfigurationException {
        super(properties);
        this.init();
    }

    public AbstractSimpleTikaDocumentFactory(String[] property) throws ConfigurationException {
        super(property);
        this.init();
    }

    private void init() {
        try {
            Object o = this.defaultMetadata.get((Object)PropertyBasedDocumentFactory.MetadataKeys.WORDREADER);
            this.wordReader = o == null ? new FastBufferedReader() : (WordReader)ObjectParser.fromSpec((String)o.toString(), WordReader.class, (String[])MG4JClassParser.PACKAGE);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected boolean parseProperty(String key, String[] values, Reference2ObjectMap<Enum<?>, Object> metadata) throws ConfigurationException {
        if (AbstractSimpleTikaDocumentFactory.sameKey(PropertyBasedDocumentFactory.MetadataKeys.WORDREADER, key)) {
            try {
                String spec = AbstractSimpleTikaDocumentFactory.ensureJustOne(key, values).toString();
                metadata.put((Object)PropertyBasedDocumentFactory.MetadataKeys.WORDREADER, (Object)spec);
                ObjectParser.fromSpec((String)spec, WordReader.class, (String[])MG4JClassParser.PACKAGE);
            }
            catch (ClassNotFoundException e) {
                throw new ConfigurationException((Throwable)e);
            }
            catch (Exception e) {
                throw new ConfigurationException((Throwable)e);
            }
            return true;
        }
        return super.parseProperty(key, values, metadata);
    }

    @Override
    protected List<TikaField> fields() {
        if (this.fields == null) {
            this.fields = new ArrayList<TikaField>();
            this.fields.add(new TikaField());
            this.fields.addAll(this.metadataFields());
        }
        return this.fields;
    }

    @Override
    public Document getDocument(final InputStream rawContent, final Reference2ObjectMap<Enum<?>, Object> metadata) throws IOException {
        return new AbstractDocument(){
            private ParsingReader parsingReader;
            private Metadata tikaMetadata;

            @Override
            public CharSequence title() {
                return (CharSequence)AbstractSimpleTikaDocumentFactory.this.resolve(PropertyBasedDocumentFactory.MetadataKeys.TITLE, metadata);
            }

            @Override
            public CharSequence uri() {
                return (CharSequence)AbstractSimpleTikaDocumentFactory.this.resolve(PropertyBasedDocumentFactory.MetadataKeys.URI, metadata);
            }

            @Override
            public Object content(int field) throws IOException {
                AbstractSimpleTikaDocumentFactory.this.ensureFieldIndex(field);
                if (this.parsingReader == null && this.tikaMetadata == null) {
                    this.tikaMetadata = new Metadata();
                    if (this.uri() != null) {
                        this.tikaMetadata.set("resourceName", ((Object)this.uri()).toString());
                    }
                    this.parsingReader = new ParsingReader(AbstractSimpleTikaDocumentFactory.this.getParser(), rawContent, this.tikaMetadata, new ParseContext());
                }
                if (AbstractSimpleTikaDocumentFactory.this.fields().get(field).isBody()) {
                    return this.parsingReader;
                }
                String text = AbstractSimpleTikaDocumentFactory.this.fields().get(field).contentFromMetadata(this.tikaMetadata);
                return text == null ? new FastBufferedReader((Reader)new StringReader("")) : new FastBufferedReader((Reader)new StringReader(text));
            }

            @Override
            public void close() throws IOException {
                super.close();
                if (this.parsingReader != null) {
                    this.parsingReader.close();
                    this.parsingReader = null;
                }
            }

            @Override
            public WordReader wordReader(int field) {
                AbstractSimpleTikaDocumentFactory.this.ensureFieldIndex(field);
                return AbstractSimpleTikaDocumentFactory.this.wordReader;
            }
        };
    }

    protected List<? extends TikaField> metadataFields() {
        return Collections.emptyList();
    }

    protected abstract Parser getParser();

    @Override
    public DocumentFactory copy() {
        return this;
    }
}

