/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.graph;

import it.unimi.dsi.fastutil.ints.IntAVLTreeSet;
import it.unimi.dsi.fastutil.ints.IntSortedSet;
import it.unimi.dsi.fastutil.io.BinIO;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import it.unimi.dsi.mg4j.document.Document;
import it.unimi.dsi.mg4j.document.DocumentIterator;
import it.unimi.dsi.mg4j.document.DocumentSequence;
import it.unimi.dsi.mg4j.tool.Scan;
import it.unimi.dsi.mg4j.tool.VirtualDocumentResolver;
import it.unimi.dsi.webgraph.ImmutableGraph;
import it.unimi.dsi.webgraph.ImmutableSequentialGraph;
import it.unimi.dsi.webgraph.NodeIterator;
import java.io.IOException;
import java.util.NoSuchElementException;

public class DocumentSequenceImmutableGraph
extends ImmutableSequentialGraph {
    private DocumentSequence sequence;
    private int virtualField;
    private VirtualDocumentResolver resolver;

    public DocumentSequenceImmutableGraph(DocumentSequence sequence, int virtualField, VirtualDocumentResolver resolver) {
        this.sequence = sequence;
        this.virtualField = virtualField;
        this.resolver = resolver;
    }

    public DocumentSequenceImmutableGraph(String ... arg) throws IOException, ClassNotFoundException {
        this((DocumentSequence)BinIO.loadObject((CharSequence)arg[0]), Integer.parseInt(arg[1]), (VirtualDocumentResolver)BinIO.loadObject((CharSequence)arg[2]));
    }

    public ImmutableGraph copy() {
        throw new UnsupportedOperationException();
    }

    public int numNodes() {
        if (this.resolver.numberOfDocuments() > Integer.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.resolver.numberOfDocuments();
    }

    public boolean randomAccess() {
        return false;
    }

    public NodeIterator nodeIterator() {
        try {
            final DocumentIterator documentIterator = this.sequence.iterator();
            return new NodeIterator(){
                Document cachedDocument;
                int cachedDocumentNumber;
                int[] cachedSuccessors;
                IntSortedSet succ;
                {
                    this.cachedDocument = documentIterator.nextDocument();
                    this.cachedDocumentNumber = 0;
                    this.succ = new IntAVLTreeSet();
                }

                public boolean hasNext() {
                    return this.cachedDocument != null;
                }

                public int nextInt() {
                    ObjectList vdf;
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    try {
                        vdf = (ObjectList)this.cachedDocument.content(DocumentSequenceImmutableGraph.this.virtualField);
                    }
                    catch (IOException exc1) {
                        throw new RuntimeException(exc1);
                    }
                    this.succ.clear();
                    DocumentSequenceImmutableGraph.this.resolver.context(this.cachedDocument);
                    ObjectListIterator it = vdf.iterator();
                    while (it.hasNext()) {
                        int successor = DocumentSequenceImmutableGraph.this.resolver.resolve((CharSequence)((Scan.VirtualDocumentFragment)it.next()).documentSpecifier());
                        if (successor < 0) continue;
                        this.succ.add(successor);
                    }
                    this.cachedSuccessors = this.succ.toIntArray();
                    try {
                        this.cachedDocument.close();
                        this.cachedDocument = documentIterator.nextDocument();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    return this.cachedDocumentNumber++;
                }

                public int outdegree() {
                    return this.cachedSuccessors.length;
                }

                public int[] successorArray() {
                    return this.cachedSuccessors;
                }
            };
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

