/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.index;

import it.unimi.dsi.Util;
import it.unimi.dsi.bits.Fast;
import it.unimi.dsi.fastutil.ints.Int2IntRBTreeMap;
import it.unimi.dsi.fastutil.io.FastBufferedInputStream;
import it.unimi.dsi.fastutil.io.FastByteArrayOutputStream;
import it.unimi.dsi.io.NullOutputStream;
import it.unimi.dsi.io.OutputBitStream;
import it.unimi.dsi.lang.MutableString;
import it.unimi.dsi.mg4j.index.AbstractBitStreamIndexWriter;
import it.unimi.dsi.mg4j.index.BitStreamIndex;
import it.unimi.dsi.mg4j.index.CachingOutputBitStream;
import it.unimi.dsi.mg4j.index.CompressionFlags;
import it.unimi.dsi.mg4j.index.FileHPIndex;
import it.unimi.dsi.mg4j.index.Index;
import it.unimi.dsi.mg4j.index.VariableQuantumIndexWriter;
import it.unimi.dsi.mg4j.index.payload.Payload;
import it.unimi.dsi.util.Properties;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Map;

public class BitStreamHPIndexWriter
extends AbstractBitStreamIndexWriter
implements VariableQuantumIndexWriter {
    private static final boolean ASSERTS = false;
    private static final boolean DEBUG = false;
    private static final boolean SKIP_STATS = false;
    private static final boolean COOKIES = false;
    public static final int DEFAULT_TEMP_BUFFER_SIZE = 0x2000000;
    protected static final int BEFORE_INVERTED_LIST = 0;
    protected static final int BEFORE_FREQUENCY = 1;
    protected static final int BEFORE_DOCUMENT_RECORD = 2;
    protected static final int BEFORE_POINTER = 3;
    protected static final int BEFORE_PAYLOAD = 4;
    protected static final int BEFORE_COUNT = 5;
    protected static final int BEFORE_POSITIONS = 6;
    protected static final int FIRST_UNUSED_STATE = 7;
    protected OutputBitStream obs;
    protected OutputBitStream positions;
    private OutputBitStream offsets;
    protected int state;
    protected int frequency;
    protected int writtenDocuments;
    protected int currentDocument;
    protected int lastDocument;
    private long lastInvertedListPos;
    private long lastPositionsOffset;
    protected int b;
    protected int log2b;
    public int maxCount;
    public long bitsForPositionsOffsets;
    private static final int MAX_TRY = 32;
    private boolean variableQuanta;
    private final int height;
    private int quantum;
    private int quantumModuloMask;
    private int quantumDivisionShift;
    private long w;
    private int cache;
    private final int[] skipPointer;
    private final OutputBitStream[] cachePointer;
    private final FastByteArrayOutputStream[] cachePointerByte;
    private final OutputBitStream[] cacheSkip;
    private final OutputBitStream[] cacheSkipBitCount;
    private final FastByteArrayOutputStream[] cacheSkipByte;
    private final CachingOutputBitStream cacheDataOut;
    private final FastBufferedInputStream cacheDataIn;
    private final int[] cacheDataLength;
    private final long[] cachePositionsLength;
    private OutputBitStream posNumBits;
    private final OutputBitStream bitCount;
    public final TowerData towerData;
    private long writtenPositionsBitsAtLastQuantum;
    public long bitsForVariableQuanta;
    public long bitsForQuantumBitLengths;
    public long bitsForPositionsQuantumBitLengths;
    public long bitsForEntryBitLengths;
    private long bitsForListsWithTowers;
    public long numberOfBlocks;
    public int prevEntryBitLength;
    public int prevQuantumBitLength;
    public int prevPositionsQuantumBitLength;
    private final int[] towerTopB;
    private final int[] towerTopLog2B;
    private final int[] towerLowerB;
    private final int[] towerLowerLog2B;
    private final int[] pointerPrediction;
    private final long[] distance;
    private final File tempFile;
    private TowerData temp;
    private long lastBitsForPositionsOffsets;

    public BitStreamHPIndexWriter(CharSequence basename, int numberOfDocuments, boolean writeOffsets, int tempBufferSize, Map<CompressionFlags.Component, CompressionFlags.Coding> flags, int quantum, int height) throws IOException {
        this(new OutputBitStream(basename + ".index"), new OutputBitStream(basename + ".positions"), writeOffsets ? new OutputBitStream(basename + ".offsets") : null, writeOffsets ? new OutputBitStream(basename + ".posnumbits") : null, numberOfDocuments, tempBufferSize, flags, quantum, height);
    }

    public BitStreamHPIndexWriter(OutputBitStream obs, OutputBitStream positions, OutputBitStream offsets, OutputBitStream posNumBits, int numberOfDocuments, int tempBufferSize, Map<CompressionFlags.Component, CompressionFlags.Coding> flags, int quantum, int height) throws IOException {
        super(numberOfDocuments, flags);
        int i;
        this.obs = obs;
        this.positions = positions;
        this.offsets = offsets;
        this.posNumBits = posNumBits;
        this.frequency = -1;
        this.currentTerm = -1;
        this.maxCount = 0;
        if (!this.hasCounts || !this.hasPositions) {
            throw new IllegalArgumentException("High-performance indices contain necessarily counts and positions; plase use an interleaved index if you do not need to store them.");
        }
        if (height < 0) {
            throw new IllegalArgumentException("Illegal height " + height);
        }
        if (quantum < 0 || (quantum & -quantum) != quantum) {
            throw new IllegalArgumentException("Illegal quantum " + quantum);
        }
        this.height = height;
        int two2h = 1 << height;
        this.variableQuanta = quantum == 0;
        if (!this.variableQuanta) {
            this.quantum = quantum;
        }
        this.quantumDivisionShift = Fast.mostSignificantBit((int)quantum);
        this.quantumModuloMask = quantum - 1;
        this.towerData = new TowerData();
        this.tempFile = File.createTempFile("MG4J", ".data");
        this.tempFile.deleteOnExit();
        this.cacheDataIn = new FastBufferedInputStream((InputStream)new FileInputStream(this.tempFile));
        this.cacheDataOut = new CachingOutputBitStream(this.tempFile, tempBufferSize);
        this.cacheDataLength = new int[two2h];
        this.cachePositionsLength = new long[two2h + 1];
        this.cachePointer = new OutputBitStream[two2h];
        this.cachePointerByte = new FastByteArrayOutputStream[two2h];
        for (i = 0; i < two2h; ++i) {
            this.cachePointerByte[i] = new FastByteArrayOutputStream();
            this.cachePointer[i] = new OutputBitStream((OutputStream)this.cachePointerByte[i], 0);
        }
        this.cacheSkip = new OutputBitStream[two2h];
        this.cacheSkipBitCount = new OutputBitStream[two2h];
        this.cacheSkipByte = new FastByteArrayOutputStream[two2h];
        for (i = 0; i < two2h; ++i) {
            this.cacheSkipByte[i] = new FastByteArrayOutputStream();
            this.cacheSkip[i] = new OutputBitStream((OutputStream)this.cacheSkipByte[i], 0);
            this.cacheSkipBitCount[i] = new OutputBitStream((OutputStream)NullOutputStream.getInstance(), 0);
        }
        this.skipPointer = new int[two2h + 1];
        this.distance = new long[two2h + 1];
        this.bitCount = new OutputBitStream((OutputStream)NullOutputStream.getInstance(), 0);
        this.towerTopB = new int[height + 1];
        this.towerTopLog2B = new int[height + 1];
        this.towerLowerB = new int[height + 1];
        this.towerLowerLog2B = new int[height + 1];
        this.pointerPrediction = new int[height + 1];
    }

    private int writeOutPointer(OutputBitStream out, int pointer) throws IOException {
        if (this.frequency == this.numberOfDocuments) {
            return 0;
        }
        switch (this.pointerCoding) {
            case UNARY: {
                return out.writeUnary(pointer - this.lastDocument - 1);
            }
            case SHIFTED_GAMMA: {
                return out.writeShiftedGamma(pointer - this.lastDocument - 1);
            }
            case GAMMA: {
                return out.writeGamma(pointer - this.lastDocument - 1);
            }
            case DELTA: {
                return out.writeDelta(pointer - this.lastDocument - 1);
            }
            case GOLOMB: {
                return out.writeGolomb(pointer - this.lastDocument - 1, this.b, this.log2b);
            }
        }
        throw new IllegalStateException("The required pointer coding (" + (Object)((Object)this.pointerCoding) + ") is not supported.");
    }

    private static int log2Quantum(long predictedFrequency, long numberOfDocuments, double fraction, long predictedSize, long predictedPositionsSize) {
        if (predictedFrequency < 2L) {
            return -1;
        }
        int bestLog2q = -1;
        double log2PredictedPositionsSize = Fast.log2((double)predictedPositionsSize);
        double log2PredictedFrequency = Fast.log2((double)predictedFrequency);
        double p = (double)predictedFrequency / (double)numberOfDocuments;
        double entropy = (-p * Math.log(p) - (1.0 - p) * Math.log(1.0 - p)) / (p * 0.6931471805599453);
        int log2q = 11;
        while (log2q-- != 0) {
            int quantum = 1 << log2q;
            double numberOfEntries = (double)predictedFrequency / (double)quantum;
            if (!(numberOfEntries > 1.0)) continue;
            double d = p >= 1.0 ? 0.0 : entropy + (double)log2q / 2.0 + 1.0;
            double d2 = predictedPositionsSize == 0L ? 0.0 : 2.0 * (log2PredictedPositionsSize + (double)log2q / 2.0 + Fast.log2((double)(log2q + 1)) - log2PredictedFrequency);
            double cost = numberOfEntries * (d + d2 + 24.0);
            double costFraction = cost / (double)(predictedSize + predictedPositionsSize);
            if (!(costFraction < fraction)) continue;
            bestLog2q = log2q;
        }
        return bestLog2q <= 0 || (long)(1 << bestLog2q - 1) > predictedFrequency ? bestLog2q : bestLog2q - 1;
    }

    @Override
    public long newInvertedList() throws IOException {
        if (this.variableQuanta) {
            throw new IllegalStateException("This index writer needs a specific quantum for each inverted list");
        }
        return this.newInvertedList(Fast.mostSignificantBit((int)this.quantum));
    }

    @Override
    public long newInvertedList(long predictedFrequency, double fraction, long predictedSize, long predictedPositionsSize) throws IOException {
        return this.newInvertedList(BitStreamHPIndexWriter.log2Quantum(predictedFrequency, this.numberOfDocuments, fraction, predictedSize, predictedPositionsSize));
    }

    private long newInvertedList(int log2q) throws IOException {
        if (this.cache != 0) {
            this.writeOutCache(-1);
        }
        if (this.frequency >= 0 && this.frequency != this.writtenDocuments) {
            throw new IllegalStateException("The number of document records (" + this.writtenDocuments + ") does not match the frequency (" + this.frequency + ")");
        }
        if (this.state != 0 && this.state != 2) {
            throw new IllegalStateException("Trying to start new inverted list in state " + this.state);
        }
        long pos = this.obs.writtenBits();
        if (this.currentTerm >= 0 && this.frequency >= this.quantum) {
            this.bitsForListsWithTowers += pos - this.lastInvertedListPos + (this.positions.writtenBits() - this.lastPositionsOffset);
        }
        if (this.offsets != null) {
            this.offsets.writeLongGamma(pos - this.lastInvertedListPos);
        }
        if (this.posNumBits != null && this.currentTerm >= 0) {
            this.posNumBits.writeLongGamma(this.positions.writtenBits() - this.lastPositionsOffset);
        }
        this.quantum = log2q < 0 ? 0 : 1 << log2q;
        this.writtenDocuments = 0;
        ++this.currentTerm;
        this.currentDocument = -1;
        this.lastBitsForPositionsOffsets = this.obs.writeLongDelta(this.positions.writtenBits());
        this.bitsForPositionsOffsets += this.lastBitsForPositionsOffsets;
        this.lastInvertedListPos = pos;
        this.lastPositionsOffset = this.positions.writtenBits();
        this.state = 1;
        return pos;
    }

    @Override
    public int writeFrequency(int frequency) throws IOException {
        int bitCount;
        if (this.state != 1) {
            throw new IllegalStateException("Trying to write frequency in state " + this.state);
        }
        switch (this.frequencyCoding) {
            case SHIFTED_GAMMA: {
                bitCount = this.obs.writeShiftedGamma(frequency - 1);
                break;
            }
            case GAMMA: {
                bitCount = this.obs.writeGamma(frequency - 1);
                break;
            }
            case DELTA: {
                bitCount = this.obs.writeDelta(frequency - 1);
                break;
            }
            default: {
                throw new IllegalStateException("The required frequency coding (" + (Object)((Object)this.frequencyCoding) + ") is not supported.");
            }
        }
        this.frequency = frequency;
        if (this.pointerCoding == CompressionFlags.Coding.GOLOMB) {
            this.b = BitStreamIndex.golombModulus(frequency, this.numberOfDocuments);
            this.log2b = Fast.mostSignificantBit((int)this.b);
        }
        this.prevPositionsQuantumBitLength = -1;
        this.prevEntryBitLength = -1;
        this.prevQuantumBitLength = -1;
        if (this.variableQuanta && frequency > 1) {
            this.bitsForVariableQuanta += (long)this.obs.writeGamma(Fast.mostSignificantBit((int)this.quantum) + 1);
        }
        if (this.quantum == 0) {
            this.quantum = 1 << Fast.ceilLog2((int)frequency) + 1;
        }
        this.w = (1L << this.height) * (long)this.quantum;
        this.quantumDivisionShift = Fast.mostSignificantBit((int)this.quantum);
        this.quantumModuloMask = this.quantum - 1;
        long pointerQuantumSigma = BitStreamIndex.quantumSigma(frequency, this.numberOfDocuments, this.quantum);
        for (int i = Math.min(this.height, Fast.mostSignificantBit((int)(frequency >>> this.quantumDivisionShift))); i >= 0; --i) {
            this.towerTopB[i] = BitStreamIndex.gaussianGolombModulus(pointerQuantumSigma, i + 1);
            this.towerTopLog2B[i] = Fast.mostSignificantBit((int)this.towerTopB[i]);
            this.towerLowerB[i] = BitStreamIndex.gaussianGolombModulus(pointerQuantumSigma, i);
            this.towerLowerLog2B[i] = Fast.mostSignificantBit((int)this.towerLowerB[i]);
            this.pointerPrediction[i] = (int)(((long)this.quantum * (1L << i) * (long)this.numberOfDocuments + (long)(frequency / 2)) / (long)frequency);
        }
        this.state = 2;
        this.bitsForFrequencies += (long)bitCount;
        return bitCount;
    }

    @Override
    public OutputBitStream newDocumentRecord() throws IOException {
        if (this.frequency == this.writtenDocuments) {
            throw new IllegalStateException("Document record overflow (written " + this.frequency + " already)");
        }
        if (this.state != 2) {
            throw new IllegalStateException("Trying to start new document record in state " + this.state);
        }
        ++this.writtenDocuments;
        ++this.numberOfPostings;
        this.lastDocument = this.currentDocument;
        this.state = 3;
        return this.cacheDataOut;
    }

    @Override
    public int writeDocumentPointer(OutputBitStream unused, int pointer) throws IOException {
        int bitCount;
        block14: {
            block13: {
                CachingOutputBitStream out;
                if (this.state != 3) {
                    throw new IllegalStateException("Trying to write pointer in state " + this.state);
                }
                if ((long)this.cache == this.w) {
                    this.writeOutCache(pointer);
                }
                if ((this.cache & this.quantumModuloMask) == 0) {
                    if (this.cache >>> this.quantumDivisionShift > 0) {
                        this.cacheDataLength[(this.cache >>> this.quantumDivisionShift) - 1] = (int)this.cacheDataOut.writtenBits();
                        this.cachePositionsLength[(this.cache >>> this.quantumDivisionShift) - 1] = (int)(this.positions.writtenBits() - this.writtenPositionsBitsAtLastQuantum);
                        this.writtenPositionsBitsAtLastQuantum = this.positions.writtenBits();
                    }
                    this.cacheDataOut.align();
                    this.cacheDataOut.writtenBits(0L);
                    this.skipPointer[this.cache >>> this.quantumDivisionShift] = pointer;
                    out = this.cachePointer[this.cache++ >>> this.quantumDivisionShift];
                } else {
                    ++this.cache;
                    out = this.cacheDataOut;
                }
                this.currentDocument = pointer;
                bitCount = 0;
                if (this.frequency == this.numberOfDocuments) break block13;
                switch (this.pointerCoding) {
                    case UNARY: {
                        bitCount = out.writeUnary(pointer - this.lastDocument - 1);
                        break block14;
                    }
                    case SHIFTED_GAMMA: {
                        bitCount = out.writeShiftedGamma(pointer - this.lastDocument - 1);
                        break block14;
                    }
                    case GAMMA: {
                        bitCount = out.writeGamma(pointer - this.lastDocument - 1);
                        break block14;
                    }
                    case DELTA: {
                        bitCount = out.writeDelta(pointer - this.lastDocument - 1);
                        break block14;
                    }
                    case GOLOMB: {
                        bitCount = out.writeGolomb(pointer - this.lastDocument - 1, this.b, this.log2b);
                        break block14;
                    }
                    default: {
                        throw new IllegalStateException("The required pointer coding (" + (Object)((Object)this.pointerCoding) + ") is not supported.");
                    }
                }
            }
            if (pointer - this.lastDocument != 1) {
                throw new IllegalStateException("Term " + this.currentTerm + " has frequency equal to the number of documents, but pointers are not consecutive integers");
            }
        }
        this.state = this.hasPayloads ? 4 : (this.hasCounts ? 5 : 2);
        this.bitsForPointers += (long)bitCount;
        return bitCount;
    }

    @Override
    public int writePayload(OutputBitStream out, Payload payload) throws IOException {
        throw new IllegalStateException("High-performance indices do not support payloads");
    }

    @Override
    public int writePositionCount(OutputBitStream out, int count) throws IOException {
        int bitCount;
        if (this.frequency < 0) {
            throw new IllegalStateException("Trying to write count without calling newInvertedList");
        }
        if (this.state != 5) {
            throw new IllegalStateException("Trying to write count in state " + this.state);
        }
        this.numberOfOccurrences += (long)count;
        switch (this.countCoding) {
            case SHIFTED_GAMMA: {
                bitCount = out.writeShiftedGamma(count - 1);
                break;
            }
            case GAMMA: {
                bitCount = out.writeGamma(count - 1);
                break;
            }
            case UNARY: {
                bitCount = out.writeUnary(count - 1);
                break;
            }
            case DELTA: {
                bitCount = out.writeDelta(count - 1);
                break;
            }
            default: {
                throw new IllegalStateException("The required count coding (" + (Object)((Object)this.countCoding) + ") is not supported.");
            }
        }
        this.state = this.hasPositions ? 6 : 2;
        this.bitsForCounts += (long)bitCount;
        return bitCount;
    }

    @Override
    public int writeDocumentPositions(OutputBitStream unused, int[] occ, int offset, int len, int docSize) throws IOException {
        if (this.frequency < 0) {
            throw new IllegalStateException("Trying to write occurrences without calling newInvertedList");
        }
        if (this.state != 6) {
            throw new IllegalStateException("Trying to write positions in state " + this.state);
        }
        int prev = -1;
        int bitCount = 0;
        int end = offset + len;
        OutputBitStream positions = this.positions;
        switch (this.positionCoding) {
            case GAMMA: {
                for (int i = offset; i < end; ++i) {
                    bitCount += positions.writeGamma(occ[i] - prev - 1);
                    prev = occ[i];
                }
                break;
            }
            case DELTA: {
                for (int i = offset; i < end; ++i) {
                    bitCount += positions.writeDelta(occ[i] - prev - 1);
                    prev = occ[i];
                }
                break;
            }
            case SHIFTED_GAMMA: {
                for (int i = offset; i < end; ++i) {
                    bitCount += positions.writeShiftedGamma(occ[i] - prev - 1);
                    prev = occ[i];
                }
                break;
            }
            default: {
                throw new IllegalStateException("The required position coding (" + (Object)((Object)this.positionCoding) + ") is not supported.");
            }
        }
        this.state = 2;
        this.bitsForPositions += (long)bitCount;
        if (len > this.maxCount) {
            this.maxCount = len;
        }
        return bitCount;
    }

    @Override
    public void close() throws IOException {
        if (this.cache != 0) {
            this.writeOutCache(-1);
        }
        if (this.state != 2 && this.state != 0) {
            throw new IllegalStateException("Trying to close index in state " + this.state);
        }
        if (this.frequency >= 0 && this.frequency != this.writtenDocuments) {
            throw new IllegalStateException("The number of document records (" + this.writtenDocuments + ") does not match the frequency (" + this.frequency + ")");
        }
        if (this.writtenBits() != this.obs.writtenBits() + this.positions.writtenBits()) {
            throw new IllegalStateException("Written bits count mismatch: we say " + this.writtenBits() + ", the streams say " + (this.obs.writtenBits() + this.positions.writtenBits()));
        }
        this.bitsForListsWithTowers += this.obs.writtenBits() - this.lastInvertedListPos + (this.positions.writtenBits() - this.lastPositionsOffset);
        if (this.offsets != null) {
            this.offsets.writeLongGamma(this.obs.writtenBits() - this.lastInvertedListPos);
            this.offsets.close();
        }
        if (this.posNumBits != null) {
            this.posNumBits.writeLongGamma(this.positions.writtenBits() - this.lastPositionsOffset);
            this.posNumBits.close();
        }
        this.obs.close();
        this.positions.close();
        this.cacheDataIn.close();
        this.cacheDataOut.close();
        this.tempFile.delete();
    }

    private void tryTower(int quantumBitLength, int positionsQuantumBitLength, int entryBitLength, long toTheEnd, OutputBitStream[] skip, TowerData towerData, boolean doinIt) throws IOException {
        boolean truncated = false;
        for (int k = this.cache - 1 >>> this.quantumDivisionShift; k >= 0; --k) {
            int s;
            toTheEnd += (long)this.cacheDataLength[k];
            int n = s = k == 0 ? this.height : Fast.leastSignificantBit((long)k);
            if ((long)this.cache < this.w) {
                int upperBound = Fast.mostSignificantBit((int)((this.cache >>> this.quantumDivisionShift) - k));
                if (s > upperBound) {
                    s = upperBound;
                    truncated = true;
                } else {
                    truncated = false;
                }
            } else {
                truncated = k == 0;
            }
            skip[k].writtenBits(0L);
            if (s >= 0) {
                int basePointer = this.skipPointer[k];
                if (truncated) {
                    ++towerData.numberOfTopEntries;
                    towerData.bitsForTopSkipPointers += (long)skip[k].writeGolomb(Fast.int2nat((int)(this.skipPointer[k + (1 << s)] - basePointer - this.pointerPrediction[s])), this.towerTopB[s], this.towerTopLog2B[s]);
                    towerData.bitsForTopBitSkips += (long)skip[k].writeLongDelta((long)Fast.int2nat((int)((int)(toTheEnd - this.distance[k + (1 << s)] - (long)(quantumBitLength * (1 << s) + entryBitLength * ((1 << s + 1) - s - 2))))));
                    towerData.bitsForTopPositionsBitSkips += (long)skip[k].writeLongDelta(Fast.int2nat((long)(this.cachePositionsLength[k] - this.cachePositionsLength[k + (1 << s)] - (long)(positionsQuantumBitLength * (1 << s)))));
                }
                for (int i = s - 1; i >= 0; --i) {
                    towerData.bitsForLowerSkipPointers += (long)skip[k].writeGolomb(Fast.int2nat((int)(this.skipPointer[k + (1 << i)] - basePointer - (this.skipPointer[k + (1 << i + 1)] - basePointer) / 2)), this.towerLowerB[i], this.towerLowerLog2B[i]);
                    towerData.bitsForLowerBitSkips += (long)skip[k].writeLongDelta((long)Fast.int2nat((int)((int)((toTheEnd - this.distance[k + (1 << i + 1)] - (long)(entryBitLength * (i + 1))) / 2L - (toTheEnd - this.distance[k + (1 << i)])))));
                    towerData.bitsForLowerPositionsBitSkips += (long)skip[k].writeLongDelta(Fast.int2nat((long)((this.cachePositionsLength[k] - this.cachePositionsLength[k + (1 << i + 1)]) / 2L - (this.cachePositionsLength[k] - this.cachePositionsLength[k + (1 << i)]))));
                }
                if (s > 0) {
                    long d = this.bitCount.writeDelta(Fast.int2nat((int)((int)skip[k].writtenBits() - (s + 1) * entryBitLength)));
                    towerData.bitsForTowerLengths += d;
                    toTheEnd += d;
                }
                toTheEnd += skip[k].writtenBits();
                towerData.numberOfLowerEntries += (long)s;
                ++towerData.numberOfSkipTowers;
            }
            this.distance[k] = toTheEnd;
            toTheEnd += this.cachePointer[k].writtenBits();
        }
    }

    private void writeOutCache(int nextPointer) throws IOException {
        boolean direct;
        byte[] buffer;
        int k;
        long toTheEnd;
        this.cacheDataLength[(this.cache + this.quantum - 1 >>> this.quantumDivisionShift) - 1] = (int)this.cacheDataOut.writtenBits();
        this.cachePositionsLength[(this.cache + this.quantum - 1 >>> this.quantumDivisionShift) - 1] = (int)(this.positions.writtenBits() - this.writtenPositionsBitsAtLastQuantum);
        this.cachePositionsLength[this.cache + this.quantum - 1 >>> this.quantumDivisionShift] = 0L;
        this.writtenPositionsBitsAtLastQuantum = this.positions.writtenBits();
        int i = this.cache + this.quantum - 1 >>> this.quantumDivisionShift;
        while (i-- != 0) {
            int n = i;
            this.cachePositionsLength[n] = this.cachePositionsLength[n] + this.cachePositionsLength[i + 1];
        }
        int nextAfter = this.cache + this.quantum - 1 >>> this.quantumDivisionShift;
        if (nextPointer >= 0) {
            this.skipPointer[nextAfter] = nextPointer;
            toTheEnd = this.writeOutPointer(this.bitCount, nextPointer);
        } else {
            this.skipPointer[nextAfter] = this.currentDocument + 1;
            toTheEnd = 0L;
        }
        this.distance[nextAfter] = 0L;
        int quantumBitLength = 0;
        int entryBitLength = 0;
        int positionsQuantumBitLength = (int)((this.cachePositionsLength[0] * (long)this.quantum + (long)(this.cache - 1)) / (long)this.cache);
        long d = 0;
        for (k = 0; k <= this.cache - 1 >>> this.quantumDivisionShift; ++k) {
            d += this.cachePointer[k].writtenBits() + (long)this.cacheDataLength[k];
        }
        quantumBitLength = (int)((d * (long)this.quantum + (long)(this.cache - 1)) / (long)this.cache);
        TowerData td = new TowerData();
        Int2IntRBTreeMap candidates = new Int2IntRBTreeMap();
        this.tryTower(quantumBitLength, positionsQuantumBitLength, 0, toTheEnd, this.cacheSkipBitCount, td, false);
        if (td.numberOfSkipTowers > 0L) {
            while (candidates.size() < 32 && !candidates.containsValue(entryBitLength = (int)(td.bitsForTowers() / td.numberOfEntries()))) {
                td.clear();
                this.tryTower(quantumBitLength, positionsQuantumBitLength, entryBitLength, toTheEnd, this.cacheSkipBitCount, td, false);
                candidates.put((int)(td.bitsForTowers() / td.numberOfEntries()), entryBitLength);
            }
            entryBitLength = candidates.get(candidates.firstIntKey());
            this.tryTower(quantumBitLength, positionsQuantumBitLength, entryBitLength, toTheEnd, this.cacheSkip, this.towerData, true);
        }
        int maxCacheDataLength = 0;
        for (k = 0; k <= this.cache - 1 >>> this.quantumDivisionShift; ++k) {
            if (this.cacheDataLength[k] <= maxCacheDataLength) continue;
            maxCacheDataLength = this.cacheDataLength[k];
        }
        int pos = 0;
        this.cacheDataOut.align();
        if (this.cacheDataOut.buffer() != null) {
            buffer = this.cacheDataOut.buffer();
            direct = true;
        } else {
            this.cacheDataOut.flush();
            buffer = new byte[(maxCacheDataLength + 7) / 8];
            direct = false;
            this.cacheDataIn.flush();
            this.cacheDataIn.position(0L);
        }
        for (k = 0; k <= this.cache - 1 >>> this.quantumDivisionShift; ++k) {
            int s;
            int n = s = k == 0 ? this.height : Fast.leastSignificantBit((long)k);
            if ((long)this.cache < this.w) {
                s = Math.min(s, Fast.mostSignificantBit((int)((this.cache >>> this.quantumDivisionShift) - k)));
            }
            d = this.cachePointer[k].writtenBits();
            this.cachePointer[k].flush();
            this.obs.write(this.cachePointerByte[k].array, d);
            d = this.cacheSkip[k].writtenBits();
            this.cacheSkip[k].flush();
            if (s >= 0) {
                if (k == 0) {
                    if (this.prevQuantumBitLength < 0) {
                        this.bitsForQuantumBitLengths += (long)this.obs.writeLongDelta((long)quantumBitLength);
                        this.bitsForPositionsQuantumBitLengths += (long)this.obs.writeLongDelta((long)positionsQuantumBitLength);
                        this.bitsForEntryBitLengths += (long)this.obs.writeLongDelta((long)entryBitLength);
                    } else {
                        this.bitsForQuantumBitLengths += (long)this.obs.writeLongDelta((long)Fast.int2nat((int)(quantumBitLength - this.prevQuantumBitLength)));
                        this.bitsForPositionsQuantumBitLengths += (long)this.obs.writeLongDelta((long)Fast.int2nat((int)(positionsQuantumBitLength - this.prevPositionsQuantumBitLength)));
                        this.bitsForEntryBitLengths += (long)this.obs.writeLongDelta((long)Fast.int2nat((int)(entryBitLength - this.prevEntryBitLength)));
                    }
                    this.prevQuantumBitLength = quantumBitLength;
                    this.prevPositionsQuantumBitLength = positionsQuantumBitLength;
                    this.prevEntryBitLength = entryBitLength;
                    ++this.numberOfBlocks;
                }
                if (s > 0) {
                    this.obs.writeDelta(Fast.int2nat((int)((int)d - entryBitLength * (s + 1))));
                }
            }
            this.obs.write(this.cacheSkipByte[k].array, d);
            if (direct) {
                this.obs.write(buffer, (long)(pos * 8), (long)this.cacheDataLength[k]);
                pos += (this.cacheDataLength[k] + 7) / 8;
                continue;
            }
            this.cacheDataIn.read(buffer, 0, (this.cacheDataLength[k] + 7) / 8);
            this.obs.write(buffer, (long)this.cacheDataLength[k]);
        }
        for (k = 0; k <= this.cache - 1 >>> this.quantumDivisionShift; ++k) {
            this.cachePointerByte[k].reset();
            this.cachePointer[k].writtenBits(0L);
            this.cacheSkipByte[k].reset();
            this.cacheSkip[k].writtenBits(0L);
            this.cacheDataOut.position(0L);
            this.cacheDataOut.writtenBits(0L);
        }
        this.cache = 0;
    }

    @Override
    public long writtenBits() {
        return this.bitsForFrequencies + this.bitsForPointers + this.bitsForPayloads + this.bitsForCounts + this.bitsForPositions + this.bitsForPositionsOffsets + this.towerData.bitsForTowers() + this.bitsForQuantumBitLengths + this.bitsForVariableQuanta + this.bitsForPositionsQuantumBitLengths + this.bitsForEntryBitLengths;
    }

    @Override
    public Properties properties() {
        Properties result = new Properties();
        result.setProperty((Enum)Index.PropertyKeys.DOCUMENTS, this.numberOfDocuments);
        result.setProperty((Enum)Index.PropertyKeys.TERMS, this.currentTerm + 1);
        result.setProperty((Enum)Index.PropertyKeys.POSTINGS, this.numberOfPostings);
        result.setProperty((Enum)Index.PropertyKeys.MAXCOUNT, this.maxCount);
        result.setProperty((Enum)Index.PropertyKeys.INDEXCLASS, (Object)FileHPIndex.class.getName());
        result.setProperty((Enum)BitStreamIndex.PropertyKeys.SKIPQUANTUM, this.variableQuanta ? 0 : this.quantum);
        result.setProperty((Enum)BitStreamIndex.PropertyKeys.SKIPHEIGHT, this.height);
        for (Map.Entry e : this.flags.entrySet()) {
            if (e.getKey() == CompressionFlags.Component.PAYLOADS) continue;
            result.addProperty((Enum)Index.PropertyKeys.CODING, (Object)new MutableString().append(e.getKey()).append(':').append(e.getValue()));
        }
        return result;
    }

    @Override
    public void printStats(PrintStream stats) {
        super.printStats(stats);
        stats.println("Positions offsets: " + Util.format((long)this.bitsForPositionsOffsets) + " bits (" + Util.format((double)((double)this.bitsForPositionsOffsets / ((double)this.currentTerm + 1.0))) + " bits/list)");
        stats.println("Skip towers: " + Util.format((long)this.towerData.numberOfSkipTowers) + " (" + Util.format((long)(this.towerData.bitsForTowers() + this.bitsForVariableQuanta)) + " bits [" + Util.format((double)((double)(this.towerData.bitsForTowers() + this.bitsForVariableQuanta) * 100.0 / (double)this.bitsForListsWithTowers)) + "%, overall " + Util.format((double)((double)(this.towerData.bitsForTowers() + this.bitsForVariableQuanta) * 100.0 / (double)(this.obs.writtenBits() + this.positions.writtenBits()))) + "%], " + Util.format((double)((double)(this.towerData.bitsForTowers() + this.bitsForVariableQuanta) / (double)this.towerData.numberOfSkipTowers)) + " bits/tower)");
        stats.println("Skip entries: " + Util.format((long)this.towerData.numberOfEntries()) + " (" + Util.format((double)((double)this.towerData.bitsForEntries() / (double)this.towerData.numberOfEntries())) + " bits/entry)");
        stats.println("Skip tower lengths: " + Util.format((long)this.towerData.bitsForTowerLengths) + " bits (" + Util.format((double)(2.0 * (double)this.towerData.bitsForTowerLengths / (double)this.towerData.numberOfSkipTowers)) + " bits/tower)");
        stats.println("Quantum bit lengths: " + Util.format((long)this.bitsForQuantumBitLengths) + " bits (" + Util.format((double)((double)this.bitsForQuantumBitLengths / (double)this.numberOfBlocks)) + " bits/block)");
        stats.println("Positions quantum bit lengths: " + Util.format((long)this.bitsForPositionsQuantumBitLengths) + " bits (" + Util.format((double)((double)this.bitsForPositionsQuantumBitLengths / (double)this.numberOfBlocks)) + " bits/block)");
        if (this.variableQuanta) {
            stats.println("Variable quanta: " + Util.format((long)this.bitsForVariableQuanta) + " bits (" + Util.format((double)((double)this.bitsForVariableQuanta / ((double)this.currentTerm + 1.0))) + " bits/list)");
        }
        stats.println("Entry bit lengths: " + Util.format((long)this.bitsForEntryBitLengths) + " bits (" + Util.format((double)((double)this.bitsForEntryBitLengths / (double)this.numberOfBlocks)) + " bits/block)");
        stats.println("Top bit skips: " + Util.format((long)this.towerData.bitsForTopBitSkips) + " bits (" + Util.format((double)((double)this.towerData.bitsForTopBitSkips / (double)this.towerData.numberOfTopEntries)) + " bits/skip)");
        stats.println("Top positions bit skips: " + Util.format((long)this.towerData.bitsForTopPositionsBitSkips) + " bits (" + Util.format((double)((double)this.towerData.bitsForTopPositionsBitSkips / (double)this.towerData.numberOfTopEntries)) + " bits/skip)");
        stats.println("Top pointer skips: " + Util.format((long)this.towerData.bitsForTopSkipPointers) + " bits (" + Util.format((double)((double)this.towerData.bitsForTopSkipPointers / (double)this.towerData.numberOfTopEntries)) + " bits/skip)");
        stats.println("Lower bit skips: " + Util.format((long)this.towerData.bitsForLowerBitSkips) + " bits (" + Util.format((double)((double)this.towerData.bitsForLowerBitSkips / (double)this.towerData.numberOfLowerEntries)) + " bits/skip)");
        stats.println("Lower positions bit skips: " + Util.format((long)this.towerData.bitsForLowerPositionsBitSkips) + " bits (" + Util.format((double)((double)this.towerData.bitsForLowerPositionsBitSkips / (double)this.towerData.numberOfLowerEntries)) + " bits/skip)");
        stats.println("Lower pointer skips: " + Util.format((long)this.towerData.bitsForLowerSkipPointers) + " bits (" + Util.format((double)((double)this.towerData.bitsForLowerSkipPointers / (double)this.towerData.numberOfLowerEntries)) + " bits/skip)");
        stats.println("Bit skips: " + Util.format((long)this.towerData.bitsForBitSkips()) + " bits (" + Util.format((double)((double)this.towerData.bitsForBitSkips() / (double)this.towerData.numberOfEntries())) + " bits/skip)");
        stats.println("Positions bit skips: " + Util.format((long)this.towerData.bitsForPositionsBitSkips()) + " bits (" + Util.format((double)((double)this.towerData.bitsForPositionsBitSkips() / (double)this.towerData.numberOfEntries())) + " bits/skip)");
        stats.println("Pointer skips: " + Util.format((long)this.towerData.bitsForSkipPointers()) + " bits (" + Util.format((double)((double)this.towerData.bitsForSkipPointers() / (double)this.towerData.numberOfEntries())) + " bits/skip)");
    }

    public static class TowerData {
        public long bitsForTopBitSkips;
        public long bitsForTopPositionsBitSkips;
        public long bitsForTopSkipPointers;
        public long bitsForLowerBitSkips;
        public long bitsForLowerPositionsBitSkips;
        public long bitsForLowerSkipPointers;
        public long bitsForTowerLengths;
        public long numberOfSkipTowers;
        public long numberOfTopEntries;
        public long numberOfLowerEntries;

        void clear() {
            this.bitsForTopBitSkips = 0L;
            this.bitsForTopPositionsBitSkips = 0L;
            this.bitsForTopSkipPointers = 0L;
            this.bitsForLowerBitSkips = 0L;
            this.bitsForLowerPositionsBitSkips = 0L;
            this.bitsForLowerSkipPointers = 0L;
            this.bitsForTowerLengths = 0L;
            this.numberOfSkipTowers = 0L;
            this.numberOfTopEntries = 0L;
            this.numberOfLowerEntries = 0L;
        }

        public long bitsForSkipPointers() {
            return this.bitsForTopSkipPointers + this.bitsForLowerSkipPointers;
        }

        public long bitsForBitSkips() {
            return this.bitsForTopBitSkips + this.bitsForLowerBitSkips;
        }

        public long bitsForPositionsBitSkips() {
            return this.bitsForTopPositionsBitSkips + this.bitsForLowerPositionsBitSkips;
        }

        public long bitsForEntries() {
            return this.bitsForSkipPointers() + this.bitsForBitSkips() + this.bitsForPositionsBitSkips();
        }

        public long bitsForTowers() {
            return this.bitsForTowerLengths + this.bitsForEntries();
        }

        public long numberOfEntries() {
            return this.numberOfTopEntries + this.numberOfLowerEntries;
        }
    }
}

